/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tools;

import gregtech.GTMod;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.SoundResource;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTToolHarvestHelper;
import gregtech.api.util.GTUtility;
import gregtech.common.items.behaviors.BehaviourProspecting;
import gregtech.common.tools.GTTool;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.world.BlockEvent;

public class ToolHardHammer
extends GTTool {
    public static final List<String> mEffectiveList = Arrays.asList(EntityIronGolem.class.getName(), "EntityTowerGuardian");

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        String tName = aEntity.getClass().getName();
        return mEffectiveList.contains(tName = tName.substring(tName.lastIndexOf(46) + 1)) || tName.contains("Golem") ? aOriginalDamage * 2.0f : aOriginalDamage;
    }

    @Override
    public int getToolDamagePerBlockBreak() {
        return 50;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 200;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 400;
    }

    @Override
    public float getBaseDamage() {
        return 3.0f;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance * 2;
    }

    @Override
    public float getSpeedMultiplier() {
        return 0.75f;
    }

    @Override
    public String getCraftingSound() {
        return SoundResource.RANDOM_ANVIL_USE.toString();
    }

    @Override
    public String getBreakingSound() {
        return SoundResource.RANDOM_ANVIL_BREAK.toString();
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    @Override
    public boolean isWeapon() {
        return true;
    }

    @Override
    public boolean isMinableBlock(Block aBlock, int aMetaData) {
        return GTToolHarvestHelper.isAppropriateTool(aBlock, aMetaData, "hammer", "pickaxe") || GTToolHarvestHelper.isAppropriateMaterial(aBlock, Material.field_151576_e, Material.field_151592_s, Material.field_151588_w, Material.field_151598_x) || RecipeMaps.hammerRecipes.containsInput(new ItemStack(aBlock, 1, aMetaData));
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, int aX, int aY, int aZ, int aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        int rConversions = 0;
        GTRecipe tRecipe = RecipeMaps.hammerRecipes.findRecipeQuery().items(new ItemStack(aBlock, 1, aMetaData)).notUnificated(true).find();
        if (tRecipe == null || aBlock.hasTileEntity(aMetaData)) {
            for (ItemStack tDrop : aDrops) {
                ItemStack tHammeringOutput;
                tRecipe = RecipeMaps.hammerRecipes.findRecipeQuery().items(GTUtility.copyAmount(1, tDrop)).notUnificated(true).find();
                if (tRecipe == null || (tHammeringOutput = tRecipe.getOutput(0)) == null) continue;
                rConversions += tDrop.field_77994_a;
                tDrop.field_77994_a *= tHammeringOutput.field_77994_a;
                tHammeringOutput.field_77994_a = tDrop.field_77994_a;
                GTUtility.setStack(tDrop, tHammeringOutput);
            }
        } else {
            aDrops.clear();
            aDrops.add(tRecipe.getOutput(0));
            ++rConversions;
        }
        return rConversions;
    }

    @Override
    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.toolHeadHammer.mTextureIndex] : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mIconSet.mTextures[OrePrefixes.stick.mTextureIndex];
    }

    @Override
    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return aIsToolHead ? MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mRGBa : MetaGeneratedTool.getSecondaryMaterial((ItemStack)aStack).mRGBa;
    }

    @Override
    public void onStatsAddedToTool(MetaGeneratedTool aItem, int aID) {
        aItem.addItemBehavior(aID, new BehaviourProspecting(1, 1000));
    }

    @Override
    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity) {
        return new ChatComponentText(EnumChatFormatting.RED + aEntity.func_70005_c_() + EnumChatFormatting.WHITE + " was squashed by " + EnumChatFormatting.GREEN + aPlayer.func_70005_c_() + EnumChatFormatting.WHITE);
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        super.onToolCrafted(aStack, aPlayer);
        try {
            GTMod.achievements.issueAchievement(aPlayer, "tools");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

