/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.HeatingCoilLevel;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.MTEEnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class MTEPyrolyseOven
extends MTEEnhancedMultiBlockBase<MTEPyrolyseOven>
implements ISurvivalConstructable {
    private HeatingCoilLevel coilHeat;
    private static final int CASING_INDEX = 1090;
    private static final IStructureDefinition<MTEPyrolyseOven> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", StructureUtility.transpose((String[][])new String[][]{{"ccccc", "ctttc", "ctttc", "ctttc", "ccccc"}, {"ccccc", "c---c", "c---c", "c---c", "ccccc"}, {"ccccc", "c---c", "c---c", "c---c", "ccccc"}, {"bb~bb", "bCCCb", "bCCCb", "bCCCb", "bbbbb"}})).addElement('c', StructureUtility.onElementPass(MTEPyrolyseOven::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsNH, (int)2))).addElement('C', GTStructureUtility.activeCoils(GTStructureUtility.ofCoil(MTEPyrolyseOven::setCoilLevel, MTEPyrolyseOven::getCoilLevel))).addElement('b', GTStructureUtility.buildHatchAdder(MTEPyrolyseOven.class).atLeast(HatchElement.OutputBus, HatchElement.OutputHatch, HatchElement.Energy, HatchElement.Maintenance).casingIndex(1090).dot(1).buildAndChain(StructureUtility.onElementPass(MTEPyrolyseOven::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsNH, (int)2)))).addElement('t', GTStructureUtility.buildHatchAdder(MTEPyrolyseOven.class).atLeast(HatchElement.InputBus, HatchElement.InputHatch, HatchElement.Muffler).casingIndex(1090).dot(1).buildAndChain(StructureUtility.onElementPass(MTEPyrolyseOven::onCasingAdded, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasingsNH, (int)2)))).build();
    private int mCasingAmount;

    public MTEPyrolyseOven(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEPyrolyseOven(String aName) {
        super(aName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Coke Oven").addInfo("Industrial Charcoal producer").addInfo("Processing speed scales linearly with Coil tier:").addInfo("CuNi: 50%, FeAlCr: 100%, Ni4Cr: 150%, TPV: 200%, etc.").addInfo("EU/t is not affected by Coil tier").addPollutionAmount(this.getPollutionPerSecond(null)).beginStructureBlock(5, 4, 5, true).addController("Front center").addCasingInfoRange("Pyrolyse Oven Casing", 60, 80, false).addOtherStructurePart("Heating Coils", "Center 3x1x3 of the bottom layer").addEnergyHatch("Any bottom layer casing", 1).addMaintenanceHatch("Any bottom layer casing", 1).addMufflerHatch("Center 3x1x3 area in top layer", 2).addInputBus("Center 3x1x3 area in top layer", 2).addInputHatch("Center 3x1x3 area in top layer", 2).addOutputBus("Any bottom layer casing", 1).addOutputHatch("Any bottom layer casing", 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1090), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1090), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_PYROLYSE_OVEN_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(1090)};
    }

    @Override
    public boolean supportsSingleRecipeLocking() {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.pyrolyseRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            public CheckRecipeResult process() {
                this.setSpeedBonus(2.0f / (float)(1 + MTEPyrolyseOven.this.coilHeat.getTier()));
                return super.process();
            }
        };
    }

    @Override
    public IStructureDefinition<MTEPyrolyseOven> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    private void onCasingAdded() {
        ++this.mCasingAmount;
    }

    public HeatingCoilLevel getCoilLevel() {
        return this.coilHeat;
    }

    private void setCoilLevel(HeatingCoilLevel aCoilLevel) {
        this.coilHeat = aCoilLevel;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.coilHeat = HeatingCoilLevel.None;
        this.mCasingAmount = 0;
        return this.checkPiece("main", 2, 3, 0) && this.mCasingAmount >= 60 && this.mMaintenanceHatches.size() == 1 && !this.mMufflerHatches.isEmpty();
    }

    @Override
    public int getPollutionPerSecond(ItemStack aStack) {
        return GTMod.proxy.mPollutionPyrolyseOvenPerSecond;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPyrolyseOven(this.mName);
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece("main", stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivalBuildPiece("main", stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    @Override
    public boolean supportsInputSeparation() {
        return true;
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (aPlayer.func_70093_af()) {
            boolean bl = this.batchMode = !this.batchMode;
            if (this.batchMode) {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOn"));
            } else {
                GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"misc.BatchModeTextOff"));
            }
            return true;
        }
        return false;
    }
}

