/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.google.common.primitives.Ints;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.MachineType;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.objects.overclockdescriber.EUOverclockDescriber;
import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.api.util.OverclockCalculator;
import gregtech.common.config.MachineStats;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;

public class MTEMassfabricator
extends MTEBasicMachine {
    public static int sUUAperUUM = 1;
    public static int sUUASpeedBonus = 4;
    public static int sDurationMultiplier = 3215;
    public static boolean sRequiresUUA = false;
    public static int BASE_EUT = 256;
    public static GTRecipe nonUUARecipe;
    public static GTRecipe uuaRecipe;

    public MTEMassfabricator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 8, MachineType.MATTER_FABRICATOR.tooltipDescription(), 1, 1, TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_SIDE_MASSFAB), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_SIDE_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_FRONT_MASSFAB), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_MASSFAB_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_TOP_MASSFAB), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_TOP_MASSFAB_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_ACTIVE_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_BOTTOM_MASSFAB_GLOW).glow().build()));
    }

    public MTEMassfabricator(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 8, aDescription, aTextures, 1, 1);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMassfabricator(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowSelectCircuit() {
        return true;
    }

    @Override
    protected OverclockDescriber createOverclockDescriber() {
        return new MassfabricatorOverclockDescriber(this.mTier, this.mAmperage);
    }

    @Override
    public void onConfigLoad() {
        super.onConfigLoad();
        sDurationMultiplier = MachineStats.massFabricator.durationMultiplier;
        sUUAperUUM = MachineStats.massFabricator.UUAPerUUM;
        sUUASpeedBonus = MachineStats.massFabricator.UUASpeedBonus;
        sRequiresUUA = MachineStats.massFabricator.requiresUUA;
        Materials.UUAmplifier.mChemicalFormula = "Mass Fabricator Eff/Speed Bonus: x" + sUUASpeedBonus;
    }

    @Override
    public long maxAmperesIn() {
        return 10L;
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 512L;
    }

    @Override
    public int checkRecipe() {
        FluidStack tFluid = this.getDrainableStack();
        if (tFluid == null || tFluid.amount < this.getCapacity()) {
            this.mOutputFluid = Materials.UUMatter.getFluid(1L);
            this.calculateCustomOverclock(this.containsUUA(this.getFillableStack()) ? uuaRecipe : nonUUARecipe);
            if (this.mMaxProgresstime == 0x7FFFFFFE && this.mEUt == 0x7FFFFFFE) {
                return 1;
            }
            tFluid = this.getFillableStack();
            if (this.containsUUA(tFluid)) {
                tFluid.amount -= sUUAperUUM;
                return 2;
            }
            return sRequiresUUA || Arrays.stream(this.getAllInputs()).anyMatch(s -> ItemList.Circuit_Integrated.isStackEqual(s, true, true)) ? 1 : 2;
        }
        return 0;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.massFabFakeRecipes;
    }

    @Override
    public boolean isFluidInputAllowed(FluidStack aFluid) {
        return aFluid.isFluidEqual(Materials.UUAmplifier.getFluid(1L));
    }

    @Override
    public int getCapacity() {
        return Math.max(sUUAperUUM, 1000);
    }

    private boolean containsUUA(FluidStack aFluid) {
        return aFluid != null && aFluid.amount >= sUUAperUUM && aFluid.isFluidEqual(Materials.UUAmplifier.getFluid(1L));
    }

    @ParametersAreNonnullByDefault
    @MethodsReturnNonnullByDefault
    protected class MassfabricatorOverclockDescriber
    extends EUOverclockDescriber {
        protected MassfabricatorOverclockDescriber(byte tier, int amperage) {
            super(tier, amperage);
        }

        @Override
        public OverclockCalculator createCalculator(OverclockCalculator template, GTRecipe recipe) {
            return super.createCalculator(template, recipe).setEUt(Ints.saturatedCast((long)(GTValues.V[this.tier] * (long)this.amperage))).setEUtIncreasePerOC(2.0).setMaxOverclocks(this.tier - 1);
        }

        @Override
        protected boolean shouldShowAmperage(OverclockCalculator calculator) {
            return true;
        }

        @Override
        protected String getVoltageString(OverclockCalculator calculator) {
            long voltage = GTValues.V[MTEMassfabricator.this.mTier];
            String voltageString = StatCollector.func_74837_a((String)"GT5U.nei.display.voltage", (Object[])new Object[]{GTUtility.formatNumbers(voltage), GTUtility.getTierNameWithParentheses(voltage)});
            if (this.wasOverclocked(calculator)) {
                voltageString = voltageString + StatCollector.func_74838_a((String)"GT5U.nei.display.overclock");
            }
            return voltageString;
        }

        @Override
        protected String getAmperageString(OverclockCalculator calculator) {
            int amperage = this.amperage;
            int denominator = 1;
            for (int i = 1; i < MTEMassfabricator.this.mTier; ++i) {
                if ((amperage >>= 1) != 0) continue;
                denominator <<= 1;
            }
            String amperageValue = amperage > 0 ? GTUtility.formatNumbers(amperage) : "1/" + denominator;
            return StatCollector.func_74837_a((String)"GT5U.nei.display.amperage", (Object[])new Object[]{amperageValue});
        }
    }
}

