/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.handlers;

import com.google.common.math.BigIntegerMath;
import com.gtnewhorizons.modularui.api.GlStateManager;
import com.gtnewhorizons.modularui.api.drawable.GuiHelper;
import com.gtnewhorizons.modularui.api.drawable.Text;
import com.gtnewhorizons.modularui.api.math.Color;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.common.handlers.PowerGogglesConfigHandler;
import gregtech.common.items.ItemPowerGoggles;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.opengl.GL11;

public class PowerGogglesHudHandler {
    public static boolean updateClient = false;
    private static final int TICKS = 1;
    private static final int SECONDS = 20;
    private static final int MINUTES = 1200;
    static List<Text> hudList = new ArrayList<Text>();
    static LinkedList<BigInteger> measurements = new LinkedList();
    static Minecraft mc = Minecraft.func_71410_x();
    public static final int ticksBetweenMeasurements = 100;
    static final int measurementCount5m = 60;
    static final int measurementCount1h = 720;
    static BigInteger currentEU = BigInteger.valueOf(0L);
    static BigInteger measurement = BigInteger.valueOf(0L);
    static BigInteger highest = BigInteger.valueOf(0L);
    static long capacity = 0L;
    static int change5mColor;
    static int change1hColor;
    static String storage;
    static String change5mString;
    static String change1hString;
    static BigInteger change5m;
    static BigInteger change1h;
    static int change5mDiff;
    static int change1hDiff;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHUD(RenderGameOverlayEvent.Post event) {
        if (event.type != RenderGameOverlayEvent.ElementType.ALL || PowerGogglesHudHandler.mc.field_71474_y.field_74330_P || PowerGogglesConfigHandler.hideWhenChatOpen && PowerGogglesHudHandler.mc.field_71462_r instanceof GuiChat) {
            return;
        }
        if (ItemPowerGoggles.getEquippedPowerGoggles((EntityLivingBase)PowerGogglesHudHandler.mc.field_71439_g) == null) {
            return;
        }
        ScaledResolution resolution = event.resolution;
        int screenHeight = resolution.func_78328_b();
        int screenWidth = resolution.func_78326_a();
        FontRenderer fontRenderer = PowerGogglesHudHandler.mc.field_71466_p;
        GL11.glPushMatrix();
        GL11.glEnable((int)2884);
        int xOffset = PowerGogglesConfigHandler.mainOffsetX;
        int yOffset = PowerGogglesConfigHandler.mainOffsetY;
        int w = PowerGogglesConfigHandler.rectangleWidth;
        int h = PowerGogglesConfigHandler.rectangleHeight;
        int borderRadius = 3;
        double subScale = PowerGogglesConfigHandler.subTextScaling;
        int gapBetweenLines = 2;
        int scaleOffsetX = xOffset - borderRadius;
        int scaleOffsetY = screenHeight - yOffset + gapBetweenLines * 2 + (int)((double)(fontRenderer.field_78288_b * 2) * subScale) + borderRadius;
        GL11.glTranslated((double)scaleOffsetX, (double)scaleOffsetY, (double)0.0);
        GL11.glScaled((double)PowerGogglesConfigHandler.hudScale, (double)PowerGogglesConfigHandler.hudScale, (double)1.0);
        GL11.glTranslated((double)(-scaleOffsetX), (double)(-scaleOffsetY), (double)0.0);
        int chartOffsetY = PowerGogglesHudHandler.drawPowerRectangle(xOffset, yOffset, h, w, screenHeight, borderRadius);
        if (PowerGogglesConfigHandler.showPowerChart) {
            this.drawPowerChart(xOffset, chartOffsetY - borderRadius, PowerGogglesConfigHandler.rectangleWidth, 100, screenHeight, screenWidth, borderRadius);
        }
        GL11.glPopMatrix();
    }

    private static int drawPowerRectangle(int xOffset, int yOffset, int w, int h, int screenHeight, int borderRadius) {
        int left = h + xOffset;
        int up = screenHeight - h - yOffset;
        int right = left + w;
        int down = up + h;
        GL11.glPushMatrix();
        GL11.glTranslated((double)left, (double)down, (double)0.0);
        GL11.glRotated((double)90.0, (double)0.0, (double)0.0, (double)-1.0);
        GL11.glTranslated((double)(-left), (double)(-down), (double)0.0);
        double scale = 3.3;
        double severity = measurement.compareTo(BigInteger.ZERO) == 0 ? 0.0 : (double)((float)new BigDecimal(change5m.multiply(BigInteger.valueOf(100L))).divide(new BigDecimal(measurement), RoundingMode.FLOOR).intValue() / 100.0f);
        int[] gradientSet = new int[]{PowerGogglesConfigHandler.gradientBadColor, PowerGogglesConfigHandler.gradientOkColor, PowerGogglesConfigHandler.gradientGoodColor};
        if (severity < 0.0) {
            int[] gradients = PowerGogglesHudHandler.getGradient(-severity, scale, gradientSet[0], gradientSet[1]);
            GuiHelper.drawGradientRect((float)300.0f, (float)left, (float)up, (float)right, (float)down, (int)gradients[0], (int)gradients[1]);
        } else {
            int[] gradients = PowerGogglesHudHandler.getGradient(severity, scale * (double)1.4f, gradientSet[2], gradientSet[1]);
            GuiHelper.drawGradientRect((float)300.0f, (float)left, (float)up, (float)right, (float)down, (int)gradients[1], (int)gradients[0]);
        }
        GL11.glDisable((int)2896);
        GL11.glPopMatrix();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int gapBetweenLines = 2;
        double mainScale = PowerGogglesConfigHandler.mainTextScaling;
        double subScale = PowerGogglesConfigHandler.subTextScaling;
        int bgColor = Color.argb((int)47, (int)20, (int)76, (int)216);
        int highestPoint = screenHeight - yOffset - w - gapBetweenLines - (int)((double)fontRenderer.field_78288_b * mainScale) - borderRadius;
        GuiHelper.drawGradientRect((float)-1.0f, (float)(xOffset - borderRadius), (float)highestPoint, (float)(xOffset + h + borderRadius), (float)(screenHeight - yOffset + gapBetweenLines * 2 + (int)((double)(fontRenderer.field_78288_b * 2) * subScale) + borderRadius), (int)bgColor, (int)bgColor);
        storage = PowerGogglesHudHandler.toFormatted(currentEU) + " EU";
        change5mString = "5m: " + PowerGogglesHudHandler.toFormatted(change5m) + " EU " + (change5mDiff != 0 ? String.format("(%s eu/t) ", PowerGogglesHudHandler.toFormatted(change5m.divide(measurements.isEmpty() ? BigInteger.ONE : BigInteger.valueOf(Math.min(measurements.size() * 100, 6000))))) : "");
        change1hString = "1h: " + PowerGogglesHudHandler.toFormatted(change1h) + " EU " + (change1hDiff != 0 ? String.format("(%s eu/t)", PowerGogglesHudHandler.toFormatted(change1h.divide(measurements.isEmpty() ? BigInteger.ONE : BigInteger.valueOf(Math.min(measurements.size() * 100, 72000))))) : "");
        switch (PowerGogglesConfigHandler.readingIndex) {
            case 1: {
                change5mString = "5m: " + PowerGogglesHudHandler.toFormatted(change5m) + " EU";
                change1hString = "1h: " + PowerGogglesHudHandler.toFormatted(change1h) + " EU";
                break;
            }
            case 2: {
                change5mString = "5m: " + (change5mDiff != 0 ? String.format("(%s EU/t) ", PowerGogglesHudHandler.toFormatted(change5m.divide(BigInteger.valueOf(Math.min(measurements.size() * 100, 6000))))) : "0 EU/t");
                change1hString = "1h: " + (change1hDiff != 0 ? String.format("(%s EU/t)", PowerGogglesHudHandler.toFormatted(change1h.divide(BigInteger.valueOf(Math.min(measurements.size() * 100, 72000))))) : "0 EU/t");
                break;
            }
        }
        String percentage = measurement.compareTo(BigInteger.ZERO) == 0 || highest.compareTo(BigInteger.ZERO) == 0 ? "0%" : String.format("%.2f%%", Float.valueOf(100.0f * measurement.floatValue() / (capacity > 0L ? (float)capacity : highest.floatValue())));
        PowerGogglesHudHandler.drawScaledString(fontRenderer, storage, xOffset, screenHeight - yOffset - w - gapBetweenLines - (int)((double)fontRenderer.field_78288_b * mainScale), change5mColor, mainScale);
        PowerGogglesHudHandler.drawScaledString(fontRenderer, percentage, xOffset + (int)((double)h - (double)fontRenderer.func_78256_a(percentage) * PowerGogglesConfigHandler.mainTextScaling), screenHeight - yOffset - w - gapBetweenLines - (int)((double)fontRenderer.field_78288_b * mainScale), change5mColor, mainScale);
        PowerGogglesHudHandler.drawScaledString(fontRenderer, change5mString, xOffset, screenHeight - yOffset + gapBetweenLines, change5mColor, subScale);
        PowerGogglesHudHandler.drawScaledString(fontRenderer, change1hString, xOffset, screenHeight - yOffset + gapBetweenLines * 2 + (int)((double)fontRenderer.field_78288_b * subScale), change1hColor, subScale);
        return highestPoint;
    }

    private void drawPowerChart(int xOffset, int yOffset, int chartWidth, int chartHeight, int screenHeight, int screenWidth, int borderRadius) {
        int readings = Math.min(measurements.size(), 60);
        int left = xOffset;
        int right = xOffset + chartWidth;
        int top = yOffset - chartHeight;
        int bottom = yOffset;
        int bgColor = Color.argb((int)19, (int)14, (int)91, (int)191);
        GuiHelper.drawGradientRect((float)-1.0f, (float)left, (float)top, (float)right, (float)bottom, (int)bgColor, (int)bgColor);
        int borderColor = Color.rgb((int)81, (int)79, (int)104);
        GuiHelper.drawGradientRect((float)-2.0f, (float)(left - borderRadius), (float)(top - borderRadius), (float)(right + borderRadius), (float)(bottom + borderRadius), (int)borderColor, (int)borderColor);
        if (measurements.isEmpty()) {
            return;
        }
        BigInteger minReading = measurements.get(0);
        BigInteger maxReading = measurements.get(0);
        for (int i = 0; i < readings; ++i) {
            BigInteger temp = measurements.get(i);
            if (temp.compareTo(minReading) < 0) {
                minReading = temp;
            }
            if (maxReading.compareTo(temp) >= 0) continue;
            maxReading = temp;
        }
        int exponent = minReading.compareTo(BigInteger.ZERO) == 0 ? 0 : BigIntegerMath.log10((BigInteger)minReading, (RoundingMode)RoundingMode.DOWN);
        minReading = minReading.compareTo(BigInteger.ZERO) == 0 ? BigInteger.ZERO : BigInteger.valueOf(10L).pow(exponent);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        double scale = 0.5;
        PowerGogglesHudHandler.drawScaledString(fontRenderer, PowerGogglesHudHandler.toFormatted(minReading), xOffset, yOffset - (int)((double)fontRenderer.field_78288_b * scale), Color.rgb((int)237, (int)2, (int)158), scale);
        PowerGogglesHudHandler.drawScaledString(fontRenderer, minReading.compareTo(maxReading) == 0 ? "" : PowerGogglesHudHandler.toFormatted(maxReading), xOffset, yOffset - chartHeight, Color.rgb((int)237, (int)2, (int)158), scale);
        if (readings < 2) {
            return;
        }
        GL11.glPushAttrib((int)1048575);
        GlStateManager.disableTexture2D();
        GlStateManager.enableBlend();
        GlStateManager.disableAlpha();
        GlStateManager.tryBlendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.shadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78371_b(1);
        int negative = PowerGogglesConfigHandler.textBadColor;
        int positive = PowerGogglesConfigHandler.textGoodColor;
        BigInteger lastReading = measurements.get(0);
        double pointsWidth = (double)chartWidth * 0.8;
        double lastX = xOffset + chartWidth;
        double lastY = (float)yOffset + (float)chartHeight * (-1.0f + Math.min(1.0f, 1.0f - lastReading.subtract(minReading).floatValue() / maxReading.subtract(minReading).floatValue()));
        for (int i = 1; i < readings; ++i) {
            BigInteger reading = measurements.get(i);
            double x = (double)(xOffset + chartWidth) - pointsWidth / (double)readings * (double)i;
            double y = (float)yOffset + (float)chartHeight * (-1.0f + Math.min(1.0f, 1.0f - reading.subtract(minReading).floatValue() / maxReading.subtract(minReading).floatValue()));
            if (reading.compareTo(lastReading) > 0) {
                tessellator.func_78369_a((float)Color.getRed((int)negative), (float)Color.getGreen((int)negative), (float)Color.getBlue((int)negative), 255.0f);
            } else {
                tessellator.func_78369_a((float)Color.getRed((int)positive), (float)Color.getGreen((int)positive), (float)Color.getBlue((int)positive), 255.0f);
            }
            lastReading = reading;
            tessellator.func_78377_a(lastX, lastY, 0.0);
            tessellator.func_78377_a(x, y, 0.0);
            lastX = x;
            lastY = y;
        }
        tessellator.func_78381_a();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
        GlStateManager.enableAlpha();
        GlStateManager.enableTexture2D();
        GL11.glPopAttrib();
    }

    private static void drawScaledString(FontRenderer fontRenderer, String string, int xOffset, int yOffset, int color, double scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)xOffset, (double)yOffset, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)1.0);
        GL11.glTranslated((double)(-xOffset), (double)(-yOffset), (double)0.0);
        fontRenderer.func_78261_a(string, xOffset, yOffset, color);
        GL11.glPopMatrix();
    }

    public static void setMeasurement(BigInteger newEU, long lscCapacity) {
        capacity = lscCapacity;
        PowerGogglesHudHandler.setMeasurement(newEU);
    }

    public static void setMeasurement(BigInteger newEU) {
        measurement = newEU;
        if (highest.compareTo(measurement) < 0) {
            highest = measurement;
        }
        currentEU = measurement;
        measurements.addFirst(measurement);
        if (measurements.size() > 720) {
            measurements.removeLast();
        }
    }

    public static int[] getGradient(double severity, double scale, int gradientLeft, int gradientRight) {
        int newGradientLeft = gradientLeft;
        int newGradientRight = gradientRight;
        int diffRed = Color.getRed((int)gradientLeft) - Color.getRed((int)gradientRight);
        int diffGreen = Color.getGreen((int)gradientLeft) - Color.getGreen((int)gradientRight);
        int diffBlue = Color.getBlue((int)gradientLeft) - Color.getBlue((int)gradientRight);
        int newLeftRed = Math.min(255, Math.max(0, Color.getRed((int)gradientRight) + (int)((double)diffRed * Math.min(1.0, severity * scale))));
        int newLeftGreen = Math.min(255, Math.max(0, Color.getGreen((int)gradientRight) + (int)((double)diffGreen * Math.min(1.0, severity * scale))));
        int newLeftBlue = Math.min(255, Math.max(0, Color.getBlue((int)gradientRight) + (int)((double)diffBlue * Math.min(1.0, severity * scale))));
        int newRightRed = Math.min(255, Math.max(0, Color.getRed((int)gradientRight) + (int)((double)diffRed * Math.min(1.0, severity * scale * 0.75))));
        int newRightGreen = Math.min(255, Math.max(0, Color.getGreen((int)gradientRight) + (int)((double)diffGreen * Math.min(1.0, severity * scale * 0.75))));
        int newRightBlue = Math.min(255, Math.max(0, Color.getBlue((int)gradientRight) + (int)((double)diffBlue * Math.min(1.0, severity * scale * 0.75))));
        newGradientLeft = Color.rgb((int)newLeftRed, (int)newLeftGreen, (int)newLeftBlue);
        newGradientRight = Color.rgb((int)newRightRed, (int)newRightGreen, (int)newRightBlue);
        return new int[]{newGradientLeft, newGradientRight};
    }

    @SideOnly(value=Side.CLIENT)
    public static void drawTick() {
        updateClient = false;
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        change5m = PowerGogglesHudHandler.getTotalChange(measurements, 60);
        change5mDiff = change5m.compareTo(BigInteger.valueOf(0L));
        change5mColor = PowerGogglesHudHandler.getColor(change5mDiff);
        change1h = PowerGogglesHudHandler.getTotalChange(measurements, 720);
        change1hDiff = change1h.compareTo(BigInteger.valueOf(0L));
        change1hColor = PowerGogglesHudHandler.getColor(change5mDiff);
        hudList = new ArrayList<Text>();
        storage = PowerGogglesHudHandler.toFormatted(currentEU) + " EU";
        change5mString = "5m: " + PowerGogglesHudHandler.toFormatted(change5m) + " EU " + (change5mDiff != 0 ? String.format(" (%s eu/t) ", PowerGogglesHudHandler.toFormatted(change5m.divide(BigInteger.valueOf(Math.min(Math.min(1, measurements.size() * 100), 6000))))) : "");
        change1hString = "1h: " + PowerGogglesHudHandler.toFormatted(change1h) + " EU " + (change1hDiff != 0 ? String.format(" (%s eu/t)", PowerGogglesHudHandler.toFormatted(change1h.divide(BigInteger.valueOf(Math.min(measurements.size() * 100, 72000))))) : "");
    }

    private static String toFormatted(BigInteger EU) {
        switch (PowerGogglesConfigHandler.formatIndex) {
            case 1: {
                return PowerGogglesHudHandler.toCustom(EU);
            }
            case 2: {
                return PowerGogglesHudHandler.toCustom(EU, true, 3);
            }
        }
        return PowerGogglesHudHandler.toCustom(EU, false, 1);
    }

    private static String toCustom(BigInteger EU) {
        return PowerGogglesHudHandler.toCustom(EU, false, 3);
    }

    private static String toCustom(BigInteger EU, boolean useSI, int baseDigits) {
        String[] suffixes = new String[]{"", "K", "M", "G", "T", "P", "E", "Z", "Y", "R", "Q"};
        if (EU.abs().compareTo(BigInteger.valueOf(1L)) < 0) {
            return "0";
        }
        int exponent = BigIntegerMath.log10((BigInteger)EU.abs(), (RoundingMode)RoundingMode.FLOOR);
        int remainder = exponent % baseDigits;
        String euString = EU.toString();
        if (EU.abs().compareTo(BigInteger.valueOf(1000L)) < 0) {
            return euString;
        }
        int negative = EU.compareTo(BigInteger.valueOf(1L)) < 0 ? 1 : 0;
        String base = euString.substring(0, remainder + 1 + negative);
        String decimal = euString.substring(remainder + 1 + negative, Math.min(exponent, remainder + 4));
        int E = exponent - remainder;
        if (useSI && E / 3 <= suffixes.length - 1) {
            return String.format("%s.%s%s", base, decimal, suffixes[E / 3]);
        }
        return String.format("%s.%sE%d", base, decimal, E);
    }

    private static BigInteger getTotalChange(LinkedList<BigInteger> list, int count) {
        if (list.isEmpty()) {
            return BigInteger.valueOf(0L);
        }
        return list.get(0).subtract(list.get(Math.min(count, list.size() - 1)));
    }

    private static int getColor(int compareResult) {
        if (compareResult == 0) {
            return PowerGogglesConfigHandler.textOkColor;
        }
        if (compareResult < 0) {
            return PowerGogglesConfigHandler.textBadColor;
        }
        return PowerGogglesConfigHandler.textGoodColor;
    }

    public static void clear() {
        measurements.clear();
        currentEU = BigInteger.valueOf(0L);
        measurement = BigInteger.valueOf(0L);
        highest = BigInteger.valueOf(0L);
        capacity = 0L;
        change5mDiff = 0;
        change1hDiff = 0;
        PowerGogglesHudHandler.updateColors();
    }

    public static void updateColors() {
        change5mColor = PowerGogglesHudHandler.getColor(change5mDiff);
        change1hColor = PowerGogglesHudHandler.getColor(change1hDiff);
    }

    static {
        storage = "";
        change5mString = "";
        change1hString = "";
        change5m = BigInteger.valueOf(0L);
        change1h = BigInteger.valueOf(0L);
    }
}

