/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.handlers;

import appeng.api.util.DimensionalCoord;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.net.GTPacketLinkPowerGoggles;
import gregtech.api.net.GTPacketUpdatePowerGoggles;
import gregtech.common.handlers.PowerGogglesConfigHandler;
import gregtech.common.handlers.PowerGogglesHudHandler;
import gregtech.common.handlers.PowerGogglesKeybindHandler;
import gregtech.common.items.ItemPowerGoggles;
import gregtech.common.items.gui.PowerGogglesGuiHudConfig;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kekztech.common.tileentities.MTELapotronicSuperCapacitor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldServer;

public class PowerGogglesEventHandler {
    private static int ticks = 0;
    public static Minecraft mc;
    public static Map<UUID, DimensionalCoord> lscLinkMap;
    public static boolean forceUpdate;
    public static boolean forceRefresh;
    public static boolean firstClientTick;

    @SubscribeEvent
    public void playerTickEnd(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side == Side.CLIENT) {
            this.doClientStuff(event);
        } else {
            this.doServerStuff(event);
        }
    }

    private void doClientStuff(TickEvent.PlayerTickEvent event) {
        if (firstClientTick) {
            ItemStack bauble = ItemPowerGoggles.getEquippedPowerGoggles((EntityLivingBase)event.player);
            if (bauble != null) {
                this.setLink(bauble);
            }
            firstClientTick = false;
        }
        if (forceUpdate || PowerGogglesHudHandler.updateClient) {
            PowerGogglesHudHandler.drawTick();
        }
        forceUpdate = false;
    }

    private void doServerStuff(TickEvent.PlayerTickEvent event) {
        ++ticks;
        ticks %= 100;
        if (forceUpdate) {
            ticks = 1;
        }
        if (ticks != 1) {
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)event.player;
        if (PowerGogglesEventHandler.isValidLink(player, lscLinkMap.get(player.func_110124_au()))) {
            MTELapotronicSuperCapacitor lsc = this.getLsc(player);
            GTValues.NW.sendToPlayer(new GTPacketUpdatePowerGoggles(BigInteger.valueOf(lsc.getEUVar()), lsc.maxEUStore(), forceRefresh), player);
        } else {
            if (lscLinkMap.get(player.func_110124_au()) != null) {
                lscLinkMap.put(player.func_110124_au(), null);
                forceRefresh = true;
            }
            GTValues.NW.sendToPlayer(new GTPacketUpdatePowerGoggles(WirelessNetworkManager.getUserEU(player.func_110124_au()), forceRefresh), player);
        }
        forceUpdate = false;
        forceRefresh = false;
    }

    private MTELapotronicSuperCapacitor getLsc(EntityPlayerMP player) {
        DimensionalCoord coords = lscLinkMap.get(player.func_110124_au());
        WorldServer lscDim = player.field_71133_b.func_71218_a(coords.getDimension());
        TileEntity tileEntity = lscDim.func_147438_o(coords.x, coords.y, coords.z);
        return (MTELapotronicSuperCapacitor)((IGregTechTileEntity)tileEntity).getMetaTileEntity();
    }

    @SubscribeEvent
    public void clientOnPlayerConnect(FMLNetworkEvent.ClientConnectedToServerEvent event) {
    }

    @SubscribeEvent
    public void clientOnPlayerDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        PowerGogglesHudHandler.clear();
        firstClientTick = true;
    }

    @SubscribeEvent
    public void serverOnPlayerConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (PowerGogglesKeybindHandler.openConfigGui.func_151468_f()) {
            Minecraft screenInfo = Minecraft.func_71410_x();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new PowerGogglesGuiHudConfig(screenInfo.field_71443_c, screenInfo.field_71440_d));
        } else if (PowerGogglesKeybindHandler.toggleChart.func_151468_f()) {
            PowerGogglesConfigHandler.showPowerChart = !PowerGogglesConfigHandler.showPowerChart;
            PowerGogglesConfigHandler.config.getCategory("general").get("Show Power Chart").set(PowerGogglesConfigHandler.showPowerChart);
            PowerGogglesConfigHandler.config.save();
        }
    }

    private void setLink(ItemStack item) {
        if (!item.func_77942_o() || item.func_77978_p().func_82582_d()) {
            GTValues.NW.sendToServer(new GTPacketLinkPowerGoggles());
        } else {
            NBTTagCompound tag = item.func_77978_p();
            DimensionalCoord coords = new DimensionalCoord(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"), tag.func_74762_e("dim"));
            GTValues.NW.sendToServer(new GTPacketLinkPowerGoggles(coords));
        }
    }

    public static boolean isValidLink(EntityPlayerMP player, DimensionalCoord coords) {
        if (coords == null) {
            return false;
        }
        WorldServer lscDim = player.field_71133_b.func_71218_a(coords.getDimension());
        TileEntity tileEntity = lscDim.func_147438_o(coords.x, coords.y, coords.z);
        if (!(tileEntity instanceof IGregTechTileEntity)) {
            return false;
        }
        IGregTechTileEntity gte = (IGregTechTileEntity)tileEntity;
        return gte.getMetaTileEntity() instanceof MTELapotronicSuperCapacitor;
    }

    public static void setLscLink(EntityPlayerMP player, DimensionalCoord coords) {
        lscLinkMap.put(player.func_110124_au(), coords);
    }

    public static DimensionalCoord getLscLink(UUID uuid) {
        return lscLinkMap.get(uuid);
    }

    @SubscribeEvent
    public void serverOnPlayerDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        EntityPlayerMP player = ((NetHandlerPlayServer)event.handler).field_147369_b;
        PowerGogglesEventHandler.setLscLink(player, null);
    }

    static {
        lscLinkMap = new HashMap<UUID, DimensionalCoord>();
        forceUpdate = false;
        forceRefresh = false;
        firstClientTick = true;
    }
}

