/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.fluid;

import gregtech.api.enums.Dyes;
import gregtech.api.enums.FluidState;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.fluid.IGTFluid;
import gregtech.api.interfaces.fluid.IGTFluidBuilder;
import gregtech.api.interfaces.fluid.IGTRegisteredFluid;
import gregtech.common.fluid.GTFluid;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;

public class GTFluidBuilder
implements IGTFluidBuilder {
    final String fluidName;
    String localizedName;
    ResourceLocation stillIconResourceLocation = null;
    ResourceLocation flowingIconResourceLocation = null;
    short[] colorRGBA = Dyes._NULL.getRGBA();
    Block fluidBlock = null;
    FluidState fluidState;
    int temperature;
    IIcon stillIcon;
    IIcon flowingIcon;
    Fluid iconsFrom;

    public GTFluidBuilder(String fluidName) {
        this.fluidName = fluidName.toLowerCase(Locale.ENGLISH);
    }

    @Override
    public IGTFluidBuilder withColorRGBA(short[] colorRGBA) {
        this.colorRGBA = colorRGBA;
        return this;
    }

    @Override
    public IGTFluidBuilder withLocalizedName(String localizedName) {
        this.localizedName = localizedName;
        return this;
    }

    @Override
    public IGTFluidBuilder withStateAndTemperature(FluidState fluidState, int temperature) {
        this.fluidState = fluidState;
        this.temperature = temperature;
        return this;
    }

    @Override
    public IGTFluidBuilder withStillIconResourceLocation(ResourceLocation stillIconResourceLocation) {
        this.stillIconResourceLocation = stillIconResourceLocation;
        return this;
    }

    @Override
    public IGTFluidBuilder withFlowingIconResourceLocation(ResourceLocation flowingIconResourceLocation) {
        this.flowingIconResourceLocation = flowingIconResourceLocation;
        return this;
    }

    @Override
    public IGTFluidBuilder withTextureName(String textureName) {
        this.stillIconResourceLocation = new ResourceLocation(Mods.GregTech.ID, "fluids/fluid." + textureName);
        this.flowingIconResourceLocation = null;
        return this;
    }

    @Override
    public IGTFluidBuilder withIconsFrom(@Nonnull Fluid fromFluid) {
        this.iconsFrom = fromFluid;
        return this;
    }

    @Override
    public IGTFluidBuilder withFluidBlock(Block fluidBlock) {
        this.fluidBlock = fluidBlock;
        return this;
    }

    @Override
    public IGTFluidBuilder withTextures(ResourceLocation stillIconResourceLocation, ResourceLocation flowingIconResourceLocation) {
        this.stillIconResourceLocation = stillIconResourceLocation;
        this.flowingIconResourceLocation = flowingIconResourceLocation;
        return this;
    }

    @Override
    public IGTFluid build() {
        if (this.colorRGBA == null) {
            this.colorRGBA = Dyes._NULL.getRGBA();
        }
        if (this.stillIconResourceLocation == null) {
            this.withTextureName(this.fluidName.toLowerCase(Locale.ENGLISH));
        }
        if (this.localizedName == null) {
            this.localizedName = this.fluidName;
        }
        return new GTFluid(this);
    }

    @Override
    public IGTRegisteredFluid buildAndRegister() {
        return this.build().addFluid();
    }
}

