/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.covers.CoverRegistry;
import gregtech.api.enums.Dyes;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.ICoverable;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseMetaPipeEntity;
import gregtech.api.metatileentity.BaseMetaTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.CoverableTileEntity;
import gregtech.api.metatileentity.implementations.MTEFrame;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLanguageManager;
import gregtech.common.blocks.ItemFrames;
import gregtech.common.blocks.MaterialMachines;
import gregtech.common.render.GTRendererBlock;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockFrameBox
extends BlockContainer {
    protected final String mUnlocalizedName;
    private static final String DOT_NAME = ".name";
    private static final String DOT_TOOLTIP = ".tooltip";
    private static final ThreadLocal<IGregTechTileEntity> mTemporaryTileEntity = new ThreadLocal();

    public BlockFrameBox() {
        super((Material)new MaterialMachines());
        this.mUnlocalizedName = "gt.blockframes";
        this.func_149663_c(this.mUnlocalizedName);
        GTLanguageManager.addStringLocalization(this.func_149739_a() + "." + Short.MAX_VALUE + DOT_NAME, "Any Sub Block of this one");
        GameRegistry.registerBlock((Block)this, ItemFrames.class, (String)this.func_149739_a());
        for (int meta = 1; meta < GregTechAPI.sGeneratedMaterials.length; ++meta) {
            Materials material = GregTechAPI.sGeneratedMaterials[meta];
            if (material == null || (material.mTypes & 2) == 0) continue;
            GTLanguageManager.addStringLocalization(this.func_149739_a() + "." + meta + DOT_NAME, GTLanguageManager.i18nPlaceholder ? this.getLocalizedNameFormat(material) : this.getLocalizedName(material));
            GTLanguageManager.addStringLocalization(this.func_149739_a() + "." + meta + DOT_TOOLTIP, material.getToolTip());
        }
        GregTechAPI.registerMachineBlock((Block)this, -1);
    }

    public ItemStack getStackForm(int amount, int meta) {
        return new ItemStack((Block)this, amount, meta);
    }

    public String getLocalizedNameFormat(Materials aMaterial) {
        String string;
        switch (aMaterial.mName) {
            case "InfusedAir": 
            case "InfusedDull": 
            case "InfusedEarth": 
            case "InfusedEntropy": 
            case "InfusedFire": 
            case "InfusedOrder": 
            case "InfusedVis": 
            case "InfusedWater": {
                string = "%material Infused Stone";
                break;
            }
            case "Vermiculite": 
            case "Bentonite": 
            case "Kaolinite": 
            case "Talc": 
            case "BasalticMineralSand": 
            case "GraniticMineralSand": 
            case "GlauconiteSand": 
            case "CassiteriteSand": 
            case "GarnetSand": 
            case "QuartzSand": 
            case "Pitchblende": 
            case "FullersEarth": {
                string = "%material";
                break;
            }
            default: {
                string = "%material Frame Box";
            }
        }
        return string;
    }

    public String func_149739_a() {
        return this.mUnlocalizedName;
    }

    public String getLocalizedName(Materials aMaterial) {
        return aMaterial.getDefaultLocalizedNameForItem(this.getLocalizedNameFormat(aMaterial));
    }

    private void createFrame(World worldIn, int x, int y, int z, BaseMetaPipeEntity baseMte) {
        int meta = worldIn.func_72805_g(x, y, z);
        Materials material = BlockFrameBox.getMaterial(meta);
        MTEFrame frame = new MTEFrame("GT_Frame_" + material, material);
        baseMte.setMetaTileEntity(frame);
        baseMte.setInitialValuesAsNBT(null, (short)(4096 + meta));
        frame.setBaseMetaTileEntity(baseMte);
    }

    private BaseMetaPipeEntity spawnFrameEntity(World worldIn, int x, int y, int z) {
        BaseMetaPipeEntity newTileEntity = new BaseMetaPipeEntity();
        this.createFrame(worldIn, x, y, z, newTileEntity);
        worldIn.func_147455_a(x, y, z, (TileEntity)newTileEntity);
        return newTileEntity;
    }

    public static Materials getMaterial(int meta) {
        return GregTechAPI.sGeneratedMaterials[meta];
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        TileEntity te = worldIn.func_147438_o(x, y, z);
        if (te instanceof BaseMetaPipeEntity) {
            BaseMetaPipeEntity baseTileEntity = (BaseMetaPipeEntity)te;
            if (baseTileEntity.getMetaTileEntity() == null) {
                this.createFrame(worldIn, x, y, z, baseTileEntity);
            }
            return baseTileEntity.onRightclick(player, direction, subX, subY, subZ);
        }
        ItemStack item = player.func_70694_bm();
        if (CoverRegistry.isCover(item)) {
            BaseMetaPipeEntity newTileEntity = this.spawnFrameEntity(worldIn, x, y, z);
            return newTileEntity.onRightclick(player, direction, subX, subY, subZ);
        }
        return false;
    }

    public int func_149645_b() {
        if (GTRendererBlock.INSTANCE == null) {
            return super.func_149645_b();
        }
        return GTRendererBlock.mRenderID;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item aItem, CreativeTabs aTab, List<ItemStack> aList) {
        for (int i = 0; i < GregTechAPI.sGeneratedMaterials.length; ++i) {
            Materials tMaterial = GregTechAPI.sGeneratedMaterials[i];
            if (tMaterial == null || (tMaterial.mTypes & 2) == 0) continue;
            aList.add(new ItemStack(aItem, 1, i));
        }
    }

    public String getHarvestTool(int aMeta) {
        return "wrench";
    }

    public int getHarvestLevel(int aMeta) {
        return 3;
    }

    public boolean canConnectRedstone(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        CoverableTileEntity cte;
        ForgeDirection forgeDirection;
        switch (ordinalSide) {
            case -2: {
                forgeDirection = ForgeDirection.DOWN;
                break;
            }
            case -1: {
                forgeDirection = ForgeDirection.UP;
                break;
            }
            case 0: {
                forgeDirection = ForgeDirection.NORTH;
                break;
            }
            case 2: {
                forgeDirection = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                forgeDirection = ForgeDirection.WEST;
                break;
            }
            case 1: {
                forgeDirection = ForgeDirection.EAST;
                break;
            }
            default: {
                forgeDirection = ForgeDirection.UNKNOWN;
            }
        }
        ForgeDirection forgeSide = forgeDirection;
        TileEntity frameEntity = aWorld.func_147438_o(aX, aY, aZ);
        return frameEntity instanceof CoverableTileEntity && (cte = (CoverableTileEntity)frameEntity).hasCoverAtSide(forgeSide);
    }

    public int func_149643_k(World aWorld, int aX, int aY, int aZ) {
        return aWorld.func_72805_g(aX, aY, aZ);
    }

    public void func_149749_a(World aWorld, int aX, int aY, int aZ, Block aBlock, int aMetadata) {
        IGregTechTileEntity gtTE;
        if (aWorld.field_72995_K) {
            return;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            IMetaTileEntity mte = gtTE.getMetaTileEntity();
            mte.onBlockDestroyed();
            mTemporaryTileEntity.set(gtTE);
        }
        GregTechAPI.causeMachineUpdate(aWorld, aX, aY, aZ);
        super.func_149749_a(aWorld, aX, aY, aZ, aBlock, aMetadata);
    }

    public void func_149726_b(World worldIn, int x, int y, int z) {
        GregTechAPI.causeMachineUpdate(worldIn, x, y, z);
        super.func_149726_b(worldIn, x, y, z);
    }

    public void func_149670_a(World aWorld, int aX, int aY, int aZ, Entity collider) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            gtTE.getMetaTileEntity().onEntityCollidedWithBlock(aWorld, aX, aY, aZ, collider);
            return;
        }
        super.func_149670_a(aWorld, aX, aY, aZ, collider);
    }

    public float func_149712_f(World aWorld, int aX, int aY, int aZ) {
        return Blocks.field_150339_S.func_149712_f(aWorld, aX, aY, aZ);
    }

    public float func_149737_a(EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        BaseMetaTileEntity baseMTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity instanceof BaseMetaTileEntity && (baseMTE = (BaseMetaTileEntity)tTileEntity).privateAccess() && !baseMTE.playerOwnsThis(aPlayer, true) ? -1.0f : super.func_149737_a(aPlayer, aWorld, aX, aY, aZ);
    }

    public void onNeighborChange(IBlockAccess aWorld, int aX, int aY, int aZ, int aTileX, int aTileY, int aTileZ) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseTileEntity) {
            BaseTileEntity baseTE = (BaseTileEntity)tTileEntity;
            baseTE.onAdjacentBlockChange(aTileX, aTileY, aTileZ);
        }
    }

    public void func_149695_a(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaPipeEntity) {
            BaseMetaPipeEntity baseMetaPipe = (BaseMetaPipeEntity)tTileEntity;
            baseMetaPipe.onNeighborBlockChange(aX, aY, aZ);
        }
    }

    public void func_149743_a(World aWorld, int aX, int aY, int aZ, AxisAlignedBB inputAABB, List<AxisAlignedBB> outputAABB, Entity collider) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            gtTE.getMetaTileEntity().addCollisionBoxesToList(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
            return;
        }
        super.func_149743_a(aWorld, aX, aY, aZ, inputAABB, outputAABB, collider);
    }

    public AxisAlignedBB func_149668_a(World aWorld, int aX, int aY, int aZ) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            return gtTE.getMetaTileEntity().getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return super.func_149668_a(aWorld, aX, aY, aZ);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World aWorld, int aX, int aY, int aZ) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            return gtTE.getMetaTileEntity().getCollisionBoundingBoxFromPool(aWorld, aX, aY, aZ);
        }
        return super.func_149633_g(aWorld, aX, aY, aZ);
    }

    public boolean isSideSolid(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        ICoverable coverable;
        if (aWorld.func_72805_g(aX, aY, aZ) == 0) {
            return true;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof BaseMetaTileEntity) {
            return true;
        }
        if (tTileEntity instanceof BaseMetaPipeEntity) {
            BaseMetaPipeEntity baseMetaPipe = (BaseMetaPipeEntity)tTileEntity;
            if ((baseMetaPipe.mConnections & 0xFFFFFFC0) != 0) {
                return true;
            }
        }
        return tTileEntity instanceof ICoverable && (coverable = (ICoverable)tTileEntity).hasCoverAtSide(side);
    }

    public void func_149719_a(IBlockAccess blockAccess, int aX, int aY, int aZ) {
        IGregTechTileEntity gtTE;
        TileEntity tTileEntity = blockAccess.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity && (gtTE = (IGregTechTileEntity)tTileEntity).canAccessData()) {
            AxisAlignedBB bbb = gtTE.getMetaTileEntity().getCollisionBoundingBoxFromPool(gtTE.getWorld(), 0, 0, 0);
            this.field_149759_B = bbb.field_72340_a;
            this.field_149760_C = bbb.field_72338_b;
            this.field_149754_D = bbb.field_72339_c;
            this.field_149755_E = bbb.field_72336_d;
            this.field_149756_F = bbb.field_72337_e;
            this.field_149757_G = bbb.field_72334_f;
            return;
        }
        super.func_149719_a(blockAccess, aX, aY, aZ);
    }

    public void func_149683_g() {
        super.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    public int getFlammability(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return 0;
    }

    public boolean isFireSource(World aWorld, int aX, int aY, int aZ, ForgeDirection side) {
        return false;
    }

    public boolean isFlammable(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection face) {
        return false;
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean isNormalCube(IBlockAccess aWorld, int aX, int aY, int aZ) {
        return false;
    }

    public boolean hasTileEntity(int aMeta) {
        return true;
    }

    public boolean func_149696_a(World aWorld, int aX, int aY, int aZ, int aData1, int aData2) {
        super.func_149696_a(aWorld, aX, aY, aZ, aData1, aData2);
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        return tTileEntity != null && tTileEntity.func_145842_c(aData1, aData2);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        IGregTechTileEntity tempTe = mTemporaryTileEntity.get();
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(this.getStackForm(1, metadata));
        if (tempTe != null) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                ItemStack cover = tempTe.getCoverItemAtSide(direction);
                if (cover == null) continue;
                drops.add(cover);
            }
        }
        mTemporaryTileEntity.remove();
        return drops;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        if (ordinalSide < 0 || ordinalSide > 5) {
            return 0;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            return gtTE.getOutputRedstoneSignal(ForgeDirection.getOrientation((int)ordinalSide).getOpposite());
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess aWorld, int aX, int aY, int aZ, int ordinalSide) {
        if (ordinalSide < 0 || ordinalSide > 5) {
            return 0;
        }
        TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
        if (tTileEntity instanceof IGregTechTileEntity) {
            IGregTechTileEntity gtTE = (IGregTechTileEntity)tTileEntity;
            return gtTE.getStrongOutputRedstoneSignal(ForgeDirection.getOrientation((int)ordinalSide).getOpposite());
        }
        return 0;
    }

    public IIcon func_149691_a(int side, int meta) {
        Materials material = GregTechAPI.sGeneratedMaterials[meta];
        if (material == null) {
            return null;
        }
        return material.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex].getIcon();
    }

    public ITexture[] getTexture(int meta) {
        Materials material = BlockFrameBox.getMaterial(meta);
        if (material == null) {
            return null;
        }
        return new ITexture[]{TextureFactory.of(material.mIconSet.mTextures[OrePrefixes.frameGt.mTextureIndex], Dyes.getModulation(-1, material.mRGBa))};
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return null;
    }
}

