/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.enums.GTValues;
import java.util.Arrays;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import org.jetbrains.annotations.NotNull;

public class StringUtils {
    private static final String[] rainbow = new String[]{EnumChatFormatting.DARK_RED.toString(), EnumChatFormatting.RED.toString(), EnumChatFormatting.GOLD.toString(), EnumChatFormatting.YELLOW.toString(), EnumChatFormatting.DARK_GREEN.toString(), EnumChatFormatting.GREEN.toString(), EnumChatFormatting.AQUA.toString(), EnumChatFormatting.DARK_AQUA.toString(), EnumChatFormatting.DARK_BLUE.toString(), EnumChatFormatting.BLUE.toString(), EnumChatFormatting.LIGHT_PURPLE.toString(), EnumChatFormatting.DARK_PURPLE.toString(), EnumChatFormatting.WHITE.toString(), EnumChatFormatting.GRAY.toString(), EnumChatFormatting.DARK_GRAY.toString(), EnumChatFormatting.BLACK.toString()};
    private static final char[] SUPER_SCRIPTS = new char[]{"\ue010".charAt(0), "\ue011".charAt(0), "\ue012".charAt(0), "\ue013".charAt(0), "\ue014".charAt(0), "\ue015".charAt(0), "\ue016".charAt(0), "\ue017".charAt(0), "\ue018".charAt(0), "\ue019".charAt(0)};
    private static final char[] SUB_SCRIPTS = new char[]{"\ue01a".charAt(0), '\u2081', '\u2082', '\u2083', '\u2084', '\u2085', '\u2086', '\u2087', '\u2088', '\u2089'};

    @NotNull
    public static String applyRainbow(@NotNull String str, int offset, String additional) {
        StringBuilder final_string = new StringBuilder();
        int i = offset;
        for (char c : str.toCharArray()) {
            final_string.append(rainbow[i++ % rainbow.length]).append(additional).append(c);
        }
        return final_string.toString();
    }

    @NotNull
    public static String applyRainbow(@NotNull String str, int offset) {
        return StringUtils.applyRainbow(str, offset, "");
    }

    @NotNull
    public static String applyRainbow(@NotNull String str) {
        return StringUtils.applyRainbow(str, 0, "");
    }

    @NotNull
    public static String voltageTooltipFormatted(int tier) {
        return GTValues.TIER_COLORS[tier] + GTValues.VN[tier] + EnumChatFormatting.GRAY;
    }

    public static String getRepetitionOf(char c, int length) {
        char[] chars = new char[length];
        Arrays.fill(chars, c);
        return new String(chars);
    }

    public static String getLocalizedString(String key) {
        if (StatCollector.func_94522_b((String)key)) {
            return StatCollector.func_74838_a((String)key);
        }
        return StatCollector.func_150826_b((String)key);
    }

    public static String superscript(String input) {
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c < '0' || c > '9') continue;
            chars[i] = SUPER_SCRIPTS[c - 48];
        }
        return new String(chars);
    }

    public static String subscript(String input) {
        char[] chars = input.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c >= '0' && c <= '9') {
                chars[i] = SUB_SCRIPTS[c - 48];
                continue;
            }
            if (c != '?') continue;
            chars[i] = "\ue020".charAt(0);
        }
        return new String(chars);
    }

    public static String capitalize(String string) {
        return org.apache.commons.lang3.StringUtils.capitalize((String)string);
    }

    public static String splitAndUppercase(String aInput) {
        String[] split = aInput.split("\\.");
        if (split.length == 0) {
            return aInput;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : split) {
            s = StringUtils.sanitizeString(s);
            s = StringUtils.capitalize(s);
            sb.append(s);
        }
        return sb.toString();
    }

    public static long uppercaseCount(String input) {
        char[] chars = input.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (!Character.isUpperCase(c)) continue;
            ++count;
        }
        return count;
    }

    public static String sanitizeStringKeepDashes(String input) {
        char[] chars = input.toCharArray();
        int i = 0;
        block3: for (char c : chars) {
            switch (c) {
                case ' ': 
                case '!': 
                case '#': 
                case '$': 
                case '%': 
                case '&': 
                case '(': 
                case ')': 
                case '*': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '^': 
                case '{': 
                case '}': 
                case '~': {
                    continue block3;
                }
                default: {
                    chars[i++] = c;
                }
            }
        }
        return new String(chars, 0, i);
    }

    public static String sanitizeString(String input) {
        char[] chars = input.toCharArray();
        int i = 0;
        block3: for (char c : chars) {
            switch (c) {
                case ' ': 
                case '!': 
                case '#': 
                case '(': 
                case ')': 
                case '-': 
                case '?': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '{': 
                case '}': {
                    continue block3;
                }
                default: {
                    chars[i++] = c;
                }
            }
        }
        return new String(chars, 0, i);
    }

    public static String sanitizeStringKeepBrackets(String input) {
        char[] chars = input.toCharArray();
        int i = 0;
        block3: for (char c : chars) {
            switch (c) {
                case ' ': 
                case '!': 
                case '#': 
                case '-': 
                case '?': 
                case '@': 
                case '_': {
                    continue block3;
                }
                default: {
                    chars[i++] = c;
                }
            }
        }
        return new String(chars, 0, i);
    }

    public static String sanitizeStringKeepBracketsQuestion(String input) {
        char[] chars = input.toCharArray();
        int i = 0;
        block3: for (char c : chars) {
            switch (c) {
                case ' ': 
                case '!': 
                case '#': 
                case '-': 
                case '@': 
                case '_': {
                    continue block3;
                }
                default: {
                    chars[i++] = c;
                }
            }
        }
        return new String(chars, 0, i);
    }
}

