/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import appeng.api.implementations.tiles.IColorableTile;
import appeng.api.util.AEColor;
import appeng.block.networking.BlockCableBus;
import appeng.integration.IntegrationRegistry;
import appeng.integration.IntegrationType;
import appeng.integration.abstraction.IFMP;
import appeng.tile.networking.TileCableBus;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import gregtech.api.enums.Dyes;
import gregtech.api.interfaces.tileentity.IColoredTileEntity;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ColoredBlockContainer {
    private static final ColoredBlockContainer NULL_INSTANCE = new NullContainer();

    public abstract boolean setColor(int var1);

    public abstract boolean removeColor();

    public boolean isValid() {
        return true;
    }

    public abstract Optional<Integer> getColor();

    private ColoredBlockContainer() {
    }

    public static ColoredBlockContainer getInstance(EntityPlayer player, MovingObjectPosition position) {
        if (position == null || position.field_72313_a != MovingObjectPosition.MovingObjectType.BLOCK) {
            return NULL_INSTANCE;
        }
        return ColoredBlockContainer.getInstance(player.field_70170_p, position.field_72311_b, position.field_72312_c, position.field_72309_d, ForgeDirection.getOrientation((int)position.field_72310_e), player);
    }

    public static ColoredBlockContainer getInstance(EntityPlayer player, TileEntity tileEntity, ForgeDirection side) {
        if (tileEntity == null) {
            return NULL_INSTANCE;
        }
        return ColoredBlockContainer.getInstance(player.field_70170_p, tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e, side, player);
    }

    public static ColoredBlockContainer getInstance(World world, int x, int y, int z, ForgeDirection side, EntityPlayer player) {
        Block block = world.func_147439_a(x, y, z);
        if (block != Blocks.field_150350_a) {
            if (VanillaBlockContainer.ALLOWED_VANILLA_BLOCKS.contains(block) || block instanceof BlockColored) {
                return new VanillaBlockContainer(block, world, x, y, z, side);
            }
            if (block instanceof BlockCableBus) {
                BlockCableBus bus = (BlockCableBus)block;
                return new AE2BlockCableBusContainer(bus, world, x, y, z, side, player);
            }
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IColorableTile) {
                IColorableTile colorableTile = (IColorableTile)tileEntity;
                return new AE2ColorableTileContainer(colorableTile, side, player);
            }
            if (tileEntity instanceof IColoredTileEntity) {
                IColoredTileEntity coloredTileEntity = (IColoredTileEntity)tileEntity;
                return new GTColoredBlockContainer(coloredTileEntity);
            }
        }
        return NULL_INSTANCE;
    }

    private static class VanillaBlockContainer
    extends ColoredBlockContainer {
        private static final Set<Block> ALLOWED_VANILLA_BLOCKS = ImmutableSet.of((Object)Blocks.field_150359_w, (Object)Blocks.field_150410_aZ, (Object)Blocks.field_150399_cn, (Object)Blocks.field_150397_co, (Object)Blocks.field_150404_cg, (Object)Blocks.field_150405_ch, (Object[])new Block[]{Blocks.field_150406_ce});
        private static final BiMap<Block, Block> TRANSFORMATIONS = ImmutableBiMap.of((Object)Blocks.field_150359_w, (Object)Blocks.field_150399_cn, (Object)Blocks.field_150410_aZ, (Object)Blocks.field_150397_co, (Object)Blocks.field_150405_ch, (Object)Blocks.field_150406_ce);
        private final int originalColor;
        private final World world;
        private final int x;
        private final int y;
        private final int z;
        private final Block block;
        private final ForgeDirection side;

        public VanillaBlockContainer(Block block, World world, int x, int y, int z, ForgeDirection side) {
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.block = block;
            this.side = side;
            this.originalColor = world.func_72805_g(x, y, z);
        }

        @Override
        public Optional<Integer> getColor() {
            return Optional.of(Dyes.transformDyeIndex(this.originalColor));
        }

        @Override
        public boolean setColor(int newColor) {
            int transformedColor = Dyes.transformDyeIndex(newColor);
            if (TRANSFORMATIONS.containsKey((Object)this.block)) {
                this.world.func_147465_d(this.x, this.y, this.z, (Block)TRANSFORMATIONS.get((Object)this.block), transformedColor, 3);
                return true;
            }
            if (this.originalColor != transformedColor) {
                if (this.block instanceof BlockColored) {
                    return this.block.recolourBlock(this.world, this.x, this.y, this.z, this.side, transformedColor);
                }
                return this.world.func_72921_c(this.x, this.y, this.z, transformedColor, 3);
            }
            return this.block.recolourBlock(this.world, this.x, this.y, this.z, this.side, transformedColor);
        }

        @Override
        public boolean removeColor() {
            if (TRANSFORMATIONS.containsValue((Object)this.block)) {
                this.world.func_147465_d(this.x, this.y, this.z, (Block)TRANSFORMATIONS.inverse().get((Object)this.block), 0, 3);
                return true;
            }
            return false;
        }
    }

    private static class AE2BlockCableBusContainer
    extends ColoredBlockContainer {
        private final BlockCableBus bus;
        private final World world;
        private final int x;
        private final int y;
        private final int z;
        private final ForgeDirection side;
        private final EntityPlayer player;

        public AE2BlockCableBusContainer(BlockCableBus bus, World world, int x, int y, int z, ForgeDirection side, EntityPlayer player) {
            this.bus = bus;
            this.world = world;
            this.x = x;
            this.y = y;
            this.z = z;
            this.side = side;
            this.player = player;
        }

        @Override
        public boolean setColor(int newColor) {
            return this.bus.recolourBlock(this.world, this.x, this.y, this.z, this.side, Dyes.transformDyeIndex(newColor), this.player);
        }

        @Override
        public boolean removeColor() {
            return this.bus.recolourBlock(this.world, this.x, this.y, this.z, this.side, AEColor.Transparent.ordinal(), this.player);
        }

        @Override
        public Optional<Integer> getColor() {
            TileEntity te = this.world.func_147438_o(this.x, this.y, this.z);
            AEColor aeColor = null;
            if (te instanceof TileCableBus) {
                TileCableBus cableBus = (TileCableBus)te;
                aeColor = cableBus.getCableBus().getColor();
            } else if (IntegrationRegistry.INSTANCE.isEnabled(IntegrationType.FMP)) {
                aeColor = ((IFMP)IntegrationRegistry.INSTANCE.getInstance(IntegrationType.FMP)).getCableContainer(te).getColor();
            }
            return aeColor == null ? Optional.empty() : Optional.of(Dyes.transformDyeIndex(aeColor.ordinal()));
        }
    }

    private static class AE2ColorableTileContainer
    extends ColoredBlockContainer {
        private final IColorableTile colorableTile;
        private final ForgeDirection side;
        private final EntityPlayer player;

        public AE2ColorableTileContainer(IColorableTile colorableTile, ForgeDirection side, EntityPlayer player) {
            this.colorableTile = colorableTile;
            this.side = side;
            this.player = player;
        }

        @Override
        public Optional<Integer> getColor() {
            return Optional.of(Dyes.transformDyeIndex(this.colorableTile.getColor().ordinal()));
        }

        @Override
        public boolean setColor(int newColor) {
            return this.colorableTile.recolourBlock(this.side, AEColor.values()[Dyes.transformDyeIndex(newColor)], this.player);
        }

        @Override
        public boolean removeColor() {
            return this.colorableTile.recolourBlock(this.side, AEColor.Transparent, this.player);
        }
    }

    private static class GTColoredBlockContainer
    extends ColoredBlockContainer {
        private final IColoredTileEntity coloredTileEntity;

        public GTColoredBlockContainer(IColoredTileEntity coloredTileEntity) {
            this.coloredTileEntity = coloredTileEntity;
        }

        @Override
        public boolean setColor(int newColor) {
            this.coloredTileEntity.setColorization((byte)newColor);
            return true;
        }

        @Override
        public boolean removeColor() {
            if (this.coloredTileEntity.getColorization() > -1) {
                this.coloredTileEntity.setColorization((byte)-1);
                return true;
            }
            return false;
        }

        @Override
        public Optional<Integer> getColor() {
            byte colorization = this.coloredTileEntity.getColorization();
            if (colorization == -1) {
                return Optional.empty();
            }
            return Optional.of(Integer.valueOf(colorization));
        }
    }

    private static class NullContainer
    extends ColoredBlockContainer {
        private NullContainer() {
        }

        @Override
        public boolean setColor(int newColor) {
            return false;
        }

        @Override
        public boolean removeColor() {
            return false;
        }

        @Override
        public Optional<Integer> getColor() {
            return Optional.empty();
        }

        @Override
        public boolean isValid() {
            return false;
        }
    }
}

