/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import gregtech.api.enums.Materials;
import gregtech.api.enums.MaterialsUEVplus;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.util.GTUtility;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class AntimatterOutputHatch
extends MTEHatchOutput {
    private static final FluidStack ANTIMATTER = Materials.Antimatter.getFluid(1L);

    public AntimatterOutputHatch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 11);
        this.mDescriptionArray[1] = "Stores Antimatter";
        this.mDescriptionArray[2] = "Antimatter can be inserted from any side";
        this.mDescriptionArray[3] = "Front face input can be toggled with a screwdriver";
        this.mDescriptionArray[4] = "Capacity: 16,384,000L";
    }

    public AntimatterOutputHatch(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
        this.setLockedFluidName(MaterialsUEVplus.Antimatter.getFluid(1L).getFluid().getName());
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new AntimatterOutputHatch(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public int getCapacity() {
        return 0xFA0000;
    }

    @Override
    public boolean isFluidLocked() {
        return true;
    }

    @Override
    protected void onEmptyingContainerWhenEmpty() {
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (!this.getBaseMetaTileEntity().getCoverAtSide(side).isGUIClickable()) {
            return;
        }
        this.mMode = (byte)(this.mMode ^ 1);
        GTUtility.sendChatToPlayer(aPlayer, "Front face input " + (this.mMode == 1 ? "enabled" : "disabled"));
    }

    @Override
    public boolean isLiquidInput(ForgeDirection side) {
        return this.mMode == 1 || side != this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isLiquidOutput(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }
}

