/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.client.render;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import mods.railcraft.client.render.RenderFakeBlock;
import mods.railcraft.client.render.RenderTools;
import mods.railcraft.common.fluids.tanks.StandardTank;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public class FluidRenderer {
    private static final ResourceLocation BLOCK_TEXTURE = TextureMap.field_110575_b;
    private static final Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static final Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();
    public static final int DISPLAY_STAGES = 100;
    private static final RenderFakeBlock.RenderInfo liquidBlock = new RenderFakeBlock.RenderInfo();

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        if (fluid == null) {
            return RenderTools.getMissingIcon();
        }
        IIcon icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        icon = RenderTools.getSafeIcon(icon);
        return icon;
    }

    public static ResourceLocation getFluidSheet(Fluid fluid) {
        return BLOCK_TEXTURE;
    }

    public static ResourceLocation setupFlowingLiquidTexture(Fluid fluid, IIcon[] texArray) {
        IIcon top;
        if (fluid == null) {
            return null;
        }
        IIcon side = RenderTools.getSafeIcon(fluid.getFlowingIcon());
        if (fluid.getStillIcon() != null && fluid.getFlowingIcon() == null) {
            side = RenderTools.getSafeIcon(fluid.getStillIcon());
        }
        texArray[0] = top = RenderTools.getSafeIcon(fluid.getStillIcon());
        texArray[1] = top;
        texArray[2] = side;
        texArray[3] = side;
        texArray[4] = side;
        texArray[5] = side;
        return FluidRenderer.getFluidSheet(fluid);
    }

    public static void setColorForTank(StandardTank tank) {
        if (tank == null) {
            return;
        }
        RenderTools.setColor(tank.renderData.color);
    }

    public static int[] getLiquidDisplayLists(Fluid fluid) {
        return FluidRenderer.getLiquidDisplayLists(fluid, false);
    }

    public static int[] getLiquidDisplayLists(Fluid fluid, boolean flowing) {
        if (fluid == null) {
            return null;
        }
        Map<Fluid, int[]> cache = flowing ? flowingRenderCache : stillRenderCache;
        int[] diplayLists = cache.get(fluid);
        if (diplayLists != null) {
            return diplayLists;
        }
        diplayLists = new int[100];
        FluidRenderer.liquidBlock.texture[0] = null;
        if (fluid.getBlock() != null) {
            FluidRenderer.liquidBlock.template = fluid.getBlock();
            FluidRenderer.liquidBlock.texture[0] = FluidRenderer.getFluidTexture(fluid, flowing);
        } else {
            FluidRenderer.liquidBlock.template = Blocks.field_150355_j;
            FluidRenderer.liquidBlock.texture[0] = FluidRenderer.getFluidTexture(fluid, flowing);
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glDisable((int)2884);
        for (int s = 0; s < 100; ++s) {
            diplayLists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)diplayLists[s], (int)4864);
            FluidRenderer.liquidBlock.minX = 0.01f;
            FluidRenderer.liquidBlock.minY = 0.0f;
            FluidRenderer.liquidBlock.minZ = 0.01f;
            FluidRenderer.liquidBlock.maxX = 0.99f;
            FluidRenderer.liquidBlock.maxY = (float)s / 100.0f;
            FluidRenderer.liquidBlock.maxZ = 0.99f;
            RenderFakeBlock.renderBlockForEntity(liquidBlock, null, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)2896);
        cache.put(fluid, diplayLists);
        return diplayLists;
    }

    static {
        FluidRenderer.liquidBlock.texture = new IIcon[1];
    }

    public static class TextureHook {
        @SubscribeEvent
        public void clearRenderCaches(TextureStitchEvent.Post event) {
            if (event.map.func_130086_a() == 0) {
                flowingRenderCache.clear();
                stillRenderCache.clear();
            }
        }
    }
}

