/*
 * Decompiled with CFR 0.152.
 */
package net.fuzzycraft.botanichorizons.util.multiblock;

import java.util.Random;
import javax.annotation.Nonnull;
import net.fuzzycraft.botanichorizons.util.Facing2D;
import net.fuzzycraft.botanichorizons.util.multiblock.IMultiblockErrorLocation;
import net.fuzzycraft.botanichorizons.util.multiblock.MultiblockStructure;
import net.fuzzycraft.botanichorizons.util.multiblock.UnloadedBlockException;
import net.fuzzycraft.botanichorizons.util.multiblock.WrongBlockException;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import vazkii.botania.api.lexicon.multiblock.Multiblock;
import vazkii.botania.api.lexicon.multiblock.MultiblockSet;
import vazkii.botania.api.lexicon.multiblock.component.MultiblockComponent;

public class MultiblockHelper {
    public final MultiblockStructure[] blocks;
    private static final Random particleRandomiser = new Random();

    public MultiblockHelper(@Nonnull MultiblockStructure[] blocks) {
        this.blocks = blocks;
    }

    public boolean checkStructurePart(@Nonnull World world, int rootX, int rootY, int rootZ, @Nonnull Facing2D orientation, int index) {
        int checkZ;
        int checkY;
        MultiblockStructure part = this.blocks[index];
        int checkX = this.transformedX(rootX, orientation, part);
        if (world.func_72904_c(checkX, checkY = this.transformedY(rootY, part), checkZ = this.transformedZ(rootZ, orientation, part), checkX, checkY, checkZ)) {
            Block block = world.func_147439_a(checkX, checkY, checkZ);
            return part.check.check(block, world, checkX, checkY, checkZ);
        }
        return true;
    }

    public Exception checkEntireStructure(@Nonnull World world, int rootX, int rootY, int rootZ, @Nonnull Facing2D orientation) {
        for (MultiblockStructure part : this.blocks) {
            int checkZ;
            int checkY;
            int checkX = this.transformedX(rootX, orientation, part);
            if (world.func_72904_c(checkX, checkY = this.transformedY(rootY, part), checkZ = this.transformedZ(rootZ, orientation, part), checkX, checkY, checkZ)) {
                Block block = world.func_147439_a(checkX, checkY, checkZ);
                if (part.check.check(block, world, checkX, checkY, checkZ)) continue;
                String message = String.format("x: (%d + %d * %d~%d), z: (%d + %d * %d~%d), b: %s", rootX, part.dx, orientation.dx, orientation.cw_dx, rootZ, part.dz, orientation.dz, orientation.cw_dz, part.toString());
                return new WrongBlockException(checkX, checkY, checkZ, message);
            }
            return new UnloadedBlockException(checkX, checkY, checkZ);
        }
        return null;
    }

    private int transformedX(int rootX, @Nonnull Facing2D orientation, @Nonnull MultiblockStructure item) {
        return rootX + item.dz * orientation.dx - item.dx * orientation.cw_dx;
    }

    private int transformedY(int rootY, @Nonnull MultiblockStructure item) {
        return rootY - item.dy;
    }

    private int transformedZ(int rootZ, @Nonnull Facing2D orientation, @Nonnull MultiblockStructure item) {
        return rootZ + item.dz * orientation.dz - item.dx * orientation.cw_dz;
    }

    @Nonnull
    public MultiblockSet lexiconMultiblock(int xOffset, int yOffset, int zOffset, Block rootBlock, int rootMeta) {
        Multiblock export = new Multiblock();
        for (MultiblockStructure block : this.blocks) {
            MultiblockComponent component = block.check.getLexiconRenderer(block, xOffset, yOffset, zOffset);
            if (component == null) continue;
            export.addComponent(component);
        }
        export.addComponent(new MultiblockComponent(new ChunkCoordinates(xOffset, yOffset, zOffset), rootBlock, rootMeta, true));
        return export.makeSet();
    }

    public static boolean handleFailedStructure(World world, EntityPlayer player, Exception error) {
        if (error instanceof IMultiblockErrorLocation) {
            ChunkCoordinates errorLocation = ((IMultiblockErrorLocation)((Object)error)).getErrorLocation();
            for (int i = 0; i < 10; ++i) {
                world.func_72869_a("fireworksSpark", (double)errorLocation.field_71574_a + 0.5, (double)errorLocation.field_71572_b + 0.5, (double)errorLocation.field_71573_c + 0.5, (double)MultiblockHelper.genParticleVelocity(), (double)MultiblockHelper.genParticleVelocity(), (double)MultiblockHelper.genParticleVelocity());
            }
            return true;
        }
        if (player != null) {
            player.func_146105_b((IChatComponent)new ChatComponentText(error.getMessage()));
            return true;
        }
        return false;
    }

    private static float genParticleVelocity() {
        return (particleRandomiser.nextFloat() - 0.5f) / 3.0f;
    }
}

