/*
 * Decompiled with CFR 0.152.
 */
package tterrag.wailaplugins.plugins;

import com.enderio.core.common.util.BlockCoord;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import ic2.core.crop.TileEntityCrop;
import java.util.List;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaRegistrar;
import mcp.mobius.waila.api.SpecialChars;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import tterrag.wailaplugins.api.Plugin;
import tterrag.wailaplugins.plugins.PluginBase;

@Plugin(name="IC2Crops", deps={"IC2"})
public class PluginIC2Crops
extends PluginBase {
    @Override
    public void load(IWailaRegistrar registrar) {
        super.load(registrar);
        this.addConfig("cropName");
        this.addConfig("cropStats");
        this.addConfig("plantInfo");
        this.addConfig("envInfo");
        this.registerBody(ICropTile.class);
        this.registerNBT(ICropTile.class);
    }

    @Override
    protected void getBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor) {
        CropCard crop;
        TileEntity tile = accessor.getTileEntity();
        MovingObjectPosition pos = accessor.getPosition();
        NBTTagCompound tag = accessor.getNBTData();
        byte scanLevel = tag.func_74771_c("scanLevel");
        ICropTile tCrop = tile instanceof ICropTile ? (ICropTile)tile : null;
        CropCard cropCard = crop = tCrop != null ? tCrop.getCrop() : null;
        if (tCrop != null && crop != null) {
            int cropTier = crop.tier();
            if (this.getConfig("cropName")) {
                if (scanLevel > 0) {
                    String canGrow;
                    double growth = (double)tag.func_74762_e("growthPoints") / (double)crop.growthDuration(tCrop) * 100.0;
                    byte size = tCrop.getSize();
                    int optimalSize = tag.func_74762_e("optimalHarvest");
                    int maxSize = crop.maxSize();
                    String string = size == maxSize ? SpecialChars.GREEN + "Max Size" + SpecialChars.RESET : (canGrow = "Can grow: " + (tag.func_74767_n("canGrow") ? SpecialChars.GREEN + "Yes" : SpecialChars.RED + "No") + SpecialChars.RESET);
                    String canHarvest = size == optimalSize ? SpecialChars.GREEN + "Optimal Harvest" + SpecialChars.RESET : "Can Harvest: " + (tag.func_74767_n("canHarvest") ? SpecialChars.GREEN + "Yes" : SpecialChars.RED + "No") + SpecialChars.RESET;
                    currenttip.add(String.format("%s (Tier %d)", crop.name(), cropTier) + "  " + canGrow + (cropTier > 0 ? "  " + canHarvest : ""));
                    currenttip.add("Stage -- Size: " + tCrop.getSize() + "/" + maxSize + "" + (size < maxSize ? "  Growth: " + (int)growth + "%" : ""));
                } else if (cropTier == 0) {
                    currenttip.add(SpecialChars.RED + "WEED - [420 blaze it]" + SpecialChars.RESET);
                }
            }
            if (scanLevel >= 4) {
                if (this.getConfig("cropStats")) {
                    if (tag.func_74771_c("growth") >= 24) {
                        currenttip.add("Stats -- Growth: " + SpecialChars.RED + tag.func_74771_c("growth") + SpecialChars.RESET + "  Gain: " + tag.func_74771_c("gain") + "  Resistance: " + tag.func_74771_c("resistance"));
                    } else {
                        currenttip.add("Stats -- Growth: " + tag.func_74771_c("growth") + "  Gain: " + tag.func_74771_c("gain") + "  Resistance: " + tag.func_74771_c("resistance"));
                    }
                }
                if (this.getConfig("plantInfo")) {
                    currenttip.add("Plant -- Fertilizer: " + tag.func_74762_e("fertilizer") + "  Water: " + tag.func_74762_e("water") + "  Weed-Ex: " + tag.func_74762_e("weedex"));
                }
                if (this.getConfig("envInfo")) {
                    currenttip.add("Environ -- Nutrients: " + tag.func_74762_e("nutrients") + "  Humidity: " + tag.func_74762_e("humidity") + "  Air-Quality: " + tag.func_74762_e("airQuality"));
                }
            }
        }
    }

    @Override
    protected void getNBTData(TileEntity tile, NBTTagCompound tag, World world, BlockCoord pos) {
        TileEntityCrop teCrop;
        ICropTile tCrop = tile instanceof ICropTile ? (ICropTile)tile : null;
        TileEntityCrop tileEntityCrop = teCrop = tile instanceof TileEntityCrop ? (TileEntityCrop)tile : null;
        if (tCrop != null) {
            CropCard crop = tCrop.getCrop();
            boolean canGrow = crop != null && crop.canGrow(tCrop);
            boolean canHarvest = crop != null && crop.canBeHarvested(tCrop);
            int optimalHarvest = crop != null ? crop.getOptimalHavestSize(tCrop) : -1;
            tag.func_74757_a("canGrow", canGrow);
            tag.func_74757_a("canHarvest", canHarvest);
            tag.func_74768_a("optimalHarvest", optimalHarvest);
            tag.func_74774_a("scanLevel", tCrop.getScanLevel());
            tag.func_74774_a("growth", tCrop.getGrowth());
            tag.func_74774_a("gain", tCrop.getGain());
            tag.func_74774_a("resistance", tCrop.getResistance());
            tag.func_74768_a("fertilizer", tCrop.getNutrientStorage());
            tag.func_74768_a("water", tCrop.getHydrationStorage());
            tag.func_74768_a("weedex", tCrop.getWeedExStorage());
            tag.func_74768_a("nutrients", (int)tCrop.getNutrients());
            tag.func_74768_a("humidity", (int)tCrop.getHumidity());
            tag.func_74768_a("airQuality", (int)tCrop.getAirQuality());
            tag.func_74768_a("growthPoints", teCrop != null ? teCrop.growthPoints : -1);
        }
        tile.func_145841_b(tag);
    }
}

