/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.layer;

import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import twilightforest.biomes.TFBiomeBase;

public class GenLayerTF7x7Preset
extends GenLayer {
    BiomeGenBase[][] preset = new BiomeGenBase[9][9];

    public GenLayerTF7x7Preset(long par1) {
        super(par1);
        this.initPresets();
    }

    public int[] func_75904_a(int x, int z, int width, int depth) {
        int[] dest = IntCache.func_76445_a((int)(width * depth));
        for (int dz = 0; dz < depth; ++dz) {
            for (int dx = 0; dx < width; ++dx) {
                int sx = x + dx + 4;
                int sz = z + dz + 4;
                dest[dx + dz * width] = sx >= 0 && sx < 8 && sz >= 0 && sz < 8 ? this.preset[sx][sz].field_76756_M : BiomeGenBase.field_76771_b.field_76756_M;
            }
        }
        return dest;
    }

    private void initPresets() {
        char[][] map = new char[][]{{'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P'}, {'P', 'H', 'H', 'H', 'H', 'D', 'D', 'D', 'P'}, {'P', 'H', 'H', 'H', 'H', 'D', 'D', 'D', 'P'}, {'P', 'F', 'f', 'F', 'm', 'M', 'D', 'D', 'P'}, {'P', 'F', 'F', 'F', 'C', 'm', 'D', 'D', 'P'}, {'P', 'F', 'f', 'f', 'F', 'E', 'O', 'O', 'P'}, {'P', 'S', 'S', 'S', 'L', 'L', 'O', 'G', 'P'}, {'P', 'Y', 'S', 'S', 'L', 'L', 'O', 'G', 'P'}, {'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P', 'P'}};
        for (int x = 0; x < map.length; ++x) {
            for (int z = 0; z < map[x].length; ++z) {
                this.preset[x][z] = this.getBiomeFor(map[z][x]);
            }
        }
    }

    protected BiomeGenBase getBiomeFor(char c) {
        BiomeGenBase biomeGenBase;
        switch (c) {
            default: {
                biomeGenBase = BiomeGenBase.field_76771_b;
                break;
            }
            case 'F': {
                biomeGenBase = TFBiomeBase.twilightForest;
                break;
            }
            case 'f': {
                biomeGenBase = TFBiomeBase.twilightForest2;
                break;
            }
            case 'E': {
                biomeGenBase = TFBiomeBase.enchantedForest;
                break;
            }
            case 'm': {
                biomeGenBase = TFBiomeBase.mushrooms;
                break;
            }
            case 'M': {
                biomeGenBase = TFBiomeBase.deepMushrooms;
                break;
            }
            case 'C': {
                biomeGenBase = TFBiomeBase.clearing;
                break;
            }
            case 'S': {
                biomeGenBase = TFBiomeBase.tfSwamp;
                break;
            }
            case 'Y': {
                biomeGenBase = TFBiomeBase.fireSwamp;
                break;
            }
            case 'D': {
                biomeGenBase = TFBiomeBase.darkForest;
                break;
            }
            case 'L': {
                biomeGenBase = TFBiomeBase.tfLake;
                break;
            }
            case 'O': {
                biomeGenBase = TFBiomeBase.tfSnow;
                break;
            }
            case 'G': {
                biomeGenBase = TFBiomeBase.glacier;
                break;
            }
            case 'H': {
                biomeGenBase = TFBiomeBase.highlands;
            }
        }
        return biomeGenBase;
    }
}

