/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.logging;

import chylex.hee.system.commands.HeeDebugCommand;
import chylex.hee.system.logging.Log;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class Stopwatch {
    public static boolean isEnabled = true;
    private static final Map<String, StopwatchHandler> runningStopwatches = new HashMap<String, StopwatchHandler>();
    private static final DecimalFormat numberFormat = new DecimalFormat("#.##", DecimalFormatSymbols.getInstance(Locale.ENGLISH));
    private static final double toMillis = 1.0E-6;
    public static final HeeDebugCommand.HeeTest $debugTest = new HeeDebugCommand.HeeTest(){

        @Override
        public void run(String ... args) {
            for (int a = 1; a <= 10; ++a) {
                try {
                    Stopwatch.timeAverage("Stopwatch - test average", 10);
                    Thread.sleep(10L * (long)a);
                    Stopwatch.finish("Stopwatch - test average");
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    };

    public static void time(String identifier) {
        if (!Log.isDebugEnabled() || !isEnabled) {
            return;
        }
        if (!runningStopwatches.containsKey(identifier)) {
            runningStopwatches.put(identifier, new BasicTimer());
        }
        runningStopwatches.get(identifier).onStart();
    }

    public static void timeThreshold(String identifier, long threshold) {
        if (!Log.isDebugEnabled() || !isEnabled) {
            return;
        }
        StopwatchHandler timer = runningStopwatches.get(identifier);
        if (timer == null || !(timer instanceof ThresholdTimer)) {
            timer = new ThresholdTimer();
            runningStopwatches.put(identifier, timer);
        }
        ((ThresholdTimer)timer).setThreshold(threshold);
        timer.onStart();
    }

    public static void timeAverage(String identifier, int count) {
        if (!Log.isDebugEnabled() || !isEnabled) {
            return;
        }
        StopwatchHandler timer = runningStopwatches.get(identifier);
        if (timer == null || !(timer instanceof AveragingTimer)) {
            timer = new AveragingTimer();
            runningStopwatches.put(identifier, timer);
        }
        ((AveragingTimer)timer).setCount(count);
        timer.onStart();
    }

    public static void finish(String identifier) {
        if (!Log.isDebugEnabled() || !isEnabled) {
            return;
        }
        StopwatchHandler handler = runningStopwatches.get(identifier);
        if (handler != null) {
            handler.onFinish(identifier);
        }
    }

    private static class BasicTimer
    extends StopwatchHandler {
        protected long startTime;

        private BasicTimer() {
        }

        @Override
        public void onStart() {
            this.startTime = System.nanoTime();
        }

        @Override
        public void onFinish(String identifier) {
            double time = (double)(System.nanoTime() - this.startTime) * 1.0E-6;
            Log.debug("Stopwatch $0 finished in $2 ~ $1 ms.", identifier, Math.round(time), numberFormat.format(time));
        }
    }

    private static abstract class StopwatchHandler {
        private StopwatchHandler() {
        }

        public abstract void onStart();

        public abstract void onFinish(String var1);
    }

    private static class ThresholdTimer
    extends BasicTimer {
        private long threshold;

        private ThresholdTimer() {
        }

        public void setThreshold(long threshold) {
            this.threshold = threshold;
        }

        @Override
        public void onFinish(String identifier) {
            double time = (double)(System.nanoTime() - this.startTime) * 1.0E-6;
            if (time >= (double)this.threshold) {
                Log.debug("Stopwatch $0 finished above threshold in $2 ~ $1 ms.", identifier, Math.round(time), numberFormat.format(time));
            }
        }
    }

    private static class AveragingTimer
    extends StopwatchHandler {
        protected int count;
        protected int currentCounter;
        protected long startTime;
        protected long totalTime;

        private AveragingTimer() {
        }

        public void setCount(int count) {
            if (count != this.count) {
                this.count = this.currentCounter = count;
            }
        }

        @Override
        public void onStart() {
            this.startTime = System.nanoTime();
        }

        @Override
        public void onFinish(String identifier) {
            this.totalTime += System.nanoTime() - this.startTime;
            if (--this.currentCounter == 0 && this.count > 0) {
                double time = (double)this.totalTime * 1.0E-6 / (double)this.count;
                Log.debug("Stopwatch $0 finished in averagely $2 ~ $1 ms.", identifier, Math.round(time), numberFormat.format(time));
                this.currentCounter = this.count;
                this.totalTime = 0L;
            }
        }
    }
}

