/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.brewing;

import chylex.hee.mechanics.brewing.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public abstract class AbstractPotionData {
    protected Potion potion;
    protected short damageValue;
    protected short requiredDamageValue;
    private int maxLevel;
    private int maxLevelEnhanced;

    public AbstractPotionData(Potion potion, int requiredDamageValue, int damageValue, int maxLevel, int maxLevelEnhanced) {
        this.potion = potion;
        this.requiredDamageValue = (short)requiredDamageValue;
        this.damageValue = (short)damageValue;
        this.maxLevel = maxLevel;
        this.maxLevelEnhanced = maxLevelEnhanced;
    }

    public Potion getPotionType() {
        return this.potion;
    }

    public int getMaxLevel(boolean enhanced) {
        return enhanced ? this.maxLevelEnhanced : this.maxLevel;
    }

    public void onFirstBrewingFinished(ItemStack is) {
        is.func_77964_b((int)this.damageValue);
    }

    public boolean canIncreaseLevel(ItemStack is, boolean enhanced) {
        PotionEffect effect = PotionTypes.getEffectIfValid(is);
        return effect != null && effect.func_76456_a() == this.potion.field_76415_H && effect.func_76458_c() < this.getMaxLevel(enhanced) - 1;
    }
}

