/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.packet;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import crazypants.enderio.conduit.redstone.IInsulatedRedstoneConduit;
import io.netty.buffer.ByteBuf;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketRedstoneConduitOutputStrength
extends AbstractConduitPacket<IInsulatedRedstoneConduit>
implements IMessageHandler<PacketRedstoneConduitOutputStrength, IMessage> {
    private ForgeDirection dir;
    private boolean isStrong;

    public PacketRedstoneConduitOutputStrength() {
    }

    public PacketRedstoneConduitOutputStrength(IInsulatedRedstoneConduit con, ForgeDirection dir) {
        super(con.getBundle().getEntity(), ConTypeEnum.REDSTONE);
        this.dir = dir;
        this.isStrong = con.isOutputStrong(dir);
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeBoolean(this.isStrong);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.isStrong = buf.readBoolean();
    }

    public IMessage onMessage(PacketRedstoneConduitOutputStrength message, MessageContext ctx) {
        if (PacketRedstoneConduitOutputStrength.isInvalidPacketForGui(message, ctx)) {
            return null;
        }
        IInsulatedRedstoneConduit tile = (IInsulatedRedstoneConduit)message.getTileCasted(ctx);
        if (tile != null) {
            tile.setOutputStrength(message.dir, message.isStrong);
        }
        return null;
    }
}

