/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import com.recursive_pineapple.matter_manipulator.common.utils.ImmutableItemMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemMeta;
import com.recursive_pineapple.matter_manipulator.common.utils.Lazy;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Objects;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class LazyItem
extends Lazy<ImmutableItemMeta> {
    public final Mods mod;
    public final String itemName;

    public LazyItem(Mods mod, String itemName, int meta) {
        super(() -> {
            if (!mod.isModLoaded()) {
                return null;
            }
            Item item = GameRegistry.findItem((String)mod.ID, (String)itemName);
            Objects.requireNonNull(item, "could not find item: " + mod.ID + ":" + itemName);
            return new ItemMeta(item, meta);
        });
        this.mod = mod;
        this.itemName = itemName;
    }

    public LazyItem(Mods mod, String itemName) {
        this(mod, itemName, 0);
    }

    public boolean isLoaded() {
        return this.mod.isModLoaded();
    }

    public boolean matches(Item other, int metaOther) {
        if (!this.isLoaded()) {
            return false;
        }
        ImmutableItemMeta bm = (ImmutableItemMeta)this.get();
        if (bm == null) {
            return false;
        }
        return bm.getItem() == other && (bm.getMeta() == metaOther || bm.getMeta() == Short.MAX_VALUE || metaOther == Short.MAX_VALUE);
    }

    public boolean matches(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return this.matches(stack.func_77973_b(), Items.field_151008_G.getDamage(stack));
    }
}

