/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.networking;

import com.google.common.io.ByteArrayDataInput;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.recursive_pineapple.matter_manipulator.GlobalMMConfig;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMRenderer;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import com.recursive_pineapple.matter_manipulator.common.networking.MMPacket;
import com.recursive_pineapple.matter_manipulator.common.networking.Network;
import com.recursive_pineapple.matter_manipulator.common.networking.SoundResource;
import com.recursive_pineapple.matter_manipulator.common.uplink.IUplinkMulti;
import com.recursive_pineapple.matter_manipulator.common.uplink.MTEMMUplink;
import com.recursive_pineapple.matter_manipulator.common.uplink.UplinkState;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public enum Messages {
    MMBPressed(Messages.server(Messages.simple((player, stack, manipulator, state) -> manipulator.onMMBPressed(player, stack, state)))),
    SetRemoveMode(Messages.server(Messages.enumPacket((Enum[])MMState.BlockRemoveMode.values(), (T state, U value) -> {
        state.config.removeMode = value;
    }))),
    SetPlaceMode(Messages.server(Messages.enumPacket((Enum[])MMState.PlaceMode.values(), (EntityPlayer player, ItemStack stack, ItemMatterManipulator manipulator, MMState state, E value) -> {
        int requiredBit;
        switch (value) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case COPYING: {
                int n = ItemMatterManipulator.ALLOW_COPYING;
                break;
            }
            case EXCHANGING: {
                int n = ItemMatterManipulator.ALLOW_EXCHANGING;
                break;
            }
            case GEOMETRY: {
                int n = 0;
                break;
            }
            case MOVING: {
                int n = ItemMatterManipulator.ALLOW_MOVING;
                break;
            }
            case CABLES: {
                int n = requiredBit = ItemMatterManipulator.ALLOW_CABLES;
            }
        }
        if (state.hasCap(requiredBit)) {
            state.config.placeMode = value;
        }
    }))),
    SetBlockSelectMode(Messages.server(Messages.enumPacket((Enum[])MMState.BlockSelectMode.values(), (T state, U value) -> {
        state.config.blockSelectMode = value;
    }))),
    SetPendingAction(Messages.server(Messages.enumPacket((Enum[])MMState.PendingAction.values(), (T state, U value) -> {
        state.config.action = value;
    }))),
    ClearBlocks(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.corners = null;
        state.config.edges = null;
        state.config.faces = null;
        state.config.volumes = null;
        state.config.action = null;
    }))),
    SetShape(Messages.server(Messages.enumPacket((Enum[])MMState.Shape.values(), (T state, U value) -> {
        state.config.shape = value;
    }))),
    SetA(Messages.server(Messages.locationPacket((player, stack, manipulator, state, location) -> {
        state.config.coordA = new Location(player.field_70170_p, location);
    }))),
    MoveA(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MOVING_COORDS;
        state.config.coordAOffset = new Vector3i();
        state.config.coordBOffset = null;
        state.config.coordCOffset = null;
    }))),
    SetB(Messages.server(Messages.locationPacket((player, stack, manipulator, state, location) -> {
        state.config.coordB = new Location(player.field_70170_p, location);
    }))),
    MoveB(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MOVING_COORDS;
        state.config.coordAOffset = null;
        state.config.coordBOffset = new Vector3i();
        state.config.coordCOffset = null;
    }))),
    SetC(Messages.server(Messages.locationPacket((player, stack, manipulator, state, location) -> {
        state.config.coordC = new Location(player.field_70170_p, location);
    }))),
    MoveC(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MOVING_COORDS;
        state.config.coordAOffset = null;
        state.config.coordBOffset = null;
        state.config.coordCOffset = new Vector3i();
    }))),
    MoveAll(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MOVING_COORDS;
        Vector3i lookingAt = MMUtils.getLookingAtLocation(player);
        state.config.coordAOffset = state.config.coordA == null ? null : state.config.coordA.toVec().sub((Vector3ic)lookingAt);
        state.config.coordBOffset = state.config.coordB == null ? null : state.config.coordB.toVec().sub((Vector3ic)lookingAt);
        state.config.coordCOffset = state.config.coordC == null ? null : state.config.coordC.toVec().sub((Vector3ic)lookingAt);
    }))),
    MoveHere(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        if (state.config.shape.requiresC()) {
            if (Location.areCompatible(state.config.coordA, state.config.coordB, state.config.coordC)) {
                Vector3i offsetB = state.config.coordB.toVec().sub((Vector3ic)state.config.coordA.toVec());
                Vector3i offsetC = state.config.coordC.toVec().sub((Vector3ic)state.config.coordA.toVec());
                Vector3i newA = MMUtils.getLookingAtLocation(player);
                Vector3i newB = new Vector3i((Vector3ic)newA).add((Vector3ic)offsetB);
                Vector3i newC = new Vector3i((Vector3ic)newA).add((Vector3ic)offsetC);
                state.config.coordA = new Location(player.func_130014_f_(), newA);
                state.config.coordB = new Location(player.func_130014_f_(), newB);
                state.config.coordC = new Location(player.func_130014_f_(), newC);
            }
        } else if (Location.areCompatible(state.config.coordA, state.config.coordB)) {
            Vector3i offsetB = state.config.coordB.toVec().sub((Vector3ic)state.config.coordA.toVec());
            Vector3i newA = MMUtils.getLookingAtLocation(player);
            Vector3i newB = new Vector3i((Vector3ic)newA).add((Vector3ic)offsetB);
            state.config.coordA = new Location(player.func_130014_f_(), newA);
            state.config.coordB = new Location(player.func_130014_f_(), newB);
        }
    }))),
    ClearCoords(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = null;
        state.config.coordA = null;
        state.config.coordB = null;
        state.config.coordC = null;
        state.config.coordAOffset = null;
        state.config.coordBOffset = null;
        state.config.coordCOffset = null;
    }))),
    ClearTransform(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.transform = new Transform();
        state.config.arraySpan = null;
    }))),
    MarkCopy(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MARK_COPY_A;
        state.config.coordA = null;
        state.config.coordB = null;
    }))),
    MarkCut(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MARK_CUT_A;
        state.config.coordA = null;
        state.config.coordB = null;
    }))),
    MarkPaste(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.action = MMState.PendingAction.MARK_PASTE;
        state.config.coordC = null;
    }))),
    GetRequiredItems(Messages.server(Messages.intPacket((player, stack, manipulator, state, value) -> {
        if (state.config.placeMode != MMState.PlaceMode.COPYING) {
            return;
        }
        MMUtils.createPlanImpl(player, state, manipulator, value);
    }))),
    ClearManualPlans(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        if (state.connectToUplink()) {
            state.uplink.clearManualPlans(player);
        }
    }))),
    CancelAutoPlans(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        if (state.connectToUplink()) {
            state.uplink.cancelAutoPlans(player);
        }
    }))),
    ClearWhitelist(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.replaceWhitelist = null;
    }))),
    UpdateUplinkState(Messages.client(new ISimplePacketHandler<UplinkPacket>(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handle(EntityPlayer player, UplinkPacket packet) {
            WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
            if (theWorld.field_73011_w.field_76574_g == packet.worldId && Mods.GregTech.isModLoaded() && Mods.AppliedEnergistics2.isModLoaded()) {
                Location l = packet.getLocation();
                this.setState(l.getWorld(), l.x, l.y, l.z, packet.getState());
            }
        }

        @Optional(value={"gregtech", "appliedenergistics2"})
        private void setState(World world, int x, int y, int z, UplinkState state) {
            IGregTechTileEntity igte;
            IMetaTileEntity iMetaTileEntity;
            TileEntity tileEntity = world.func_147438_o(x, y, z);
            if (tileEntity instanceof IGregTechTileEntity && (iMetaTileEntity = (igte = (IGregTechTileEntity)tileEntity).getMetaTileEntity()) instanceof MTEMMUplink) {
                MTEMMUplink uplink = (MTEMMUplink)iMetaTileEntity;
                uplink.setState(state);
            }
        }

        @Override
        public UplinkPacket getNewPacket(Messages message, @Nullable Object value) {
            UplinkPacket packet = new UplinkPacket(message);
            if (value != null) {
                IUplinkMulti uplink = (IUplinkMulti)value;
                packet.setState(uplink.getLocation(), uplink.getState());
            }
            return packet;
        }
    })),
    TooltipResponse(Messages.client(new ISimplePacketHandler<IntPacket>(){

        @Override
        public void handle(EntityPlayer player, IntPacket packet) {
            ItemMatterManipulator.onTooltipResponse(packet.value);
        }

        @Override
        public IntPacket getNewPacket(Messages message, @Nullable Object value) {
            IntPacket packet = new IntPacket(message);
            packet.value = value == null ? 0 : (Integer)value;
            return packet;
        }
    })),
    TooltipQuery(Messages.server(new ISimplePacketHandler<IntPacket>(){

        @Override
        public void handle(EntityPlayer player, IntPacket packet) {
            if (packet.value < 0 || packet.value >= player.field_71070_bA.field_75151_b.size()) {
                return;
            }
            ItemStack stack = player.field_71070_bA.func_75139_a(packet.value).func_75211_c();
            if (stack != null && stack.func_77973_b() instanceof ItemMatterManipulator) {
                MMState state = ItemMatterManipulator.getState(stack);
                int result = 0;
                if (state.hasCap(ItemMatterManipulator.CONNECTS_TO_AE) && Mods.AppliedEnergistics2.isModLoaded() && state.connectToMESystem() && state.canInteractWithAE(player)) {
                    result |= 1;
                }
                if (state.hasCap(ItemMatterManipulator.CONNECTS_TO_UPLINK) && Mods.GregTech.isModLoaded() && state.uplinkAddress != null && state.connectToUplink()) {
                    result |= 2;
                }
                TooltipResponse.sendToPlayer((EntityPlayerMP)player, result);
            }
        }

        @Override
        public IntPacket getNewPacket(Messages message, @Nullable Object value) {
            IntPacket packet = new IntPacket(message);
            packet.value = value == null ? 0 : (Integer)value;
            return packet;
        }
    })),
    SetArray(Messages.server(Messages.locationPacket((player, stack, manipulator, state, span) -> {
        state.config.arraySpan = span;
    }))),
    ResetArray(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.arraySpan = null;
    }))),
    ResetTransform(Messages.server(Messages.simple((player, stack, manipulator, state) -> {
        state.config.transform = new Transform();
    }))),
    ToggleTransformFlip(Messages.server(Messages.intPacket((player, stack, manipulator, state, value) -> {
        Transform transform = state.config.transform;
        if (transform == null) {
            state.config.transform = transform = new Transform();
        }
        if ((value & 1) != 0) {
            transform.flipX ^= true;
        }
        if ((value & 2) != 0) {
            transform.flipY ^= true;
        }
        if ((value & 4) != 0) {
            transform.flipZ ^= true;
        }
    }))),
    RotateTransform(Messages.server(Messages.intPacket((player, stack, manipulator, state, value) -> {
        int dir;
        if (state.config.transform == null) {
            state.config.transform = new Transform();
        }
        if ((dir = value & 0xFF) < 0 || dir >= ForgeDirection.VALID_DIRECTIONS.length) {
            return;
        }
        int amount = (value >> 8 & 0xFF) != 0 ? 1 : -1;
        Transform transform = state.config.transform;
        if (transform == null) {
            state.config.transform = transform = new Transform();
        }
        transform.rotate(ForgeDirection.VALID_DIRECTIONS[dir], amount);
    }))),
    PlaySound(Messages.client(new ISimplePacketHandler<SoundPacket>(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handle(EntityPlayer player, SoundPacket packet) {
            if (packet.worldId == Minecraft.func_71410_x().field_71441_e.field_73011_w.field_76574_g) {
                int x = CoordinatePacker.unpackX((long)packet.location);
                int y = CoordinatePacker.unpackY((long)packet.location);
                int z = CoordinatePacker.unpackZ((long)packet.location);
                SoundResource[] sounds = SoundResource.values();
                if (packet.sound < 0 || packet.sound >= sounds.length) {
                    return;
                }
                Minecraft.func_71410_x().field_71441_e.func_72980_b((double)x, (double)y, (double)z, sounds[packet.sound].toString(), packet.strength, packet.pitch, false);
            }
        }

        @Override
        public SoundPacket getNewPacket(Messages message, @Nullable Object value) {
            SoundPacket packet = new SoundPacket(message);
            Pair sound = (Pair)value;
            if (sound != null) {
                packet.worldId = ((Location)sound.left()).worldId;
                packet.location = CoordinatePacker.pack((int)((Location)sound.left()).x, (int)((Location)sound.left()).y, (int)((Location)sound.left()).z);
                packet.sound = ((SoundResource)((Object)sound.right())).ordinal();
            }
            return packet;
        }
    })),
    BuildStatus(Messages.client(new ISimplePacketHandler<BuildStatusPacket>(){

        @Override
        @SideOnly(value=Side.CLIENT)
        public void handle(EntityPlayer player, BuildStatusPacket packet) {
            MMRenderer.setStatusHints(packet.errors, packet.warnings);
        }

        @Override
        public BuildStatusPacket getNewPacket(Messages message, @Nullable Object value) {
            BuildStatusPacket packet = new BuildStatusPacket(message);
            Pair pair = (Pair)value;
            if (pair != null) {
                packet.errors = (LongList)pair.left();
                packet.warnings = (LongList)pair.right();
            }
            return packet;
        }
    }));

    private ISimplePacketHandler<? extends SimplePacket> handler;
    private static final Network CHANNEL;

    private <T extends SimplePacket> Messages(ISimplePacketHandler<T> handler) {
        this.handler = handler;
    }

    public SimplePacket getNewPacket() {
        return this.handler.getNewPacket(this, null);
    }

    public SimplePacket getNewPacket(Object data) {
        return this.handler.getNewPacket(this, data);
    }

    public void sendToServer() {
        this.sendToServer(null);
    }

    public void sendToServer(Object data) {
        if (GlobalMMConfig.DebugConfig.debug) {
            MMMod.LOG.info("Sending packet to server: " + (Object)((Object)this) + "; " + data);
        }
        CHANNEL.sendToServer(this.getNewPacket(data));
    }

    public void sendToPlayer(EntityPlayerMP player) {
        this.sendToPlayer(player, null);
    }

    public void sendToPlayer(EntityPlayerMP player, Object data) {
        if (GlobalMMConfig.DebugConfig.debug) {
            MMMod.LOG.info("Sending packet to player: " + (Object)((Object)this) + "; " + data + "; " + player);
        }
        CHANNEL.sendToPlayer(this.getNewPacket(data), player);
    }

    public void sendToPlayersAround(Location location) {
        this.sendToPlayersAround(location, null);
    }

    public void sendToPlayersAround(Location location, Object data) {
        if (GlobalMMConfig.DebugConfig.debug) {
            MMMod.LOG.info("Sending packet to players around " + location.toString() + ": " + (Object)((Object)this) + "; " + data);
        }
        CHANNEL.sendToAllAround(this.getNewPacket(data), new NetworkRegistry.TargetPoint(location.worldId, (double)location.x, (double)location.y, (double)location.z, 256.0));
    }

    public void sendToPlayersWithinRange(Location location, Object data) {
        if (GlobalMMConfig.DebugConfig.debug) {
            MMMod.LOG.info("Sending packet to players that are watching " + location.toString() + ": " + (Object)((Object)this) + "; " + data);
        }
        World world = location.getWorld();
        SimplePacket packet = this.getNewPacket(data);
        for (EntityPlayer p : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)p;
            Chunk chunk = world.func_72938_d(location.x, location.z);
            if (!player.func_71121_q().func_73040_p().func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
            CHANNEL.sendToPlayer(packet, player);
        }
    }

    public void handle(EntityPlayer player, SimplePacket packet) {
        if (GlobalMMConfig.DebugConfig.debug) {
            MMMod.LOG.info("Handling packet: " + (Object)((Object)this) + "; " + packet + "; " + player + "; " + NetworkUtils.isClient());
        }
        this.handler.handle(player, packet);
    }

    private static Network createNetwork() {
        ArrayList<SimplePacket> packets = new ArrayList<SimplePacket>();
        for (Messages message : Messages.values()) {
            try {
                packets.add(message.getNewPacket());
            }
            catch (Throwable t) {
                throw new RuntimeException("Could not construct packet in createNetwork", t);
            }
        }
        return new Network("MatterManipulator", packets.toArray(new MMPacket[0]));
    }

    public static void init() {
    }

    private static <T extends SimplePacket> ISimplePacketHandler<T> server(final ISimplePacketHandler<T> next) {
        return new ISimplePacketHandler<T>(){

            @Override
            public void handle(EntityPlayer player, T packet) {
                if (player == null) {
                    MMMod.LOG.error("Client received server packet, it will be ignored: " + ((SimplePacket)packet).message.name());
                    return;
                }
                next.handle(player, packet);
            }

            @Override
            public T getNewPacket(Messages message, @Nullable Object data) {
                return next.getNewPacket(message, data);
            }
        };
    }

    private static <T extends SimplePacket> ISimplePacketHandler<T> client(final ISimplePacketHandler<T> next) {
        return new ISimplePacketHandler<T>(){

            @Override
            public void handle(EntityPlayer player, T packet) {
                if (player != null) {
                    MMMod.LOG.error("Server received client packet, it will be ignored: " + ((SimplePacket)packet).message.name());
                    return;
                }
                this.handleImpl(packet);
            }

            @SideOnly(value=Side.CLIENT)
            private void handleImpl(T packet) {
                next.handle((EntityPlayer)Minecraft.func_71410_x().field_71439_g, packet);
            }

            @Override
            public T getNewPacket(Messages message, @Nullable Object data) {
                return next.getNewPacket(message, data);
            }
        };
    }

    private static ISimplePacketHandler<SimplePacket> simple(final ISimpleHandler handler) {
        return new ISimplePacketHandler<SimplePacket>(){

            @Override
            public void handle(EntityPlayer player, SimplePacket packet) {
                Item item;
                ItemStack held = player.field_71071_by.func_70448_g();
                if (held != null && (item = held.func_77973_b()) instanceof ItemMatterManipulator) {
                    ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
                    MMState state = ItemMatterManipulator.getState(held);
                    handler.handle(player, held, manipulator, state);
                    ItemMatterManipulator.setState(held, state);
                }
            }

            @Override
            public SimplePacket getNewPacket(Messages message, @Nullable Object unused) {
                return new SimplePacket(message);
            }
        };
    }

    private static <E extends Enum<E>> ISimplePacketHandler<IntPacket> enumPacket(final E[] values, final BiConsumer<MMState, E> setter) {
        return new ISimplePacketHandler<IntPacket>(){

            @Override
            public void handle(EntityPlayer player, IntPacket packet) {
                Enum value = packet.value < 0 || packet.value >= values.length ? null : values[packet.value];
                ItemStack held = player.field_71071_by.func_70448_g();
                if (held != null && held.func_77973_b() instanceof ItemMatterManipulator) {
                    MMState state = ItemMatterManipulator.getState(held);
                    setter.accept(state, value);
                    ItemMatterManipulator.setState(held, state);
                }
            }

            @Override
            public IntPacket getNewPacket(Messages message, @Nullable Object value) {
                IntPacket packet = new IntPacket(message);
                packet.value = value == null ? -1 : ((Enum)value).ordinal();
                return packet;
            }
        };
    }

    private static <E extends Enum<E>> ISimplePacketHandler<IntPacket> enumPacket(final E[] values, final IEnumSetter<E> setter) {
        return new ISimplePacketHandler<IntPacket>(){

            @Override
            public void handle(EntityPlayer player, IntPacket packet) {
                Item item;
                Enum value = packet.value < 0 || packet.value >= values.length ? null : values[packet.value];
                ItemStack held = player.field_71071_by.func_70448_g();
                if (held != null && (item = held.func_77973_b()) instanceof ItemMatterManipulator) {
                    ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
                    MMState state = ItemMatterManipulator.getState(held);
                    setter.set(player, held, manipulator, state, value);
                    ItemMatterManipulator.setState(held, state);
                }
            }

            @Override
            public IntPacket getNewPacket(Messages message, @Nullable Object value) {
                IntPacket packet = new IntPacket(message);
                packet.value = value == null ? -1 : ((Enum)value).ordinal();
                return packet;
            }
        };
    }

    private static ISimplePacketHandler<IntPacket> intPacket(final IIntSetter setter) {
        return new ISimplePacketHandler<IntPacket>(){

            @Override
            public void handle(EntityPlayer player, IntPacket packet) {
                Item item;
                ItemStack held = player.field_71071_by.func_70448_g();
                if (held != null && (item = held.func_77973_b()) instanceof ItemMatterManipulator) {
                    ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
                    MMState state = ItemMatterManipulator.getState(held);
                    setter.set(player, held, manipulator, state, packet.value);
                    ItemMatterManipulator.setState(held, state);
                }
            }

            @Override
            public IntPacket getNewPacket(Messages message, @Nullable Object value) {
                IntPacket packet = new IntPacket(message);
                packet.value = value == null ? 0 : (Integer)value;
                return packet;
            }
        };
    }

    public static void sendSoundToPlayer(EntityPlayerMP player, World world, int x, int y, int z, SoundResource sound, float strength, float pitch) {
        SoundPacket packet = new SoundPacket(PlaySound);
        packet.worldId = world.field_73011_w.field_76574_g;
        packet.location = CoordinatePacker.pack((int)x, (int)y, (int)z);
        packet.sound = sound.ordinal();
        packet.strength = strength;
        packet.pitch = pitch;
        CHANNEL.sendToPlayer(packet, player);
    }

    public static void sendSoundToAllWithinRange(World world, int x, int y, int z, SoundResource sound, float strength, float pitch) {
        SoundPacket packet = new SoundPacket(PlaySound);
        packet.worldId = world.field_73011_w.field_76574_g;
        packet.location = CoordinatePacker.pack((int)x, (int)y, (int)z);
        packet.sound = sound.ordinal();
        packet.strength = strength;
        packet.pitch = pitch;
        for (EntityPlayer p : world.field_73010_i) {
            EntityPlayerMP player = (EntityPlayerMP)p;
            Chunk chunk = world.func_72938_d(x, z);
            if (!player.func_71121_q().func_73040_p().func_72694_a(player, chunk.field_76635_g, chunk.field_76647_h)) continue;
            CHANNEL.sendToPlayer(packet, player);
        }
    }

    private static ISimplePacketHandler<LocationPacket> locationPacket(final ILocationSetter setter) {
        return new ISimplePacketHandler<LocationPacket>(){

            @Override
            public void handle(EntityPlayer player, LocationPacket packet) {
                Item item;
                ItemStack held = player.field_71071_by.func_70448_g();
                if (held != null && (item = held.func_77973_b()) instanceof ItemMatterManipulator) {
                    ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
                    MMState state = ItemMatterManipulator.getState(held);
                    Vector3i v = new Vector3i(CoordinatePacker.unpackX((long)packet.location), CoordinatePacker.unpackY((long)packet.location), CoordinatePacker.unpackZ((long)packet.location));
                    setter.set(player, held, manipulator, state, v);
                    ItemMatterManipulator.setState(held, state);
                }
            }

            @Override
            public LocationPacket getNewPacket(Messages message, @Nullable Object value) {
                LocationPacket packet = new LocationPacket(message);
                if (value instanceof Location) {
                    Location l = (Location)value;
                    packet.location = CoordinatePacker.pack((int)l.x, (int)l.y, (int)l.z);
                } else if (value instanceof Vector3i) {
                    Vector3i v = (Vector3i)value;
                    packet.location = CoordinatePacker.pack((int)v.x, (int)v.y, (int)v.z);
                }
                return packet;
            }
        };
    }

    static {
        CHANNEL = Messages.createNetwork();
    }

    private static interface ISimplePacketHandler<T extends SimplePacket> {
        public void handle(EntityPlayer var1, T var2);

        public T getNewPacket(Messages var1, @Nullable Object var2);
    }

    private static class SimplePacket
    extends MMPacket {
        public final Messages message;
        private EntityPlayerMP playerMP;

        public SimplePacket(Messages message) {
            this.message = message;
        }

        @Override
        public byte getPacketID() {
            return (byte)this.message.ordinal();
        }

        @Override
        public MMPacket decode(ByteArrayDataInput buffer) {
            return this.message.getNewPacket();
        }

        @Override
        public void encode(ByteBuf buffer) {
        }

        @Override
        public void setINetHandler(INetHandler handler) {
            EntityPlayerMP entityPlayerMP;
            if (handler instanceof NetHandlerPlayServer) {
                NetHandlerPlayServer server = (NetHandlerPlayServer)handler;
                entityPlayerMP = server.field_147369_b;
            } else {
                entityPlayerMP = null;
            }
            this.playerMP = entityPlayerMP;
        }

        @Override
        public void process(IBlockAccess world) {
            this.message.handle((EntityPlayer)this.playerMP, this);
        }
    }

    private static interface ISimpleHandler {
        public void handle(EntityPlayer var1, ItemStack var2, ItemMatterManipulator var3, MMState var4);
    }

    private static interface IEnumSetter<E extends Enum<E>> {
        public void set(EntityPlayer var1, ItemStack var2, ItemMatterManipulator var3, MMState var4, E var5);
    }

    private static interface IIntSetter {
        public void set(EntityPlayer var1, ItemStack var2, ItemMatterManipulator var3, MMState var4, int var5);
    }

    private static class SoundPacket
    extends SimplePacket {
        public int worldId;
        public long location;
        public int sound;
        public float strength;
        public float pitch;

        public SoundPacket(Messages message) {
            super(message);
        }

        @Override
        public void encode(ByteBuf buffer) {
            buffer.writeInt(this.worldId);
            buffer.writeLong(this.location);
            buffer.writeInt(this.sound);
            buffer.writeFloat(this.strength);
            buffer.writeFloat(this.pitch);
        }

        @Override
        public MMPacket decode(ByteArrayDataInput buffer) {
            SoundPacket message = new SoundPacket(this.message);
            message.worldId = buffer.readInt();
            message.location = buffer.readLong();
            message.sound = buffer.readInt();
            message.strength = buffer.readFloat();
            message.pitch = buffer.readFloat();
            return message;
        }
    }

    private static interface ILocationSetter {
        public void set(EntityPlayer var1, ItemStack var2, ItemMatterManipulator var3, MMState var4, Vector3i var5);
    }

    private static class BuildStatusPacket
    extends SimplePacket {
        public LongList errors;
        public LongList warnings;

        public BuildStatusPacket(Messages message) {
            super(message);
        }

        @Override
        public void encode(ByteBuf buffer) {
            int i;
            int size;
            buffer.writeInt(this.errors == null ? 0 : this.errors.size());
            if (this.errors != null) {
                size = this.errors.size();
                for (i = 0; i < size; ++i) {
                    buffer.writeLong(this.errors.getLong(i));
                }
            }
            buffer.writeInt(this.warnings == null ? 0 : this.warnings.size());
            if (this.warnings != null) {
                size = this.warnings.size();
                for (i = 0; i < size; ++i) {
                    buffer.writeLong(this.warnings.getLong(i));
                }
            }
        }

        @Override
        public MMPacket decode(ByteArrayDataInput buffer) {
            int i;
            BuildStatusPacket message = new BuildStatusPacket(this.message);
            int size = buffer.readInt();
            if (size > 0) {
                LongArrayList errors = new LongArrayList();
                errors.size(size);
                for (i = 0; i < size; ++i) {
                    errors.set(i, buffer.readLong());
                }
                message.errors = errors;
            }
            if ((size = buffer.readInt()) > 0) {
                LongArrayList warnings = new LongArrayList();
                warnings.size(size);
                for (i = 0; i < size; ++i) {
                    warnings.set(i, buffer.readLong());
                }
                message.warnings = warnings;
            }
            return message;
        }
    }

    private static class LocationPacket
    extends SimplePacket {
        public long location;

        public LocationPacket(Messages message) {
            super(message);
        }

        @Override
        public void encode(ByteBuf buffer) {
            buffer.writeLong(this.location);
        }

        @Override
        public MMPacket decode(ByteArrayDataInput buffer) {
            LocationPacket message = new LocationPacket(this.message);
            message.location = buffer.readLong();
            return message;
        }
    }

    private static class UplinkPacket
    extends SimplePacket {
        public int worldId;
        public long location;
        public byte state;

        public UplinkPacket(Messages message) {
            super(message);
        }

        public void setState(Location location, UplinkState state) {
            this.worldId = location.worldId;
            this.location = CoordinatePacker.pack((int)location.x, (int)location.y, (int)location.z);
            this.state = (byte)state.ordinal();
        }

        public Location getLocation() {
            return new Location(this.worldId, CoordinatePacker.unpackX((long)this.location), CoordinatePacker.unpackY((long)this.location), CoordinatePacker.unpackZ((long)this.location));
        }

        public UplinkState getState() {
            return UplinkState.values()[this.state];
        }

        @Override
        public void encode(ByteBuf buffer) {
            buffer.writeInt(this.worldId);
            buffer.writeLong(this.location);
            buffer.writeByte((int)this.state);
        }

        @Override
        public MMPacket decode(ByteArrayDataInput buffer) {
            UplinkPacket message = new UplinkPacket(this.message);
            message.worldId = buffer.readInt();
            message.location = buffer.readLong();
            message.state = buffer.readByte();
            return message;
        }
    }

    private static class IntPacket
    extends SimplePacket {
        public int value;

        public IntPacket(Messages message) {
            super(message);
        }

        @Override
        public void encode(ByteBuf buffer) {
            buffer.writeInt(this.value);
        }

        @Override
        public MMPacket decode(ByteArrayDataInput buffer) {
            IntPacket message = new IntPacket(this.message);
            message.value = buffer.readInt();
            return message;
        }

        public String toString() {
            return "IntPacket [message=" + (Object)((Object)this.message) + ", value=" + this.value + " (0b" + Integer.toBinaryString(this.value) + ")]";
        }
    }
}

