/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.data.WeightedSpecList;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Transform;
import javax.annotation.Nullable;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class MMConfig {
    public MMState.PendingAction action;
    public MMState.BlockSelectMode blockSelectMode = MMState.BlockSelectMode.ALL;
    public MMState.BlockRemoveMode removeMode = MMState.BlockRemoveMode.NONE;
    public MMState.PlaceMode placeMode = MMState.PlaceMode.GEOMETRY;
    public MMState.Shape shape = MMState.Shape.LINE;
    public Location coordA;
    public Location coordB;
    public Location coordC;
    public Vector3i coordAOffset;
    public Vector3i coordBOffset;
    public Vector3i coordCOffset;
    public WeightedSpecList corners = new WeightedSpecList(BlockSpec.air());
    public WeightedSpecList edges = new WeightedSpecList(BlockSpec.air());
    public WeightedSpecList faces = new WeightedSpecList(BlockSpec.air());
    public WeightedSpecList volumes = new WeightedSpecList(BlockSpec.air());
    public BlockSpec cables = BlockSpec.air();
    public WeightedSpecList replaceWhitelist = new WeightedSpecList(BlockSpec.air());
    public WeightedSpecList replaceWith = new WeightedSpecList(BlockSpec.air());
    @Nullable
    public Transform transform;
    public Vector3i arraySpan;

    public Location getCoordA(World world, Vector3i lookingAt) {
        if (this.coordAOffset == null) {
            return this.coordA;
        }
        return new Location(world, new Vector3i((Vector3ic)lookingAt).add((Vector3ic)this.coordAOffset));
    }

    public Location getCoordB(World world, Vector3i lookingAt) {
        if (this.coordBOffset == null) {
            return this.coordB;
        }
        return new Location(world, new Vector3i((Vector3ic)lookingAt).add((Vector3ic)this.coordBOffset));
    }

    public Location getCoordC(World world, Vector3i lookingAt) {
        if (this.coordCOffset == null) {
            return this.coordC;
        }
        return new Location(world, new Vector3i((Vector3ic)lookingAt).add((Vector3ic)this.coordCOffset));
    }

    public Vector3i getArrayMult(World world, Location sourceA, Location sourceB, Location dest, Vector3i lookingAt) {
        if (!Location.areCompatible(sourceA, sourceB, dest)) {
            return new Vector3i(1);
        }
        Vector3i array = new Vector3i((Vector3ic)lookingAt).sub((Vector3ic)dest.toVec());
        Vector3i delta = sourceB.toVec().sub((Vector3ic)sourceA.toVec());
        if (this.transform != null) {
            Vector3f v2 = new Vector3f((Vector3ic)array).mulTransposeDirection((Matrix4fc)new Matrix4f((Matrix4fc)this.transform.getRotation()).invert());
            array.x = Math.round(v2.x);
            array.y = Math.round(v2.y);
            array.z = Math.round(v2.z);
        }
        int n = delta.x == 0 ? array.x : (array.x = Math.floorDiv(array.x, delta.x + (delta.x < 0 ? -1 : 1)));
        int n2 = delta.y == 0 ? array.y : (array.y = Math.floorDiv(array.y, delta.y + (delta.y < 0 ? -1 : 1)));
        array.z = delta.z == 0 ? array.z : Math.floorDiv(array.z, delta.z + (delta.z < 0 ? -1 : 1));
        return array;
    }

    public VoxelAABB getPasteVisualDeltas(World world, boolean transform) {
        if (!Location.areCompatible(this.coordA, this.coordB, this.coordC)) {
            return null;
        }
        if (world != null && this.coordA.worldId != world.field_73011_w.field_76574_g) {
            return null;
        }
        VoxelAABB aabb = new VoxelAABB(this.coordA.toVec(), this.coordB.toVec());
        aabb.moveOrigin(this.coordC.toVec());
        if (this.arraySpan != null) {
            aabb.scale(this.arraySpan.x, this.arraySpan.y, this.arraySpan.z);
        }
        if (transform && this.transform != null) {
            this.transform.apply(aabb);
        }
        return aabb;
    }

    public VoxelAABB getCopyVisualDeltas(World world) {
        if (!Location.areCompatible(this.coordA, this.coordB)) {
            return null;
        }
        if (world != null && this.coordA.worldId != world.field_73011_w.field_76574_g) {
            return null;
        }
        return new VoxelAABB(this.coordA.toVec(), this.coordB.toVec());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.action == null ? 0 : this.action.hashCode());
        result = 31 * result + (this.blockSelectMode == null ? 0 : this.blockSelectMode.hashCode());
        result = 31 * result + (this.removeMode == null ? 0 : this.removeMode.hashCode());
        result = 31 * result + (this.placeMode == null ? 0 : this.placeMode.hashCode());
        result = 31 * result + (this.shape == null ? 0 : this.shape.hashCode());
        result = 31 * result + (this.coordA == null ? 0 : this.coordA.hashCode());
        result = 31 * result + (this.coordB == null ? 0 : this.coordB.hashCode());
        result = 31 * result + (this.coordC == null ? 0 : this.coordC.hashCode());
        result = 31 * result + (this.coordAOffset == null ? 0 : this.coordAOffset.hashCode());
        result = 31 * result + (this.coordBOffset == null ? 0 : this.coordBOffset.hashCode());
        result = 31 * result + (this.coordCOffset == null ? 0 : this.coordCOffset.hashCode());
        result = 31 * result + (this.corners == null ? 0 : this.corners.hashCode());
        result = 31 * result + (this.edges == null ? 0 : this.edges.hashCode());
        result = 31 * result + (this.faces == null ? 0 : this.faces.hashCode());
        result = 31 * result + (this.volumes == null ? 0 : this.volumes.hashCode());
        result = 31 * result + (this.cables == null ? 0 : this.cables.hashCode());
        result = 31 * result + (this.replaceWhitelist == null ? 0 : this.replaceWhitelist.hashCode());
        result = 31 * result + (this.replaceWith == null ? 0 : this.replaceWith.hashCode());
        result = 31 * result + (this.transform == null ? 0 : this.transform.hashCode());
        result = 31 * result + (this.arraySpan == null ? 0 : this.arraySpan.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MMConfig other = (MMConfig)obj;
        if (this.action != other.action) {
            return false;
        }
        if (this.blockSelectMode != other.blockSelectMode) {
            return false;
        }
        if (this.removeMode != other.removeMode) {
            return false;
        }
        if (this.placeMode != other.placeMode) {
            return false;
        }
        if (this.shape != other.shape) {
            return false;
        }
        if (this.coordA == null ? other.coordA != null : !this.coordA.equals(other.coordA)) {
            return false;
        }
        if (this.coordB == null ? other.coordB != null : !this.coordB.equals(other.coordB)) {
            return false;
        }
        if (this.coordC == null ? other.coordC != null : !this.coordC.equals(other.coordC)) {
            return false;
        }
        if (this.coordAOffset == null ? other.coordAOffset != null : !this.coordAOffset.equals((Object)other.coordAOffset)) {
            return false;
        }
        if (this.coordBOffset == null ? other.coordBOffset != null : !this.coordBOffset.equals((Object)other.coordBOffset)) {
            return false;
        }
        if (this.coordCOffset == null ? other.coordCOffset != null : !this.coordCOffset.equals((Object)other.coordCOffset)) {
            return false;
        }
        if (this.corners == null ? other.corners != null : !this.corners.equals(other.corners)) {
            return false;
        }
        if (this.edges == null ? other.edges != null : !this.edges.equals(other.edges)) {
            return false;
        }
        if (this.faces == null ? other.faces != null : !this.faces.equals(other.faces)) {
            return false;
        }
        if (this.volumes == null ? other.volumes != null : !this.volumes.equals(other.volumes)) {
            return false;
        }
        if (this.cables == null ? other.cables != null : !this.cables.equals(other.cables)) {
            return false;
        }
        if (this.replaceWhitelist == null ? other.replaceWhitelist != null : !this.replaceWhitelist.equals(other.replaceWhitelist)) {
            return false;
        }
        if (this.replaceWith == null ? other.replaceWith != null : !this.replaceWith.equals(other.replaceWith)) {
            return false;
        }
        if (this.transform == null ? other.transform != null : !this.transform.equals(other.transform)) {
            return false;
        }
        return !(this.arraySpan == null ? other.arraySpan != null : !this.arraySpan.equals((Object)other.arraySpan));
    }

    public static class VoxelAABB {
        public Vector3i origin;
        public Vector3i a;
        public Vector3i b;

        public VoxelAABB() {
            this.origin = new Vector3i();
            this.a = new Vector3i();
            this.b = new Vector3i();
        }

        public VoxelAABB(Vector3i a, Vector3i b) {
            this.origin = new Vector3i((Vector3ic)a);
            this.a = new Vector3i((Vector3ic)a);
            this.b = new Vector3i((Vector3ic)b);
        }

        public Vector3i min() {
            return new Vector3i((Vector3ic)this.a).min((Vector3ic)this.b);
        }

        public Vector3i max() {
            return new Vector3i((Vector3ic)this.a).max((Vector3ic)this.b);
        }

        public VoxelAABB union(Vector3i v) {
            Vector3i min = this.min();
            Vector3i max = this.max();
            this.a.set((Vector3ic)v).min((Vector3ic)min);
            this.b.set((Vector3ic)v).max((Vector3ic)max);
            return this;
        }

        public VoxelAABB union(VoxelAABB other) {
            Vector3i min = this.min();
            Vector3i max = this.max();
            this.a.set((Vector3ic)min).min((Vector3ic)other.min());
            this.b.set((Vector3ic)max).max((Vector3ic)other.max());
            return this;
        }

        public VoxelAABB moveOrigin(Vector3i newOrigin) {
            this.b.sub((Vector3ic)this.origin).add((Vector3ic)newOrigin);
            this.a.sub((Vector3ic)this.origin).add((Vector3ic)newOrigin);
            this.origin.set((Vector3ic)newOrigin);
            return this;
        }

        public VoxelAABB scale(int x, int y, int z) {
            int dirX = this.b.x < this.a.x ? -1 : 1;
            int dirY = this.b.y < this.a.y ? -1 : 1;
            int dirZ = this.b.z < this.a.z ? -1 : 1;
            Vector3i size = this.size();
            size.mul(x, y, z);
            size.mul(dirX, dirY, dirZ);
            size.add((Vector3ic)this.origin);
            VoxelAABB other = this.clone();
            other.moveOrigin(size);
            this.union(other);
            return this;
        }

        public VoxelAABB clone() {
            VoxelAABB dup = new VoxelAABB();
            dup.origin = new Vector3i((Vector3ic)this.origin);
            dup.a = new Vector3i((Vector3ic)this.a);
            dup.b = new Vector3i((Vector3ic)this.b);
            return dup;
        }

        public Vector3i span() {
            Vector3i min = this.min();
            Vector3i max = this.max();
            return new Vector3i(max.x - min.x, max.y - min.y, max.z - min.z);
        }

        public Vector3i size() {
            Vector3i min = this.min();
            Vector3i max = this.max();
            return new Vector3i(max.x - min.x + 1, max.y - min.y + 1, max.z - min.z + 1);
        }

        public AxisAlignedBB toBoundingBox() {
            Vector3i min = this.min();
            Vector3i max = this.max();
            return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)(max.x + 1), (double)(max.y + 1), (double)(max.z + 1));
        }

        public String describe() {
            Vector3i size = this.size();
            return String.format("dX=%,d dY=%,d dZ=%,d V=%,d", Math.abs(size.x), Math.abs(size.y), Math.abs(size.z), size.x * size.y * size.z);
        }
    }
}

