/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items;

import com.recursive_pineapple.matter_manipulator.common.items.IDMetaItem;
import com.recursive_pineapple.matter_manipulator.common.items.MMUpgrades;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.client.GTTooltipHandler;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class MetaItem
extends Item {
    public final String name;
    public final IIcon[] icons;
    public final IDMetaItem[] metaItems;

    public MetaItem(String name) {
        this.name = name;
        this.func_77627_a(true);
        this.func_77656_e(0);
        GameRegistry.registerItem((Item)this, (String)name);
        int max = Arrays.stream(IDMetaItem.values()).mapToInt(x -> x.ID).max().getAsInt();
        this.icons = new IIcon[max + 1];
        this.metaItems = new IDMetaItem[max + 1];
        IDMetaItem[] iDMetaItemArray = IDMetaItem.values();
        int n = iDMetaItemArray.length;
        for (int i = 0; i < n; ++i) {
            IDMetaItem id;
            this.metaItems[id.ID] = id = iDMetaItemArray[i];
            id.container.set(this, id.ID);
        }
    }

    public final Item func_77655_b(String aName) {
        return this;
    }

    public final String func_77658_a() {
        return this.name;
    }

    public String func_77667_c(ItemStack stack) {
        return "item." + this.name + "." + this.getDamage(stack);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> desc, boolean advancedTooltips) {
        MMUpgrades upgrade;
        super.func_77624_a(stack, player, desc, advancedTooltips);
        int meta = this.getDamage(stack);
        String descKey = "item." + this.name + "." + meta + ".desc";
        if (StatCollector.func_94522_b((String)descKey)) {
            desc.add(StatCollector.func_74838_a((String)descKey));
        }
        if ((upgrade = (MMUpgrades)((Object)MMUpgrades.UPGRADES_BY_META.get(meta))) != null) {
            desc.add(StatCollector.func_74838_a((String)"mm.upgrade.hint"));
            for (ItemMatterManipulator.ManipulatorTier tier : ItemMatterManipulator.ManipulatorTier.values()) {
                if (!tier.allowedUpgrades.contains((Object)upgrade)) continue;
                desc.add("- " + tier.container.stack.func_82833_r());
            }
        }
        if (Mods.GregTech.isModLoaded()) {
            String tooltip;
            IDMetaItem metaItem = MMUtils.getIndexSafe(this.metaItems, meta);
            String string = tooltip = metaItem != null ? MetaItem.getItemTier(metaItem) : null;
            if (tooltip != null) {
                desc.add(tooltip);
            }
        }
    }

    private static String getItemTier(IDMetaItem metaItem) {
        String string;
        switch (metaItem) {
            case PowerCore0: {
                string = Tier.HV.tooltip.get();
                break;
            }
            case ComputerCore0: {
                string = Tier.HV.tooltip.get();
                break;
            }
            case TeleporterCore0: {
                string = Tier.HV.tooltip.get();
                break;
            }
            case Frame0: {
                string = Tier.HV.tooltip.get();
                break;
            }
            case Lens0: {
                string = Tier.HV.tooltip.get();
                break;
            }
            case PowerCore1: {
                string = Tier.IV.tooltip.get();
                break;
            }
            case ComputerCore1: {
                string = Tier.IV.tooltip.get();
                break;
            }
            case TeleporterCore1: {
                string = Tier.IV.tooltip.get();
                break;
            }
            case Frame1: {
                string = Tier.IV.tooltip.get();
                break;
            }
            case Lens1: {
                string = Tier.IV.tooltip.get();
                break;
            }
            case PowerCore2: {
                string = Tier.LuV.tooltip.get();
                break;
            }
            case ComputerCore2: {
                string = Tier.LuV.tooltip.get();
                break;
            }
            case TeleporterCore2: {
                string = Tier.LuV.tooltip.get();
                break;
            }
            case Frame2: {
                string = Tier.LuV.tooltip.get();
                break;
            }
            case Lens2: {
                string = Tier.LuV.tooltip.get();
                break;
            }
            case PowerCore3: {
                string = Tier.ZPM.tooltip.get();
                break;
            }
            case ComputerCore3: {
                string = Tier.ZPM.tooltip.get();
                break;
            }
            case TeleporterCore3: {
                string = Tier.ZPM.tooltip.get();
                break;
            }
            case Frame3: {
                string = Tier.ZPM.tooltip.get();
                break;
            }
            case Lens3: {
                string = Tier.ZPM.tooltip.get();
                break;
            }
            case AEDownlink: {
                string = Tier.IV.tooltip.get();
                break;
            }
            case QuantumDownlink: {
                string = Tier.ZPM.tooltip.get();
                break;
            }
            case UpgradeBlank: {
                string = Tier.EV.tooltip.get();
                break;
            }
            case UpgradePowerP2P: {
                string = Tier.UHV.tooltip.get();
                break;
            }
            case UpgradePrototypeMining: {
                string = Tier.EV.tooltip.get();
                break;
            }
            case UpgradeSpeed: {
                string = Tier.EV.tooltip.get();
                break;
            }
            case UpgradePowerEff: {
                string = Tier.EV.tooltip.get();
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        for (IDMetaItem id : IDMetaItem.values()) {
            this.icons[id.ID] = iconRegister.func_94245_a(Mods.MatterManipulator.getResourcePath("metaitem", Integer.toString(id.ID)));
        }
    }

    public IIcon func_77617_a(int meta) {
        return MMUtils.getIndexSafe(this.icons, meta);
    }

    public void func_150895_a(Item self, CreativeTabs tab, List<ItemStack> subItems) {
        for (IDMetaItem id : IDMetaItem.values()) {
            subItems.add(new ItemStack((Item)this, 1, id.ID));
        }
    }

    private static enum Tier {
        ULV,
        LV,
        MV,
        HV,
        EV,
        IV,
        LuV,
        ZPM,
        UV,
        UHV,
        UEV,
        UIV,
        UMV,
        UXV,
        MAX,
        ERV;

        public final Supplier<String> tooltip = Mods.GregTech.isModLoaded() ? Tier.getForTier(this.name()) : () -> null;

        @Optional.Method(modid="gregtech")
        private static Supplier<String> getForTier(String tier) {
            GTTooltipHandler.Tier t = GTTooltipHandler.Tier.valueOf((String)tier);
            return (Supplier)ReflectionHelper.getPrivateValue(GTTooltipHandler.Tier.class, (Object)t, (String[])new String[]{"tooltip"});
        }
    }
}

