/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.recipes;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import dev.rndmorris.salisarcana.common.blocks.CustomBlocks;
import dev.rndmorris.salisarcana.common.recipes.FuelBurnTimeEventHandler;
import dev.rndmorris.salisarcana.common.recipes.RecipeForgivingPrimalCharm;
import dev.rndmorris.salisarcana.common.recipes.ReplaceWandCapsRecipe;
import dev.rndmorris.salisarcana.common.recipes.ReplaceWandCoreRecipe;
import dev.rndmorris.salisarcana.config.SalisConfig;
import dev.rndmorris.salisarcana.config.group.ConfigFeatures;
import dev.rndmorris.salisarcana.lib.recipe.EmptyJarRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.config.ConfigResearch;

public class CustomRecipes {
    @Nullable
    public static ReplaceWandCapsRecipe replaceWandCapsRecipe = null;
    @Nullable
    public static ReplaceWandCoreRecipe replaceWandCoreRecipe = null;

    public static void registerRecipes() {
        ConfigFeatures features = SalisConfig.features;
        if (features.lookalikePlanks.isEnabled()) {
            CustomRecipes.registerPlankRecipes();
        }
        if (features.lessPickyPrimalCharmRecipe.isEnabled()) {
            ThaumcraftApi.getCraftingRecipes().add(new RecipeForgivingPrimalCharm());
        }
        if (features.rotatedThaumometerRecipe.isEnabled()) {
            CustomRecipes.registerRotatedThaumometer();
        }
        if (SalisConfig.bugfixes.slabBurnTimeFix.isEnabled()) {
            MinecraftForge.EVENT_BUS.register((Object)new FuelBurnTimeEventHandler());
        }
        if (features.replaceWandCapsSettings.isEnabled()) {
            replaceWandCapsRecipe = new ReplaceWandCapsRecipe();
            ThaumcraftApi.getCraftingRecipes().add(replaceWandCapsRecipe);
        }
        if (features.replaceWandCoreSettings.isEnabled()) {
            replaceWandCoreRecipe = new ReplaceWandCoreRecipe();
            ThaumcraftApi.getCraftingRecipes().add(replaceWandCoreRecipe);
        }
        if (features.rottenFleshRecipe.isEnabled()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151078_bh, 9), (Object[])new Object[]{new ItemStack(ConfigBlocks.blockTaint, 1, 2)});
        }
        if (features.crystalClusterUncrafting.isEnabled()) {
            for (int metadata = 0; metadata <= 5; ++metadata) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ConfigItems.itemShard, 6, metadata), (Object[])new Object[]{new ItemStack(ConfigBlocks.blockCrystal, 1, metadata)});
            }
        }
        if (features.addEmptyPhialJarRecipes.isEnabled()) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(ConfigItems.itemEssence, 1), (Object[])new Object[]{new ItemStack(ConfigItems.itemEssence, 1, 1)});
            GameRegistry.addRecipe((IRecipe)new EmptyJarRecipe());
        }
    }

    public static void registerRecipesPostInit() {
        if (SalisConfig.features.rotatedFociRecipes.isEnabled()) {
            CustomRecipes.registerRotatedFoci();
        }
        if (SalisConfig.bugfixes.fixEFRRecipes.isEnabled() && Loader.isModLoaded((String)"etfuturum")) {
            CustomRecipes.registerEFRRecipes();
        }
    }

    private static void registerPlankRecipes() {
        ItemStack thaumGreatwoodPlanks = new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 6);
        ItemStack thaumSilverwoodPlanks = new ItemStack(ConfigBlocks.blockWoodenDevice, 1, 7);
        ItemStack arcanaGreatwoodPlanks = new ItemStack(CustomBlocks.blockPlank, 1, 0);
        ItemStack arcanaSilverwoodPlanks = new ItemStack(CustomBlocks.blockPlank, 1, 1);
        ItemStack conversionOutput = arcanaGreatwoodPlanks.func_77946_l();
        conversionOutput.field_77994_a = 8;
        GameRegistry.addShapelessRecipe((ItemStack)conversionOutput, (Object[])new Object[]{thaumGreatwoodPlanks, thaumGreatwoodPlanks, thaumGreatwoodPlanks, thaumGreatwoodPlanks, thaumGreatwoodPlanks, thaumGreatwoodPlanks, thaumGreatwoodPlanks, thaumGreatwoodPlanks});
        conversionOutput = arcanaSilverwoodPlanks.func_77946_l();
        conversionOutput.field_77994_a = 8;
        GameRegistry.addShapelessRecipe((ItemStack)conversionOutput, (Object[])new Object[]{thaumSilverwoodPlanks, thaumSilverwoodPlanks, thaumSilverwoodPlanks, thaumSilverwoodPlanks, thaumSilverwoodPlanks, thaumSilverwoodPlanks, thaumSilverwoodPlanks, thaumSilverwoodPlanks});
        conversionOutput = thaumGreatwoodPlanks.func_77946_l();
        conversionOutput.field_77994_a = 8;
        GameRegistry.addShapelessRecipe((ItemStack)conversionOutput, (Object[])new Object[]{arcanaGreatwoodPlanks, arcanaGreatwoodPlanks, arcanaGreatwoodPlanks, arcanaGreatwoodPlanks, arcanaGreatwoodPlanks, arcanaGreatwoodPlanks, arcanaGreatwoodPlanks, arcanaGreatwoodPlanks});
        conversionOutput = thaumSilverwoodPlanks.func_77946_l();
        conversionOutput.field_77994_a = 8;
        GameRegistry.addShapelessRecipe((ItemStack)conversionOutput, (Object[])new Object[]{arcanaSilverwoodPlanks, arcanaSilverwoodPlanks, arcanaSilverwoodPlanks, arcanaSilverwoodPlanks, arcanaSilverwoodPlanks, arcanaSilverwoodPlanks, arcanaSilverwoodPlanks, arcanaSilverwoodPlanks});
        ItemStack greatwoodSlabs = new ItemStack(ConfigBlocks.blockSlabWood, 6, 0);
        CustomRecipes.registerSlabRecipes(greatwoodSlabs, thaumGreatwoodPlanks, arcanaGreatwoodPlanks);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(greatwoodSlabs, new Object[]{"PPP", Character.valueOf('P'), "plankGreatwood"}));
        ItemStack silverwoodSlabs = new ItemStack(ConfigBlocks.blockSlabWood, 6, 1);
        CustomRecipes.registerSlabRecipes(silverwoodSlabs, thaumSilverwoodPlanks, arcanaSilverwoodPlanks);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(silverwoodSlabs, new Object[]{"PPP", Character.valueOf('P'), "plankSilverwood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ConfigBlocks.blockStairsGreatwood, 4, 0), new Object[]{"P  ", "PP ", "PPP", Character.valueOf('P'), "plankGreatwood"}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(ConfigBlocks.blockStairsSilverwood, 4, 0), new Object[]{"P  ", "PP ", "PPP", Character.valueOf('P'), "plankSilverwood"}));
    }

    private static void registerSlabRecipes(ItemStack output, ItemStack tcPlanks, ItemStack tfPlanks) {
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"CCF", Character.valueOf('C'), tcPlanks, Character.valueOf('F'), tfPlanks});
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"CFC", Character.valueOf('C'), tcPlanks, Character.valueOf('F'), tfPlanks});
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"FCC", Character.valueOf('C'), tcPlanks, Character.valueOf('F'), tfPlanks});
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"CFF", Character.valueOf('C'), tcPlanks, Character.valueOf('F'), tfPlanks});
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"FCF", Character.valueOf('C'), tcPlanks, Character.valueOf('F'), tfPlanks});
        GameRegistry.addShapedRecipe((ItemStack)output, (Object[])new Object[]{"FFF", Character.valueOf('F'), tfPlanks});
    }

    public static void registerEFRRecipes() {
        HashMap<Item, String> map = new HashMap<Item, String>();
        map.put(Item.func_150898_a((Block)Blocks.field_150415_aT), "trapdoorWood");
        for (Map.Entry entry : ConfigResearch.recipes.entrySet()) {
            ItemStack item;
            Object object;
            int i;
            Object input;
            Object v = entry.getValue();
            if (v instanceof ShapedArcaneRecipe) {
                ShapedArcaneRecipe recipe = (ShapedArcaneRecipe)v;
                input = recipe.getInput();
                for (i = 0; i < recipe.getInput().length; ++i) {
                    object = input[i];
                    if (!(object instanceof ItemStack) || !map.containsKey((item = (ItemStack)object).func_77973_b())) continue;
                    input[i] = OreDictionary.getOres((String)((String)map.get(item.func_77973_b())));
                }
                continue;
            }
            input = entry.getValue();
            if (!(input instanceof ShapelessArcaneRecipe)) continue;
            ShapelessArcaneRecipe recipe = (ShapelessArcaneRecipe)input;
            input = recipe.getInput();
            for (i = 0; i < ((ArrayList)input).size(); ++i) {
                object = ((ArrayList)input).get(i);
                if (!(object instanceof ItemStack) || !map.containsKey((item = (ItemStack)object).func_77973_b())) continue;
                ((ArrayList)input).set(i, OreDictionary.getOres((String)((String)map.get(item.func_77973_b()))));
            }
        }
    }

    private static void registerRotatedThaumometer() {
        ShapedOreRecipe recipe = new ShapedOreRecipe(ConfigItems.itemThaumometer, new Object[]{" I ", "SGS", " I ", Character.valueOf('I'), Items.field_151043_k, Character.valueOf('G'), Blocks.field_150359_w, Character.valueOf('S'), new ItemStack(ConfigItems.itemShard, 1, Short.MAX_VALUE)});
        GameRegistry.addRecipe((IRecipe)recipe);
    }

    private static void registerRotatedFoci() {
        HashSet toFind = new HashSet();
        ArrayList<ShapedArcaneRecipe> toAdd = new ArrayList<ShapedArcaneRecipe>();
        Collections.addAll(toFind, ConfigItems.itemFocusFire, ConfigItems.itemFocusShock, ConfigItems.itemFocusFrost, ConfigItems.itemFocusTrade, ConfigItems.itemFocusExcavation, ConfigItems.itemFocusPrimal);
        for (Object recipe : ThaumcraftApi.getCraftingRecipes()) {
            Item outputItem;
            ShapedArcaneRecipe arcaneRecipe;
            ItemStack output;
            if (!(recipe instanceof ShapedArcaneRecipe) || (output = (arcaneRecipe = (ShapedArcaneRecipe)recipe).getRecipeOutput()) == null || (outputItem = output.func_77973_b()) == null || !toFind.contains(outputItem)) continue;
            toAdd.add(CustomRecipes.createCopy(arcaneRecipe));
            toFind.remove(outputItem);
        }
        ThaumcraftApi.getCraftingRecipes().addAll(toAdd);
    }

    private static ShapedArcaneRecipe createCopy(ShapedArcaneRecipe inputRecipe) {
        ShapedArcaneRecipe newRecipe = new ShapedArcaneRecipe("DUMMY", new ItemStack(Items.field_151055_y), new AspectList(), new Object[]{"   ", " S ", "   ", Character.valueOf('S'), Items.field_151055_y});
        newRecipe.output = inputRecipe.output;
        newRecipe.input = CustomRecipes.copyRotated(inputRecipe.input);
        newRecipe.aspects = inputRecipe.aspects.copy();
        newRecipe.research = inputRecipe.research;
        newRecipe.width = inputRecipe.width;
        newRecipe.height = inputRecipe.height;
        return newRecipe;
    }

    private static Object[] copyRotated(Object[] input) {
        Object[] output = new Object[9];
        for (int index = 0; index < input.length && index < 9; ++index) {
            int newIndex = CustomRecipes.getRotatedIndex(index);
            if (newIndex < 0) continue;
            output[newIndex] = input[index];
        }
        return output;
    }

    private static int getRotatedIndex(int index) {
        int n;
        switch (index) {
            case 0: {
                n = 1;
                break;
            }
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 5;
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 4;
                break;
            }
            case 5: {
                n = 8;
                break;
            }
            case 6: {
                n = 3;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            case 8: {
                n = 7;
                break;
            }
            default: {
                n = -1;
            }
        }
        return n;
    }
}

