/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTreeVanilla;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class WorldGenJungle
extends WorldGenTreeVanilla {
    public WorldGenJungle(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate(World world) {
        float vinesChance = 0.0f;
        if (this.girth >= 2) {
            this.height = (int)((float)this.height * 1.5f);
            vinesChance = 0.8f;
        }
        this.generateTreeTrunk(world, this.height, this.girth, vinesChance);
        if (this.height > 10) {
            ArrayList<ChunkCoordinates> branchCoords = new ArrayList<ChunkCoordinates>();
            for (int branchSpawn = 6; branchSpawn < this.height - 2; branchSpawn += world.field_73012_v.nextInt(4)) {
                branchCoords.addAll(this.generateBranches(world, branchSpawn, 0, 0, 0.5f, 0.0f, 2, 1, 0.25f));
            }
            for (ChunkCoordinates branchEnd : branchCoords) {
                this.generateAdjustedCylinder(world, branchEnd.field_71572_b, branchEnd.field_71574_a, branchEnd.field_71573_c, 0.0f, 1, this.leaf, WorldGenBase.EnumReplaceMode.NONE);
            }
        }
        int leafSpawn = this.height + 1;
        float canopyRadiusMultiplier = (float)this.height / 7.0f;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f * canopyRadiusMultiplier, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f * canopyRadiusMultiplier, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn, 1.9f * canopyRadiusMultiplier, 1, this.leaf);
    }
}

