/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.utils;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.client.gui.implementations.GuiPatternTerm;
import appeng.client.gui.implementations.GuiPatternTermEx;
import appeng.client.me.ItemRepo;
import appeng.container.AEBaseContainer;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerPatternTermEx;
import appeng.helpers.IContainerCraftingPacket;
import com.glodblock.github.client.gui.GuiFluidPatternTerminal;
import com.glodblock.github.client.gui.GuiFluidPatternTerminalEx;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminal;
import com.glodblock.github.client.gui.container.ContainerFluidPatternTerminalEx;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraftforge.common.util.ForgeDirection;
import thaumicenergistics.common.container.ContainerPartArcaneCraftingTerminal;

public class GuiUtils {
    private static final boolean isFluidCraftModloaded = Loader.isModLoaded((String)"ae2fc");

    public static boolean isCraftingSlot(Slot slot) {
        if (slot == null) {
            return false;
        }
        Container container = Minecraft.func_71410_x().field_71439_g.field_71070_bA;
        if (!GuiUtils.isPatternContainer(container)) {
            return false;
        }
        IContainerCraftingPacket cct = (IContainerCraftingPacket)container;
        IInventory craftMatrix = cct.getInventoryByName("crafting");
        return craftMatrix.equals(slot.field_75224_c);
    }

    public static boolean isFluidCraftPatternContainer(Container container) {
        return isFluidCraftModloaded && (container instanceof ContainerFluidPatternTerminal || container instanceof ContainerFluidPatternTerminalEx);
    }

    public static boolean isPatternContainer(Container container) {
        return container instanceof ContainerPatternTerm || container instanceof ContainerPatternTermEx || GuiUtils.isFluidCraftPatternContainer(container);
    }

    public static boolean isFluidCraftPatternTermEx(GuiScreen guiScreen) {
        return isFluidCraftModloaded && guiScreen instanceof GuiFluidPatternTerminalEx;
    }

    public static boolean isFluidCraftPatternTerm(GuiScreen guiScreen) {
        return isFluidCraftModloaded && guiScreen instanceof GuiFluidPatternTerminal;
    }

    public static boolean isPatternTerm(GuiScreen guiScreen) {
        return guiScreen instanceof GuiPatternTerm || guiScreen instanceof GuiPatternTermEx || isFluidCraftModloaded && (guiScreen instanceof GuiFluidPatternTerminal || guiScreen instanceof GuiFluidPatternTerminalEx);
    }

    public static ItemRepo getItemRepo(GuiContainer termGui) {
        Class<?> clazz = termGui.getClass();
        ItemRepo repo = null;
        while (repo == null && clazz != null) {
            try {
                repo = (ItemRepo)ReflectionHelper.findField(clazz, (String[])new String[]{"repo"}).get(termGui);
            }
            catch (ReflectionHelper.UnableToFindFieldException | IllegalAccessException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return repo;
    }

    public static List<IAEItemStack> getStorageStacks(GuiContainer termGui, Predicate<IAEItemStack> predicate) {
        ItemRepo repo;
        ArrayList<IAEItemStack> storageStacks = new ArrayList<IAEItemStack>();
        if (termGui != null && (repo = GuiUtils.getItemRepo(termGui)) != null) {
            try {
                IItemList list = (IItemList)ReflectionHelper.findField(ItemRepo.class, (String[])new String[]{"list"}).get(repo);
                for (IAEItemStack stack : list) {
                    if (!predicate.test(stack)) continue;
                    storageStacks.add(stack.copy());
                }
            }
            catch (Exception list) {
                // empty catch block
            }
            try {
                IAEItemStack[] pins = (IAEItemStack[])ReflectionHelper.findField(ItemRepo.class, (String[])new String[]{"pins"}).get(repo);
                for (int i = 0; i < pins.length; ++i) {
                    IAEItemStack stack;
                    stack = pins[i];
                    if (stack == null || !predicate.test(stack)) continue;
                    storageStacks.add(stack.copy());
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return storageStacks;
    }

    public static IGrid getGrid(Container container) {
        AEBaseContainer baseContainer;
        Object gridNode2;
        if (Loader.isModLoaded((String)"thaumicenergistics") && container instanceof ContainerPartArcaneCraftingTerminal) {
            ContainerPartArcaneCraftingTerminal act = (ContainerPartArcaneCraftingTerminal)container;
            IGridNode gridNode2 = act.terminal.getGridNode(ForgeDirection.UNKNOWN);
            if (gridNode2 == null) {
                return null;
            }
            return gridNode2.getGrid();
        }
        if (container instanceof AEBaseContainer && (gridNode2 = (baseContainer = (AEBaseContainer)container).getTarget()) instanceof IGridHost) {
            IGridHost gridHost = (IGridHost)gridNode2;
            if ((gridNode2 = gridHost.getGridNode(ForgeDirection.UNKNOWN)) == null) {
                return null;
            }
            return gridNode2.getGrid();
        }
        return null;
    }
}

