/*
 * Decompiled with CFR 0.152.
 */
package com.github.vfyjxf.nee.nei;

import appeng.container.slot.SlotCraftingMatrix;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.core.AELog;
import appeng.core.sync.AppEngPacket;
import appeng.util.Platform;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.recipe.GuiOverlayButton;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.GuiRecipeButton;
import codechicken.nei.recipe.IRecipeHandler;
import com.github.vfyjxf.nee.NotEnoughEnergistics;
import com.github.vfyjxf.nee.nei.NEETerminalOverlayButton;
import com.github.vfyjxf.nee.utils.Ingredient;
import com.github.vfyjxf.nee.utils.IngredientTracker;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.ReflectionHelper;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.p455w0rd.wirelesscraftingterminal.client.gui.GuiWirelessCraftingTerminal;
import net.p455w0rd.wirelesscraftingterminal.core.sync.WCTPacket;
import net.p455w0rd.wirelesscraftingterminal.core.sync.network.NetworkHandler;
import net.p455w0rd.wirelesscraftingterminal.core.sync.packets.PacketNEIRecipe;

public class NEECraftingTerminalHandler
implements IOverlayHandler {
    public static final NEECraftingTerminalHandler instance = new NEECraftingTerminalHandler();

    private NEECraftingTerminalHandler() {
    }

    public void overlayRecipe(GuiContainer firstGui, IRecipeHandler recipe, int recipeIndex, boolean shift) {
        try {
            List ingredients = recipe.getIngredientStacks(recipeIndex);
            if (Loader.isModLoaded((String)"ae2wct") && firstGui instanceof GuiWirelessCraftingTerminal) {
                this.moveItemsForWirelessCrafting(firstGui, ingredients);
            } else {
                appeng.core.sync.packets.PacketNEIRecipe packet = new appeng.core.sync.packets.PacketNEIRecipe(this.packIngredients(firstGui, ingredients, false));
                int packetSize = this.getPacketSize((AppEngPacket)packet);
                if (packetSize >= 32768) {
                    AELog.warn((String)("Recipe for " + recipe.getRecipeName() + " has too many variants, reduced version will be used"), (Object[])new Object[0]);
                    packet = new appeng.core.sync.packets.PacketNEIRecipe(this.packIngredients(firstGui, ingredients, true));
                }
                if (packetSize >= 0) {
                    appeng.core.sync.network.NetworkHandler.instance.sendToServer((AppEngPacket)packet);
                } else {
                    NotEnoughEnergistics.logger.error("Can't get packet size!");
                }
            }
        }
        catch (Error | Exception throwable) {
            // empty catch block
        }
    }

    public boolean canFillCraftingGrid(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        return this.presenceOverlay(firstGui, handler, recipeIndex).stream().allMatch(state -> state.isPresent());
    }

    private boolean testSize(NBTTagCompound recipe) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DataOutputStream outputStream = new DataOutputStream(bytes);
        CompressedStreamTools.func_74799_a((NBTTagCompound)recipe, (OutputStream)outputStream);
        return bytes.size() > 3072;
    }

    public List<GuiOverlayButton.ItemOverlayState> presenceOverlay(GuiContainer firstGui, IRecipeHandler handler, int recipeIndex) {
        IngredientTracker tracker = new IngredientTracker(firstGui, handler, recipeIndex);
        ArrayList<GuiOverlayButton.ItemOverlayState> itemPresenceSlots = new ArrayList<GuiOverlayButton.ItemOverlayState>();
        for (Ingredient ingredient : tracker.getIngredients()) {
            itemPresenceSlots.add(new NEETerminalOverlayButton.NEEItemOverlayState(ingredient, true));
        }
        return itemPresenceSlots;
    }

    private NBTTagCompound packIngredients(GuiContainer gui, List<PositionedStack> ingredients, boolean limited) throws IOException {
        NBTTagCompound recipe = new NBTTagCompound();
        block0: for (PositionedStack positionedStack : ingredients) {
            if (positionedStack.items == null || positionedStack.items.length <= 0) continue;
            int col = (positionedStack.relx - 25) / 18;
            int row = (positionedStack.rely - 6) / 18;
            for (Slot slot : gui.field_147002_h.field_75151_b) {
                if (!this.isCraftingMatrixSlot(gui, slot) || slot.getSlotIndex() != col + row * 3) continue;
                NBTTagList tags = new NBTTagList();
                LinkedList<ItemStack> list = new LinkedList<ItemStack>();
                for (ItemStack stack : positionedStack.getFilteredPermutations()) {
                    if (Platform.isRecipePrioritized((ItemStack)(stack = stack.func_77946_l()))) {
                        list.add(0, stack);
                        continue;
                    }
                    list.add(stack);
                }
                for (ItemStack is : list) {
                    tags.func_74742_a((NBTBase)is.func_77955_b(new NBTTagCompound()));
                    if (!limited) continue;
                    NBTTagCompound test = new NBTTagCompound();
                    test.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                    if (!this.testSize(test)) continue;
                    break;
                }
                recipe.func_74782_a("#" + slot.getSlotIndex(), (NBTBase)tags);
                continue block0;
            }
        }
        return recipe;
    }

    private boolean isCraftingMatrixSlot(GuiContainer gui, Slot slot) {
        return slot instanceof SlotCraftingMatrix || slot instanceof SlotFakeCraftingMatrix;
    }

    private int getPacketSize(AppEngPacket packet) {
        try {
            ByteBuf p = (ByteBuf)ReflectionHelper.findField(AppEngPacket.class, (String[])new String[]{"p"}).get(packet);
            return p.array().length;
        }
        catch (IllegalAccessException e) {
            return -1;
        }
    }

    @Optional.Method(modid="ae2wct")
    private void moveItemsForWirelessCrafting(GuiContainer firstGui, List<PositionedStack> ingredients) {
        try {
            NetworkHandler.instance.sendToServer((WCTPacket)new PacketNEIRecipe(this.packIngredients(firstGui, ingredients, false)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void onActionPerformedEventPost(GuiRecipeButton.UpdateRecipeButtonsEvent.Post event) {
        GuiRecipe guiRecipe;
        GuiScreen guiScreen = event.gui;
        if (guiScreen instanceof GuiRecipe && NEECraftingTerminalHandler.isGuiCraftingTerm(guiRecipe = (GuiRecipe)guiScreen)) {
            NEETerminalOverlayButton.updateRecipeButtons(guiRecipe, event.buttonList);
        }
    }

    public static boolean isGuiCraftingTerm(GuiRecipe<?> gui) {
        return gui.firstGui != null && NEECraftingTerminalHandler.class.isInstance(gui.getHandler().getOverlayHandler(gui.firstGui, 0));
    }
}

