/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.proxy;

import ca.wescook.nutrition.data.NutrientManager;
import ca.wescook.nutrition.events.EventNutritionButton;
import ca.wescook.nutrition.events.EventNutritionKey;
import ca.wescook.nutrition.events.EventTooltip;
import ca.wescook.nutrition.proxy.CommonProxy;
import ca.wescook.nutrition.utility.Config;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import java.util.Stack;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.common.MinecraftForge;

public class ClientProxy
extends CommonProxy {
    public static NutrientManager localNutrition;
    public static KeyBinding keyNutritionGui;
    private static final Stack<Integer> hungerValues;

    @Override
    public void init(FMLInitializationEvent event) {
        if (Config.enableGui) {
            keyNutritionGui = new KeyBinding("key.nutrition", 0, "Nutrition");
            ClientRegistry.registerKeyBinding((KeyBinding)keyNutritionGui);
            FMLCommonHandler.instance().bus().register((Object)new EventNutritionKey());
            if (Config.enableGuiButton) {
                MinecraftForge.EVENT_BUS.register((Object)new EventNutritionButton());
            }
        }
        if (Config.enableTooltips) {
            MinecraftForge.EVENT_BUS.register((Object)new EventTooltip());
        }
    }

    public static void pushHungerChange(int hungerValue) {
        hungerValues.push(hungerValue);
    }

    public static void popHungerChange() {
        if (!hungerValues.empty()) {
            hungerValues.pop();
        }
    }

    public static int getUnappliedHungerValues() {
        int unapplied = 0;
        while (!hungerValues.empty()) {
            unapplied += hungerValues.pop().intValue();
        }
        return unapplied;
    }

    static {
        hungerValues = new Stack();
    }
}

