/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.mixinplugin;

import com.gtnewhorizon.gtnhmixins.IEarlyMixinLoader;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import ganymedes01.etfuturum.compat.CompatMisc;
import ganymedes01.etfuturum.configuration.ConfigBase;
import ganymedes01.etfuturum.configuration.configs.ConfigEnchantsPotions;
import ganymedes01.etfuturum.configuration.configs.ConfigEntities;
import ganymedes01.etfuturum.configuration.configs.ConfigMixins;
import ganymedes01.etfuturum.configuration.configs.ConfigTweaks;
import ganymedes01.etfuturum.lib.Reference;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.launchwrapper.Launch;
import org.spongepowered.asm.mixin.MixinEnvironment;

@IFMLLoadingPlugin.Name(value="EtFuturumEarlyMixins")
@IFMLLoadingPlugin.MCVersion(value="1.7.10")
public class EtFuturumEarlyMixins
implements IFMLLoadingPlugin,
IEarlyMixinLoader {
    public static final MixinEnvironment.Side side = MixinEnvironment.getCurrentEnvironment().getSide();

    public void initConfigs() {
        String configDir = "config" + File.separator + "etfuturum";
        File olderFile = new File(Launch.minecraftHome, "config" + File.separator + "etfuturum.cfg");
        File oldFile = new File(Launch.minecraftHome, configDir + File.separator + "etfuturum.cfg");
        oldFile.getParentFile().mkdirs();
        if (olderFile.exists()) {
            try {
                Files.copy(olderFile.toPath(), oldFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            olderFile.delete();
            Reference.launchConfigWarning = true;
        }
        if (oldFile.exists()) {
            Reference.launchConfigWarning = true;
        }
        ConfigBase.initializeConfigs();
        CompatMisc.doLwjgl3ifyCompat();
    }

    public String getMixinConfig() {
        return "mixins.etfuturum.early.json";
    }

    public List<String> getMixins(Set<String> loadedCoreMods) {
        this.initConfigs();
        ArrayList<String> mixins = new ArrayList<String>();
        if (ConfigMixins.endPortalFix) {
            mixins.add("endportal.MixinBlockEndPortal");
        }
        if (ConfigMixins.fenceWallConnectFix) {
            mixins.add("fencewallconnect.MixinBlockWall");
            mixins.add("fencewallconnect.MixinBlockFence");
        }
        if (ConfigMixins.stepHeightFix) {
            mixins.add("stepfix.MixinEntity");
        }
        if (ConfigMixins.enableSpectatorMode) {
            mixins.add("spectator.MixinGameType");
            mixins.add("spectator.MixinEntity");
            mixins.add("spectator.MixinWorld");
            mixins.add("spectator.MixinWorldServer");
            mixins.add("spectator.MixinEntityPlayer");
            mixins.add("spectator.MixinNetHandlerPlayServer");
            mixins.add("spectator.MixinInventoryPlayer");
            mixins.add("spectator.MixinContainerChest");
            mixins.add("spectator.MixinSlot");
            mixins.add("spectator.MixinCommandGameMode");
            if (side == MixinEnvironment.Side.CLIENT) {
                mixins.add("spectator.client.MixinEntityRenderer");
                mixins.add("spectator.client.MixinEntityPlayer");
                mixins.add("spectator.client.MixinWorldRenderer");
            }
        }
        if (ConfigMixins.avoidDroppingItemsWhenClosing) {
            mixins.add("closedrops.MixinEntityPlayerMP");
        }
        if (ConfigMixins.enableElytra) {
            mixins.add("backlytra.MixinEntityPlayer");
            mixins.add("backlytra.MixinEntityLivingBase");
            mixins.add("backlytra.MixinNetHandlerPlayServer");
            mixins.add("backlytra.MixinEntityTrackerEntry");
            if (loadedCoreMods.stream().anyMatch(name -> name.contains("thaumcraft"))) {
                mixins.add("backlytra.thaumcraft.MixinEventHandlerEntity");
            }
            if (side == MixinEnvironment.Side.CLIENT) {
                mixins.add("backlytra.client.MixinAbstractClientPlayer");
                mixins.add("backlytra.client.MixinEntityPlayerSP");
                mixins.add("backlytra.client.MixinRenderPlayer");
                mixins.add("backlytra.client.MixinModelBiped");
                mixins.add("backlytra.client.MixinEntityRenderer");
            }
        }
        if (ConfigMixins.enableDoWeatherCycle) {
            mixins.add("doweathercycle.MixinCommandHandler");
            mixins.add("doweathercycle.MixinWorldInfo");
        }
        if (ConfigMixins.enableRandomTickSpeed) {
            mixins.add("randomtickspeed.MixinWorldServer");
            mixins.add("randomtickspeed.MixinGameRules");
        }
        if (ConfigMixins.creativeFlightSpeedModifier > 1.0f || ConfigTweaks.creativeFlightVerticalModifier > 1.0f) {
            mixins.add("flyspeed.MixinEntityPlayer");
        }
        if (ConfigMixins.bouncyBeds) {
            mixins.add("bouncybeds.MixinBlockBed");
        }
        if (ConfigMixins.newHurtSounds) {
            mixins.add("sounds.MixinEntityPlayer");
            if (side == MixinEnvironment.Side.CLIENT) {
                mixins.add("sounds.client.MixinEntityClientPlayerMP");
            }
        }
        if (ConfigMixins.newMobSounds) {
            mixins.add("sounds.MixinEntitySnowman");
            mixins.add("sounds.MixinEntitySkeleton");
            mixins.add("sounds.MixinEntitySquid");
            mixins.add("sounds.MixinEntityWitch");
        }
        if (ConfigMixins.floorCeilingButtons) {
            mixins.add("floorceilbutton.MixinBlockButton");
        }
        if (ConfigMixins.newEnderEyeSounds) {
            mixins.add("sounds.MixinItemEnderEye");
            mixins.add("sounds.MixinEntityEnderEye");
        }
        if (ConfigMixins.newEnchantingSounds) {
            mixins.add("sounds.MixinContainerEnchantment");
        }
        if (ConfigMixins.newFishingRodSounds) {
            mixins.add("sounds.MixinItemFishingRod");
        }
        if (ConfigMixins.newBeaconSounds) {
            mixins.add("sounds.MixinTileEntityBeacon");
        }
        if (ConfigMixins.hoeTilling) {
            mixins.add("sounds.MixinItemHoe");
        }
        if (ConfigMixins.enableObservers) {
            mixins.add("observer.MixinWorld");
            mixins.add("observer.MixinWorldServer");
            mixins.add("observer.MixinChunk");
        }
        if (ConfigMixins.arrowFallingFix) {
            mixins.add("fallingarrowfix.MixinEntityArrow");
        }
        if (ConfigMixins.blockHopperInteraction) {
            mixins.add("blockinventories.MixinTileEntityHopper");
        }
        if (ConfigMixins.collidedThrowableFix) {
            mixins.add("projectilecollidefix.MixinEntityThrowable");
        }
        if (ConfigMixins.postTreeGenEvent && ConfigEntities.enableBees) {
            mixins.add("posttreegen.MixinWorldGenAbstractTree");
        }
        if (ConfigMixins.ladderTrapdoors) {
            mixins.add("laddertrapdoors.MixinBlockLadder");
            mixins.add("laddertrapdoors.MixinBlockTrapdoor");
        }
        if (ConfigMixins.betterPistons) {
            mixins.add("backinslime.MixinBlockPistonBase");
        }
        if (ConfigMixins.soulFire) {
            mixins.add("soulfire.MixinBlockFire");
            if (loadedCoreMods.stream().anyMatch(name -> name.contains("rple"))) {
                mixins.add("soulfire.MixinBlockFireRPLE");
            }
            mixins.add("soulfire.MixinEntity");
            if (side == MixinEnvironment.Side.CLIENT) {
                mixins.add("soulfire.MixinRenderBlocks");
            }
        }
        if (ConfigMixins.hideSingleLevelEnchants) {
            mixins.add("singlelevel.MixinEnchantment");
        }
        if (ConfigMixins.fireproofItems) {
            mixins.add("uninflammableitem.MixinEntityItem");
        }
        if (side == MixinEnvironment.Side.CLIENT) {
            if (ConfigMixins.dustUnderFallingBlocks) {
                mixins.add("blockfallingparticles.client.MixinBlockFalling");
            }
            if (ConfigMixins.adjustedAttenuation) {
                mixins.add("sounds.client.MixinSoundManager_Attenuation");
            }
            if (ConfigMixins.boundedBlockBreakingParticles) {
                mixins.add("boundedparticles.client.MixinEffectRenderer");
            }
            if (ConfigMixins.furnaceCrackle) {
                mixins.add("sounds.client.MixinBlockFurnace");
            }
            if (ConfigEnchantsPotions.enableSwiftSneak) {
                mixins.add("swiftsneak.client.MixinMovementInputFromOptions");
            }
            if (ConfigMixins.flowerPotFixes) {
                mixins.add("flowerpotfix.client.MixinRenderBlocks");
            }
            if (ConfigMixins.colorGrassBlockItemSides) {
                mixins.add("coloredgrassitem.client.MixinRenderBlocks");
            }
        }
        if (ConfigMixins.thinPanes) {
            mixins.add("thinpanes.MixinBlockPane");
            if (side == MixinEnvironment.Side.CLIENT) {
                mixins.add("thinpanes.MixinRenderBlocks");
            }
        }
        if (ConfigMixins.enablePlayersSleepingPecentageGamerule) {
            mixins.add("playerssleepingpercentage.MixinWorldServer");
        }
        if (ConfigEntities.enableFoxes) {
            mixins.add("foxes.MixinEntityLivingBase");
            mixins.add("foxes.MixinEntityWolf");
        }
        return mixins;
    }

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return null;
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }
}

