/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.tileentity;

import ganymedes01.etfuturum.client.renderer.tileentity.TileEntityNewBeaconRenderer;
import ganymedes01.etfuturum.configuration.configs.ConfigBlocksItems;
import ganymedes01.etfuturum.tileentities.TileEntityGateway;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileEntityGatewayRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final ResourceLocation END_GATEWAY_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void renderTileEntityAt(TileEntityGateway te, double x, double y, double z, float destroyStage) {
        GL11.glDisable((int)2912);
        if (te.isSpawning() || te.isCoolingDown()) {
            GL11.glAlphaFunc((int)516, (float)0.1f);
            this.func_147499_a(END_GATEWAY_BEAM_TEXTURE);
            float f = te.isSpawning() ? te.getSpawnPercent() : te.getCooldownPercent();
            double d0 = te.isSpawning() ? 256.0 - y : 25.0;
            f = MathHelper.func_76126_a((float)(f * (float)Math.PI));
            int j = MathHelper.func_76128_c((double)((double)f * d0));
            float[] afloat = EntitySheep.field_70898_d[te.isSpawning() ? ConfigBlocksItems.endGatewaySpawnColor : ConfigBlocksItems.endGatewayEntryColor];
            TileEntityNewBeaconRenderer.renderBeamSegment(x, y, z, destroyStage, f, te.func_145831_w().func_82737_E(), 0, j, afloat, 0.15, 0.175);
            TileEntityNewBeaconRenderer.renderBeamSegment(x, y, z, destroyStage, f, te.func_145831_w().func_82737_E(), 0, -j, afloat, 0.15, 0.175);
        }
        GL11.glDisable((int)2896);
        RANDOM.setSeed(31100L);
        GL11.glGetFloat((int)2982, (FloatBuffer)MODELVIEW);
        GL11.glGetFloat((int)2983, (FloatBuffer)PROJECTION);
        double d1 = x * x + y * y + z * z;
        int i = d1 > 36864.0 ? 2 : (d1 > 25600.0 ? 4 : (d1 > 16384.0 ? 6 : (d1 > 9216.0 ? 8 : (d1 > 4096.0 ? 10 : (d1 > 1024.0 ? 12 : (d1 > 576.0 ? 14 : (d1 > 256.0 ? 15 : 16)))))));
        for (int k = 0; k < i; ++k) {
            GL11.glPushMatrix();
            float f5 = 2.0f / (float)(18 - k);
            if (k == 0) {
                this.func_147499_a(END_SKY_TEXTURE);
                f5 = 0.15f;
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if (k >= 1) {
                this.func_147499_a(END_PORTAL_TEXTURE);
            }
            if (k == 1) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)1);
            }
            GL11.glTexGeni((int)8192, (int)9472, (int)9216);
            GL11.glTexGeni((int)8193, (int)9472, (int)9216);
            GL11.glTexGeni((int)8194, (int)9472, (int)9216);
            GL11.glTexGen((int)8192, (int)9474, (FloatBuffer)this.func_147525_a(1.0f, 0.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8193, (int)9474, (FloatBuffer)this.func_147525_a(0.0f, 1.0f, 0.0f, 0.0f));
            GL11.glTexGen((int)8194, (int)9474, (FloatBuffer)this.func_147525_a(0.0f, 0.0f, 1.0f, 0.0f));
            GL11.glEnable((int)3168);
            GL11.glEnable((int)3169);
            GL11.glEnable((int)3170);
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5890);
            GL11.glPushMatrix();
            GL11.glLoadIdentity();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.0f);
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            float f1 = k + 1;
            GL11.glTranslatef((float)(17.0f / f1), (float)((2.0f + f1 / 1.5f) * ((float)Minecraft.func_71386_F() % 800000.0f / 800000.0f)), (float)0.0f);
            GL11.glRotatef((float)((f1 * f1 * 4321.0f + f1 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glScalef((float)(4.5f - f1 / 4.0f), (float)(4.5f - f1 / 4.0f), (float)1.0f);
            GL11.glMultMatrix((FloatBuffer)PROJECTION);
            GL11.glMultMatrix((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.field_78398_a;
            tessellator.func_78382_b();
            float f2 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f5;
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f5;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f5;
            if (k == 0) {
                f3 = f4 = f5;
                f2 = f4;
            }
            tessellator.func_78386_a(f2, f3, f4);
            if (te.shouldRenderFace(EnumFacing.SOUTH)) {
                tessellator.func_78377_a(x, y, z + 1.0);
                tessellator.func_78377_a(x + 1.0, y, z + 1.0);
                tessellator.func_78377_a(x + 1.0, y + 1.0, z + 1.0);
                tessellator.func_78377_a(x, y + 1.0, z + 1.0);
            }
            if (te.shouldRenderFace(EnumFacing.NORTH)) {
                tessellator.func_78377_a(x, y + 1.0, z);
                tessellator.func_78377_a(x + 1.0, y + 1.0, z);
                tessellator.func_78377_a(x + 1.0, y, z);
                tessellator.func_78377_a(x, y, z);
            }
            if (te.shouldRenderFace(EnumFacing.WEST)) {
                tessellator.func_78377_a(x + 1.0, y + 1.0, z);
                tessellator.func_78377_a(x + 1.0, y + 1.0, z + 1.0);
                tessellator.func_78377_a(x + 1.0, y, z + 1.0);
                tessellator.func_78377_a(x + 1.0, y, z);
            }
            if (te.shouldRenderFace(EnumFacing.EAST)) {
                tessellator.func_78377_a(x, y, z);
                tessellator.func_78377_a(x, y, z + 1.0);
                tessellator.func_78377_a(x, y + 1.0, z + 1.0);
                tessellator.func_78377_a(x, y + 1.0, z);
            }
            if (te.shouldRenderFace(EnumFacing.DOWN)) {
                tessellator.func_78377_a(x, y, z);
                tessellator.func_78377_a(x + 1.0, y, z);
                tessellator.func_78377_a(x + 1.0, y, z + 1.0);
                tessellator.func_78377_a(x, y, z + 1.0);
            }
            if (te.shouldRenderFace(EnumFacing.UP)) {
                tessellator.func_78377_a(x, y + 1.0, z + 1.0);
                tessellator.func_78377_a(x + 1.0, y + 1.0, z + 1.0);
                tessellator.func_78377_a(x + 1.0, y + 1.0, z);
                tessellator.func_78377_a(x, y + 1.0, z);
            }
            tessellator.func_78381_a();
            GL11.glPopMatrix();
            GL11.glMatrixMode((int)5888);
            this.func_147499_a(END_SKY_TEXTURE);
        }
        GL11.glDisable((int)3042);
        GL11.glDisable((int)3168);
        GL11.glDisable((int)3169);
        GL11.glDisable((int)3170);
        GL11.glEnable((int)2896);
        GL11.glEnable((int)2912);
    }

    private FloatBuffer func_147525_a(float p_147525_1_, float p_147525_2_, float p_147525_3_, float p_147525_4_) {
        this.buffer.clear();
        this.buffer.put(p_147525_1_).put(p_147525_2_).put(p_147525_3_).put(p_147525_4_);
        this.buffer.flip();
        return this.buffer;
    }

    public void func_147500_a(TileEntity p_147500_1_, double p_147500_2_, double p_147500_4_, double p_147500_6_, float p_147500_8_) {
        this.renderTileEntityAt((TileEntityGateway)p_147500_1_, p_147500_2_, p_147500_4_, p_147500_6_, p_147500_8_);
    }
}

