/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.item.SubItem;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class SubItemToggle
extends SubItem {
    protected String inactiveAssetName;
    protected boolean defaultState = false;
    protected IIcon inactItemIcon;

    public SubItemToggle(String name, String assetName, String inactiveAssetName) {
        super(name, assetName);
        this.inactiveAssetName = inactiveAssetName;
    }

    public SubItemToggle(String name, String assetName, String inactiveAssetName, String info) {
        super(name, assetName, info);
        this.inactiveAssetName = inactiveAssetName;
    }

    public SubItemToggle(String name, String assetName, String inactiveAssetName, String info, boolean defaultState) {
        super(name, assetName, info);
        this.inactiveAssetName = inactiveAssetName;
        this.defaultState = defaultState;
    }

    public boolean getState(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("toggleState")) {
            return this.defaultState;
        }
        return nbt.func_74767_n("toggleState");
    }

    public void setState(ItemStack stack, boolean state) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
        }
        nbt.func_74757_a("toggleState", state);
    }

    public void toggleState(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("toggleState")) {
            nbt = new NBTTagCompound();
            stack.func_77982_d(nbt);
            nbt.func_74757_a("toggleState", !this.defaultState);
        } else {
            nbt.func_74757_a("toggleState", !nbt.func_74767_n("toggleState"));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        this.inactItemIcon = register.func_94245_a("amunra:" + this.inactiveAssetName);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack p_77650_1_) {
        if (this.getState(p_77650_1_)) {
            return this.field_77791_bV;
        }
        return this.inactItemIcon;
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        if (this.getState(stack)) {
            return this.field_77791_bV;
        }
        return this.inactItemIcon;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        this.toggleState(itemStackIn);
        return itemStackIn;
    }

    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List<String> p_77624_3_, boolean p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        if (this.getState(p_77624_1_)) {
            p_77624_3_.add(EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"gui.status.active.name"));
        } else {
            p_77624_3_.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"gui.status.disabled.name"));
        }
    }
}

