/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.rendering.RenderHelper3D;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.client.LittleTilesClient;
import com.creativemd.littletiles.common.packet.LittleFlipPacket;
import com.creativemd.littletiles.common.packet.LittleRotatePacket;
import com.creativemd.littletiles.common.utils.LittleTileBlockPos;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.utils.PreviewTile;
import com.creativemd.littletiles.utils.ShiftHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class PreviewRenderer {
    public static Minecraft mc = Minecraft.func_71410_x();
    public static LittleTileBlockPos markedHit = null;
    private static ItemStack lastItem = null;

    public void processKey(ForgeDirection direction) {
        LittleRotatePacket packet = new LittleRotatePacket(direction);
        packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
        PacketHandler.sendPacketToServer(packet);
    }

    private static ForgeDirection rotateDirection(ForgeDirection direction) {
        switch (direction) {
            case NORTH: {
                return ForgeDirection.EAST;
            }
            case EAST: {
                return ForgeDirection.SOUTH;
            }
            case SOUTH: {
                return ForgeDirection.WEST;
            }
            case WEST: {
                return ForgeDirection.NORTH;
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    public static void moveMarkedHit(ForgeDirection direction, ForgeDirection direction_look) {
        if (direction != ForgeDirection.UP && direction != ForgeDirection.DOWN) {
            if (direction_look == ForgeDirection.EAST) {
                direction = PreviewRenderer.rotateDirection(direction);
            }
            if (direction_look == ForgeDirection.SOUTH) {
                direction = PreviewRenderer.rotateDirection(direction);
                direction = PreviewRenderer.rotateDirection(direction);
            }
            if (direction_look == ForgeDirection.WEST) {
                direction = PreviewRenderer.rotateDirection(direction);
                direction = PreviewRenderer.rotateDirection(direction);
                direction = PreviewRenderer.rotateDirection(direction);
            }
        }
        int move = 1;
        if (GuiScreen.func_146271_m()) {
            move = 16;
        }
        markedHit.moveInDirection(direction, move);
    }

    @SubscribeEvent
    public void tick(RenderHandEvent event) {
        if (PreviewRenderer.mc.field_71439_g != null && PreviewRenderer.mc.field_71415_G) {
            if (!ItemStack.func_77970_a((ItemStack)lastItem, (ItemStack)PreviewRenderer.mc.field_71439_g.func_70694_bm())) {
                markedHit = null;
            }
            lastItem = PreviewRenderer.mc.field_71439_g.func_70694_bm();
            if (PlacementHelper.isLittleBlock(PreviewRenderer.mc.field_71439_g.func_70694_bm())) {
                int i4 = MathHelper.func_76128_c((double)((double)(PreviewRenderer.mc.field_71439_g.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
                ForgeDirection direction_look = null;
                switch (i4) {
                    case 0: {
                        direction_look = ForgeDirection.SOUTH;
                        break;
                    }
                    case 1: {
                        direction_look = ForgeDirection.WEST;
                        break;
                    }
                    case 2: {
                        direction_look = ForgeDirection.NORTH;
                        break;
                    }
                    case 3: {
                        direction_look = ForgeDirection.EAST;
                    }
                }
                if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.flip) && !LittleTilesClient.pressedFlip) {
                    LittleTilesClient.pressedFlip = true;
                    ForgeDirection direction = direction_look;
                    if (PreviewRenderer.mc.field_71439_g.field_70125_A > 45.0f) {
                        direction = ForgeDirection.DOWN;
                    }
                    if (PreviewRenderer.mc.field_71439_g.field_70125_A < -45.0f) {
                        direction = ForgeDirection.UP;
                    }
                    LittleFlipPacket packet = new LittleFlipPacket(direction);
                    packet.executeClient((EntityPlayer)PreviewRenderer.mc.field_71439_g);
                    PacketHandler.sendPacketToServer(packet);
                } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.flip)) {
                    LittleTilesClient.pressedFlip = false;
                }
                MovingObjectPosition look = PreviewRenderer.mc.field_71476_x;
                PlacementHelper helper = PlacementHelper.getInstance((EntityPlayer)PreviewRenderer.mc.field_71439_g);
                LittleTileBlockPos pos = null;
                if (look != null && look.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                    pos = LittleTileBlockPos.fromMovingObjectPosition(look);
                }
                if (markedHit != null) {
                    pos = markedHit;
                }
                if (pos != null && PreviewRenderer.mc.field_71439_g.func_70694_bm() != null) {
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.mark) && !LittleTilesClient.pressedMark) {
                        LittleTilesClient.pressedMark = true;
                        if (markedHit == null) {
                            markedHit = pos;
                            return;
                        }
                        markedHit = null;
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.mark)) {
                        LittleTilesClient.pressedMark = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.up) && !LittleTilesClient.pressedUp) {
                        LittleTilesClient.pressedUp = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(PreviewRenderer.mc.field_71439_g.func_70093_af() ? ForgeDirection.UP : ForgeDirection.NORTH, direction_look);
                        } else {
                            this.processKey(ForgeDirection.UP);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.up)) {
                        LittleTilesClient.pressedUp = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.down) && !LittleTilesClient.pressedDown) {
                        LittleTilesClient.pressedDown = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(PreviewRenderer.mc.field_71439_g.func_70093_af() ? ForgeDirection.DOWN : ForgeDirection.SOUTH, direction_look);
                        } else {
                            this.processKey(ForgeDirection.DOWN);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.down)) {
                        LittleTilesClient.pressedDown = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.right) && !LittleTilesClient.pressedRight) {
                        LittleTilesClient.pressedRight = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(ForgeDirection.EAST, direction_look);
                        } else {
                            this.processKey(ForgeDirection.SOUTH);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.right)) {
                        LittleTilesClient.pressedRight = false;
                    }
                    if (GameSettings.func_100015_a((KeyBinding)LittleTilesClient.left) && !LittleTilesClient.pressedLeft) {
                        LittleTilesClient.pressedLeft = true;
                        if (markedHit != null) {
                            PreviewRenderer.moveMarkedHit(ForgeDirection.WEST, direction_look);
                        } else {
                            this.processKey(ForgeDirection.NORTH);
                        }
                    } else if (!GameSettings.func_100015_a((KeyBinding)LittleTilesClient.left)) {
                        LittleTilesClient.pressedLeft = false;
                    }
                    GL11.glEnable((int)3042);
                    OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                    GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                    GL11.glLineWidth((float)2.0f);
                    GL11.glDisable((int)3553);
                    GL11.glDepthMask((boolean)false);
                    ArrayList<PreviewTile> previews = helper.getPreviewTiles(PreviewRenderer.mc.field_71439_g.func_70694_bm(), pos, markedHit != null);
                    double x = (double)pos.getPosX() - TileEntityRendererDispatcher.field_147554_b;
                    double y = (double)pos.getPosY() - TileEntityRendererDispatcher.field_147555_c;
                    double z = (double)pos.getPosZ() - TileEntityRendererDispatcher.field_147552_d;
                    for (PreviewTile previewTile : previews) {
                        GL11.glPushMatrix();
                        LittleTileBox previewBox = previewTile.getPreviewBox();
                        CubeObject cube = previewBox.getCube();
                        Vec3 size = previewBox.getSizeD();
                        double cubeX = x + cube.minX + size.field_72450_a / 2.0;
                        double cubeY = y + cube.minY + size.field_72448_b / 2.0;
                        double cubeZ = z + cube.minZ + size.field_72449_c / 2.0;
                        Vec3 color = previewTile.getPreviewColor();
                        RenderHelper3D.renderBlock(cubeX, cubeY, cubeZ, size.field_72450_a, size.field_72448_b, size.field_72449_c, 0.0, 0.0, 0.0, color.field_72450_a, color.field_72448_b, color.field_72449_c, Math.sin((double)System.nanoTime() / 2.0E8) * 0.2 + 0.5);
                        GL11.glPopMatrix();
                    }
                    if (markedHit == null && PreviewRenderer.mc.field_71439_g.func_70093_af()) {
                        ArrayList<ShiftHandler> shifthandlers = new ArrayList<ShiftHandler>();
                        for (PreviewTile preview : previews) {
                            if (preview.preview == null) continue;
                            shifthandlers.addAll(preview.preview.shifthandlers);
                        }
                        for (ShiftHandler shifthandler : shifthandlers) {
                            shifthandler.handleRendering(mc, x, y, z);
                        }
                    }
                    GL11.glDepthMask((boolean)true);
                    GL11.glEnable((int)3553);
                    GL11.glDisable((int)3042);
                }
            }
        }
    }
}

