/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.value;

import com.github.lunatrius.core.entity.EntityHelper;
import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.client.gui.InfoIcon;
import com.github.lunatrius.ingameinfo.client.gui.InfoItem;
import com.github.lunatrius.ingameinfo.handler.ConfigurationHandler;
import com.github.lunatrius.ingameinfo.reference.Reference;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.value.Operation;
import com.github.lunatrius.ingameinfo.value.Value;
import com.github.lunatrius.ingameinfo.value.registry.ValueRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public abstract class ValueComplex
extends Value {
    @Override
    public boolean isSimple() {
        return false;
    }

    public static void register() {
        ValueRegistry.INSTANCE.register(new ValueOperation().setName("op").setAliases("operation"));
        ValueRegistry.INSTANCE.register(new ValueConcat().setName("concat"));
        ValueRegistry.INSTANCE.register(new ValueMax().setName("max").setAliases("maximum"));
        ValueRegistry.INSTANCE.register(new ValueMin().setName("min").setAliases("minimum"));
        ValueRegistry.INSTANCE.register(new ValueItemQuantity().setName("itemquantity"));
        ValueRegistry.INSTANCE.register(new ValueTranslate().setName("trans").setAliases("translate"));
        ValueRegistry.INSTANCE.register(new ValueFormattedTime().setName("formattedtime").setAliases("rltimef"));
        ValueRegistry.INSTANCE.register(new ValueIcon().setName("icon").setAliases("img", "image"));
        ValueRegistry.INSTANCE.register(new ValueFile().setName("file"));
    }

    public static class ValueOperation
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() > 1;
        }

        @Override
        public String getValue() {
            try {
                Operation operation = Operation.fromString(this.getValue(0));
                return operation.getValue(this);
            }
            catch (Exception e) {
                return "";
            }
        }
    }

    public static class ValueConcat
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() > 1;
        }

        @Override
        public String getValue() {
            StringBuilder str = new StringBuilder();
            for (Value val : this.values) {
                str.append(this.replaceVariables(val.getValue()));
            }
            return str.toString();
        }
    }

    public static class ValueMax
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() == 2 || this.values.size() == 4;
        }

        @Override
        public String getValue() {
            try {
                double arg0 = this.getDoubleValue(0);
                double arg1 = this.getDoubleValue(1);
                int shift = this.values.size() - 2;
                return arg0 > arg1 ? this.getValue(shift) : this.getValue(1 + shift);
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class ValueMin
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() == 2 || this.values.size() == 4;
        }

        @Override
        public String getValue() {
            try {
                double arg0 = this.getDoubleValue(0);
                double arg1 = this.getDoubleValue(1);
                int shift = this.values.size() - 2;
                return arg0 < arg1 ? this.getValue(shift) : this.getValue(1 + shift);
            }
            catch (Exception e) {
                return "0";
            }
        }
    }

    public static class ValueItemQuantity
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() == 1 || this.values.size() == 2;
        }

        @Override
        public String getValue() {
            try {
                Item item;
                int itemDamage = -1;
                try {
                    item = (Item)GameData.getItemRegistry().func_82594_a(this.getValue(0));
                }
                catch (Exception e3) {
                    item = (Item)GameData.getItemRegistry().func_148754_a(this.getIntValue(0));
                }
                if (this.values.size() == 2) {
                    itemDamage = this.getIntValue(1);
                }
                return String.valueOf(EntityHelper.getItemCountInInventory((IInventory)Minecraft.func_71410_x().field_71439_g.field_71071_by, (Item)item, (int)itemDamage));
            }
            catch (Exception e2) {
                return "0";
            }
        }
    }

    public static class ValueTranslate
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() > 0;
        }

        @Override
        public String getValue() {
            try {
                String format = this.getValue(0);
                String[] args = new String[this.values.size() - 1];
                for (int i = 0; i < args.length; ++i) {
                    args[i] = this.getValue(i + 1);
                }
                return I18n.func_135052_a((String)format, (Object[])args);
            }
            catch (Exception e) {
                return "?";
            }
        }
    }

    public static class ValueFormattedTime
    extends ValueComplex {
        @Override
        public boolean isValidSize() {
            return this.values.size() == 1;
        }

        @Override
        public String getValue() {
            try {
                String format = this.getValue(0);
                return new SimpleDateFormat(format).format(new Date());
            }
            catch (Exception e) {
                return "?";
            }
        }
    }

    public static class ValueIcon
    extends ValueComplex {
        private static int lastId;

        public ValueIcon() {
            this.setName("icon" + lastId++);
        }

        @Override
        public boolean isValidSize() {
            return this.values.size() == 1 || this.values.size() == 2 || this.values.size() == 5 || this.values.size() == 7 || this.values.size() == 11;
        }

        @Override
        public String getValue() {
            try {
                int size = this.values.size();
                String what = this.getValue(0);
                Info value = this.parent.getAttachedValue(this.getName());
                if (value != null && value.getIdentifier().equals(what)) {
                    return value.getIconSpacing();
                }
                if (!(size != 1 && size != 2 || what.endsWith(".png"))) {
                    ItemStack itemStack;
                    int metadata = 0;
                    if (size == 2) {
                        metadata = this.getIntValue(1);
                        Block block = (Block)GameData.getBlockRegistry().func_82594_a(what);
                        if (block == Blocks.field_150398_cm) {
                            metadata &= 7;
                        }
                    }
                    if ((itemStack = new ItemStack((Item)GameData.getItemRegistry().func_82594_a(what), 1, metadata)).func_77973_b() == null) {
                        itemStack = new ItemStack((Block)GameData.getBlockRegistry().func_82594_a(what), 1, metadata);
                    }
                    if (itemStack.func_77973_b() == null) {
                        return "";
                    }
                    if (value == null) {
                        InfoItem item = new InfoItem(itemStack);
                        item.setIdentifier(what);
                        this.parent.attachValue(this.getName(), item);
                        return Tag.getIconTag(item);
                    }
                    value.setIdentifier(what);
                    value.setValue(itemStack);
                    return value.getIconSpacing();
                }
                InfoIcon icon = value == null ? new InfoIcon(what) : (InfoIcon)value;
                icon.setIdentifier(what);
                int index = 0;
                if (size == 5 || size == 11) {
                    int displayX = this.getIntValue(++index);
                    int displayY = this.getIntValue(++index);
                    int displayWidth = this.getIntValue(++index);
                    int displayHeight = this.getIntValue(++index);
                    icon.setDisplayDimensions(displayX, displayY, displayWidth, displayHeight);
                }
                if (size == 7 || size == 11) {
                    int iconX = this.getIntValue(++index);
                    int iconY = this.getIntValue(++index);
                    int iconWidth = this.getIntValue(++index);
                    int iconHeight = this.getIntValue(++index);
                    int textureWidth = this.getIntValue(++index);
                    int textureHeight = this.getIntValue(++index);
                    icon.setTextureData(iconX, iconY, iconWidth, iconHeight, textureWidth, textureHeight);
                }
                if (value == null) {
                    this.parent.attachValue(this.getName(), icon);
                    return Tag.getIconTag(icon);
                }
                value.setValue(what);
                return value.getIconSpacing();
            }
            catch (Exception e) {
                return "?";
            }
        }
    }

    public static class ValueFile
    extends ValueComplex {
        private static int ticks = 0;
        private final Map<String, String> cache = new HashMap<String, String>();

        @Override
        public boolean isValidSize() {
            return this.values.size() == 1;
        }

        @Override
        public String getValue() {
            String line;
            String filename = this.getValue(0);
            if (ticks == 0) {
                File file;
                if (this.cache.size() > 16) {
                    Reference.logger.trace("Clearing file cache...");
                    this.cache.clear();
                }
                if ((file = new File(InGameInfoCore.INSTANCE.getConfigDirectory(), filename)).exists()) {
                    this.cache.put(filename, this.getLine(file));
                }
            }
            if ((line = this.cache.get(filename)) != null) {
                return line;
            }
            return "";
        }

        private String getLine(File file) {
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader reader = new BufferedReader(fileReader);
                String line = reader.readLine();
                reader.close();
                if (line.startsWith("\ufeff")) {
                    return line.substring(1);
                }
                return line;
            }
            catch (Exception e) {
                Reference.logger.error("", (Throwable)e);
                return "";
            }
        }

        public static void tick() {
            ticks = (ticks + 1) % (ConfigurationHandler.fileInterval * 20);
        }
    }
}

