/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Realtimers;

import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import org.lwjgl.opengl.GL11;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ModuleBase;

public class ModuleNote
extends ModuleBase {
    private final int maximumTracksPerModuleBitCount = 4;
    private final int maximumNotesPerTrackBitCount = 12;
    private int veryLongTrackLimit = 1024;
    private int notesInView = 13;
    private int tracksInView = 5;
    private int[] instrumentColors = new int[]{0x404040, 0xFF0000, 65280, 255, 0xFFFF00, 65535};
    private String[] pitchNames = new String[]{"F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B", "C", "C#", "D", "D#", "E", "F", "F#"};
    private Localization.MODULES.ATTACHMENTS[] instrumentNames = new Localization.MODULES.ATTACHMENTS[]{Localization.MODULES.ATTACHMENTS.PIANO, Localization.MODULES.ATTACHMENTS.BASS_DRUM, Localization.MODULES.ATTACHMENTS.SNARE_DRUM, Localization.MODULES.ATTACHMENTS.STICKS, Localization.MODULES.ATTACHMENTS.BASS_GUITAR};
    private ArrayList<Track> tracks;
    private int notemapX = 70;
    private int notemapY = 40;
    private int trackHeight = 20;
    private ArrayList<Button> buttons;
    private ArrayList<Button> instrumentbuttons;
    private int currentInstrument = -1;
    private Button createTrack;
    private Button removeTrack;
    private Button speedButton;
    private boolean isScrollingX;
    private boolean isScrollingXTune;
    private int scrollX;
    private boolean isScrollingY;
    private int scrollY;
    private int pixelScrollX;
    private int pixelScrollXTune;
    private int generatedScrollX;
    private int pixelScrollY;
    private int generatedScrollY;
    private int[] scrollXrect = new int[]{this.notemapX + 120, this.notemapY - 20, 100, 16};
    private int[] scrollYrect = new int[]{this.notemapX + 220, this.notemapY, 16, 100};
    private final int maximumNotesPerTrack = (int)Math.pow(2.0, 12.0) - 1;
    private final int maximumTracksPerModule = (int)Math.pow(2.0, 4.0) - 1;
    private int currentTick = 0;
    private int playProgress = 0;
    private boolean tooLongTrack = false;
    private boolean tooTallModule = false;
    private boolean veryLongTrack = false;
    private int speedSetting = 5;
    private short lastModuleHeader;

    public ModuleNote(MinecartModular cart) {
        super(cart);
        this.tracks = new ArrayList();
        if (this.getCart().field_70170_p.field_72995_K) {
            this.buttons = new ArrayList();
            this.createTrack = new Button(this.notemapX - 60, this.notemapY - 20);
            this.createTrack.text = Localization.MODULES.ATTACHMENTS.CREATE_TRACK.translate(new String[0]);
            this.createTrack.imageID = 0;
            this.removeTrack = new Button(this.notemapX - 40, this.notemapY - 20);
            this.removeTrack.text = Localization.MODULES.ATTACHMENTS.REMOVE_TRACK.translate(new String[0]);
            this.removeTrack.imageID = 1;
            this.speedButton = new Button(this.notemapX - 20, this.notemapY - 20);
            this.updateSpeedButton();
            this.instrumentbuttons = new ArrayList();
            for (int i = 0; i < 6; ++i) {
                Button tempButton = new Button(this.notemapX - 20 + (i + 1) * 20, this.notemapY - 20);
                this.instrumentbuttons.add(tempButton);
                tempButton.text = i > 0 ? Localization.MODULES.ATTACHMENTS.ACTIVATE_INSTRUMENT.translate(this.instrumentNames[i - 1].translate(new String[0])) : Localization.MODULES.ATTACHMENTS.DEACTIVATE_INSTRUMENT.translate(new String[0]);
                tempButton.color = this.instrumentColors[i];
            }
        }
    }

    private void updateSpeedButton() {
        if (this.getCart().field_70170_p.field_72995_K) {
            this.speedButton.imageID = 14 - this.speedSetting;
            this.speedButton.text = Localization.MODULES.ATTACHMENTS.NOTE_DELAY.translate(String.valueOf(this.getTickDelay()));
        }
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
        for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + this.tracksInView); ++i) {
            Track track = this.tracks.get(i);
            for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + this.notesInView); ++j) {
                Note note = track.notes.get(j);
                note.drawText(gui, i - this.getScrollY(), j - this.getScrollX());
            }
        }
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && !this.isPlaying()) {
            this.setPlaying(true);
        }
    }

    private int getTickDelay() {
        switch (this.speedSetting) {
            case 6: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 3: {
                return 5;
            }
            case 2: {
                return 7;
            }
            case 1: {
                return 11;
            }
            case 0: {
                return 13;
            }
        }
        return 0;
    }

    @Override
    public void update() {
        super.update();
        if (this.getCart().field_70170_p.field_72995_K) {
            int i;
            this.tooLongTrack = false;
            this.veryLongTrack = false;
            for (i = 0; i < this.tracks.size(); ++i) {
                Track track = this.tracks.get(i);
                if (track.notes.size() > this.notesInView) {
                    this.tooLongTrack = true;
                    if (track.notes.size() > this.veryLongTrackLimit) {
                        this.veryLongTrack = true;
                    }
                }
                int trackPacketID = -1;
                if (track.addButton.down) {
                    track.addButton.down = false;
                    trackPacketID = 0;
                } else if (track.removeButton.down) {
                    track.removeButton.down = false;
                    trackPacketID = 1;
                } else if (track.volumeButton.down) {
                    track.volumeButton.down = false;
                    trackPacketID = 2;
                }
                if (trackPacketID == -1) continue;
                byte info = (byte)(i | trackPacketID << 4);
                this.sendPacket(1, info);
            }
            if (!this.tooLongTrack) {
                this.pixelScrollX = 0;
                this.isScrollingX = false;
            }
            if (!this.veryLongTrack) {
                this.pixelScrollXTune = 0;
                this.isScrollingXTune = false;
            }
            boolean bl = this.tooTallModule = this.tracks.size() > this.tracksInView;
            if (!this.tooTallModule) {
                this.pixelScrollY = 0;
                this.isScrollingY = false;
            }
            this.generateScrollX();
            this.generateScrollY();
            if (this.createTrack.down) {
                this.createTrack.down = false;
                this.sendPacket(0, (byte)0);
            }
            if (this.removeTrack.down) {
                this.removeTrack.down = false;
                this.sendPacket(0, (byte)1);
            }
            if (this.speedButton.down) {
                this.speedButton.down = false;
                this.sendPacket(0, (byte)2);
            }
            for (i = 0; i < this.instrumentbuttons.size(); ++i) {
                if (!this.instrumentbuttons.get((int)i).down || i == this.currentInstrument) continue;
                this.currentInstrument = i;
                break;
            }
            for (i = 0; i < this.instrumentbuttons.size(); ++i) {
                if (!this.instrumentbuttons.get((int)i).down || i == this.currentInstrument) continue;
                this.instrumentbuttons.get((int)i).down = false;
            }
            if (this.currentInstrument != -1 && !this.instrumentbuttons.get((int)this.currentInstrument).down) {
                this.currentInstrument = -1;
            }
        }
        if (this.isPlaying()) {
            if (this.currentTick <= 0) {
                boolean found = false;
                for (Track track : this.tracks) {
                    float volume;
                    if (track.notes.size() <= this.playProgress) continue;
                    Note note = track.notes.get(this.playProgress);
                    switch (track.volume) {
                        case 0: {
                            volume = 0.0f;
                            break;
                        }
                        case 1: {
                            volume = 0.33f;
                            break;
                        }
                        case 2: {
                            volume = 0.67f;
                            break;
                        }
                        default: {
                            volume = 1.0f;
                        }
                    }
                    note.play(volume);
                    found = true;
                }
                if (!found) {
                    if (!this.getCart().field_70170_p.field_72995_K) {
                        this.setPlaying(false);
                    }
                    this.playProgress = 0;
                } else {
                    ++this.playProgress;
                }
                this.currentTick = this.getTickDelay() - 1;
            } else {
                --this.currentTick;
            }
        }
    }

    @Override
    public int guiWidth() {
        return 310;
    }

    @Override
    public int guiHeight() {
        return 150;
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        int[] marker;
        ResourceHelper.bindResource("/gui/note.png");
        for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + this.tracksInView); ++i) {
            Track track = this.tracks.get(i);
            for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + this.notesInView); ++j) {
                Note note = track.notes.get(j);
                note.draw(gui, x, y, i - this.getScrollY(), j - this.getScrollX());
            }
        }
        for (Button button : this.buttons) {
            button.draw(gui, x, y);
        }
        if (this.tooLongTrack) {
            this.drawImage(gui, this.scrollXrect, 48, 0);
            marker = this.getMarkerX();
            this.drawImage(gui, marker, 148, 1);
            if (this.veryLongTrack) {
                marker = this.getMarkerXTune();
                this.drawImage(gui, marker, 153, 1);
            }
        } else {
            this.drawImage(gui, this.scrollXrect, 48, 16);
        }
        if (this.tooTallModule) {
            this.drawImage(gui, this.scrollYrect, 0, 48);
            marker = this.getMarkerY();
            this.drawImage(gui, marker, 1, 148);
        } else {
            this.drawImage(gui, this.scrollYrect, 16, 48);
        }
    }

    private int[] getMarkerX() {
        return this.generateMarkerX(this.pixelScrollX);
    }

    private int[] getMarkerXTune() {
        return this.generateMarkerX(this.pixelScrollXTune);
    }

    private int[] generateMarkerX(int x) {
        return new int[]{this.scrollXrect[0] + x, this.scrollXrect[1] + 1, 5, 14};
    }

    private void setMarkerX(int x) {
        this.pixelScrollX = this.generateNewMarkerX(x);
    }

    private void setMarkerXTune(int x) {
        this.pixelScrollXTune = this.generateNewMarkerX(x);
    }

    private int generateNewMarkerX(int x) {
        int temp = x - this.scrollXrect[0];
        if (temp < 0) {
            temp = 0;
        } else if (temp > this.scrollXrect[2] - 5) {
            temp = this.scrollXrect[2] - 5;
        }
        return temp;
    }

    private int getScrollX() {
        return this.generatedScrollX;
    }

    private void generateScrollX() {
        if (this.tooLongTrack) {
            int maxNotes = -1;
            for (int i = 0; i < this.tracks.size(); ++i) {
                maxNotes = Math.max(maxNotes, this.tracks.get((int)i).notes.size());
            }
            float widthOfBlockInScrollArea = (float)(this.scrollXrect[2] - 5) / (float)(maxNotes -= this.notesInView);
            this.generatedScrollX = Math.round((float)this.pixelScrollX / widthOfBlockInScrollArea);
            if (this.veryLongTrack) {
                this.generatedScrollX = (int)((float)this.generatedScrollX + (float)this.pixelScrollXTune / (float)(this.scrollXrect[2] - 5) * 50.0f);
            }
        } else {
            this.generatedScrollX = 0;
        }
    }

    private int[] getMarkerY() {
        return new int[]{this.scrollYrect[0] + 1, this.scrollYrect[1] + this.pixelScrollY, 14, 5};
    }

    private void setMarkerY(int y) {
        this.pixelScrollY = y - this.scrollYrect[1];
        if (this.pixelScrollY < 0) {
            this.pixelScrollY = 0;
        } else if (this.pixelScrollY > this.scrollYrect[3] - 5) {
            this.pixelScrollY = this.scrollYrect[3] - 5;
        }
    }

    private int getScrollY() {
        return this.generatedScrollY;
    }

    private void generateScrollY() {
        if (this.tooTallModule) {
            int maxTracks = this.tracks.size() - this.tracksInView;
            float heightOfBlockInScrollArea = (this.scrollYrect[3] - 5) / maxTracks;
            this.generatedScrollY = Math.round((float)this.pixelScrollY / heightOfBlockInScrollArea);
        } else {
            this.generatedScrollY = 0;
        }
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + this.tracksInView); ++i) {
            Track track = this.tracks.get(i);
            for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + this.notesInView); ++j) {
                Note note = track.notes.get(j);
                if (note.instrumentId == 0) continue;
                this.drawStringOnMouseOver(gui, note.toString(), x, y, note.getBounds(i - this.getScrollY(), j - this.getScrollX()));
            }
        }
        for (Button button : this.buttons) {
            if (button.text == null || button.text.length() <= 0) continue;
            button.overlay(gui, x, y);
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.isScrollingX) {
            this.setMarkerX(x);
            if (button != -1) {
                this.isScrollingX = false;
            }
        }
        if (this.isScrollingXTune) {
            this.setMarkerXTune(x);
            if (button != -1) {
                this.isScrollingXTune = false;
            }
        }
        if (this.isScrollingY) {
            this.setMarkerY(y + this.getCart().getRealScrollY());
            if (button != -1) {
                this.isScrollingY = false;
            }
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int buttonId) {
        if (buttonId == 0) {
            for (Button button : this.buttons) {
                button.clicked(x, y);
            }
            if (!this.isScrollingX && this.inRect(x, y, this.scrollXrect)) {
                this.isScrollingX = true;
            } else if (!this.isScrollingY && this.inRect(x, y, this.scrollYrect)) {
                this.isScrollingY = true;
            }
        } else if (buttonId == 1 && !this.isScrollingXTune && this.inRect(x, y, this.scrollXrect)) {
            this.isScrollingXTune = true;
        }
        if (buttonId == 0 || buttonId == 1) {
            for (int i = this.getScrollY(); i < Math.min(this.tracks.size(), this.getScrollY() + this.tracksInView); ++i) {
                Track track = this.tracks.get(i);
                for (int j = this.getScrollX(); j < Math.min(track.notes.size(), this.getScrollX() + this.notesInView); ++j) {
                    Note note = track.notes.get(j);
                    if (!this.inRect(x, y, note.getBounds(i - this.getScrollY(), j - this.getScrollX()))) continue;
                    int instrumentInfo = this.currentInstrument;
                    if (instrumentInfo == -1) {
                        instrumentInfo = buttonId == 0 ? 6 : 7;
                    }
                    if (this.currentInstrument == -1 && note.instrumentId == 0) continue;
                    byte info = (byte)i;
                    info = (byte)(info | instrumentInfo << 4);
                    this.sendPacket(2, new byte[]{info, (byte)j});
                }
            }
        }
    }

    @Override
    public int numberOfGuiData() {
        return 1 + (this.maximumNotesPerTrack + 1) * this.maximumTracksPerModule;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        short moduleHeader = (short)this.tracks.size();
        moduleHeader = (short)(moduleHeader | (short)(this.speedSetting << 4));
        this.updateGuiData(info, 0, moduleHeader);
        for (int i = 0; i < this.tracks.size(); ++i) {
            Track track = this.tracks.get(i);
            this.updateGuiData(info, 1 + (this.maximumNotesPerTrack + 1) * i, track.getInfo());
            for (int j = 0; j < track.notes.size(); ++j) {
                Note note = track.notes.get(j);
                this.updateGuiData(info, 1 + (this.maximumNotesPerTrack + 1) * i + 1 + j, note.getInfo());
            }
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            int trackCount = data & this.maximumTracksPerModule;
            this.speedSetting = (data & ~this.maximumTracksPerModule) >> 4;
            this.updateSpeedButton();
            while (this.tracks.size() < trackCount) {
                new Track();
            }
            while (this.tracks.size() > trackCount) {
                this.tracks.get(this.tracks.size() - 1).unload();
                this.tracks.remove(this.tracks.size() - 1);
            }
        } else {
            int trackId = --id / (this.maximumNotesPerTrack + 1);
            int noteId = id % (this.maximumNotesPerTrack + 1);
            Track track = this.tracks.get(trackId);
            if (noteId == 0) {
                track.setInfo(data);
            } else {
                Note note = track.notes.get(--noteId);
                note.setInfo(data);
            }
        }
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    private boolean isPlaying() {
        if (this.isPlaceholder()) {
            return false;
        }
        return this.getDw(0) != 0 || this.playProgress > 0;
    }

    private void setPlaying(boolean val) {
        this.updateDw(0, val ? 1 : 0);
    }

    @Override
    public int numberOfPackets() {
        return 3;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            if (data[0] == 0) {
                if (this.tracks.size() < this.maximumTracksPerModule) {
                    new Track();
                }
            } else if (data[0] == 1) {
                if (this.tracks.size() > 0) {
                    this.tracks.remove(this.tracks.size() - 1);
                }
            } else if (data[0] == 2) {
                ++this.speedSetting;
                if (this.speedSetting >= 7) {
                    this.speedSetting = 0;
                }
            }
        } else if (id == 1) {
            int trackID = data[0] & this.maximumTracksPerModule;
            int trackPacketID = (data[0] & ~this.maximumTracksPerModule) >> 4;
            if (trackID < this.tracks.size()) {
                Track track = this.tracks.get(trackID);
                if (trackPacketID == 0) {
                    if (track.notes.size() < this.maximumNotesPerTrack) {
                        new Note(track);
                    }
                } else if (trackPacketID == 1) {
                    if (track.notes.size() > 0) {
                        track.notes.remove(track.notes.size() - 1);
                    }
                } else if (trackPacketID == 2) {
                    track.volume = (track.volume + 1) % 4;
                }
            }
        } else if (id == 2) {
            byte info = data[0];
            byte noteID = data[1];
            byte trackID = (byte)(info & this.maximumTracksPerModule);
            byte instrumentInfo = (byte)((byte)(info & ~((byte)this.maximumTracksPerModule)) >> 4);
            if (trackID < this.tracks.size()) {
                Track track = this.tracks.get(trackID);
                if (noteID < track.notes.size()) {
                    Note note = track.notes.get(noteID);
                    if (instrumentInfo < 6) {
                        note.instrumentId = instrumentInfo;
                    } else if (instrumentInfo == 6) {
                        ++note.pitch;
                        if (note.pitch > 24) {
                            note.pitch = 0;
                        }
                    } else {
                        --note.pitch;
                        if (note.pitch < 0) {
                            note.pitch = 24;
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        short headerInfo = (short)this.tracks.size();
        headerInfo = (short)(headerInfo | (short)(this.speedSetting << 4));
        tagCompound.func_74777_a(this.generateNBTName("Header", id), headerInfo);
        for (int i = 0; i < this.tracks.size(); ++i) {
            Track track = this.tracks.get(i);
            tagCompound.func_74777_a(this.generateNBTName("Track" + i, id), track.getInfo());
            for (int j = 0; j < track.notes.size(); ++j) {
                Note note = track.notes.get(j);
                tagCompound.func_74777_a(this.generateNBTName("Note" + i + ":" + j, id), note.getInfo());
            }
        }
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        short headerInfo = tagCompound.func_74765_d(this.generateNBTName("Header", id));
        this.receiveGuiData(0, headerInfo);
        for (int i = 0; i < this.tracks.size(); ++i) {
            short trackInfo = tagCompound.func_74765_d(this.generateNBTName("Track" + i, id));
            this.receiveGuiData(1 + (this.maximumNotesPerTrack + 1) * i, trackInfo);
            Track track = this.tracks.get(i);
            for (int j = 0; j < track.notes.size(); ++j) {
                short noteInfo = tagCompound.func_74765_d(this.generateNBTName("Note" + i + ":" + j, id));
                this.receiveGuiData(1 + (this.maximumNotesPerTrack + 1) * i + 1 + j, noteInfo);
            }
        }
    }

    private class Button {
        public int[] rect;
        public boolean down = false;
        public String text;
        public int color;
        public int imageID;

        public Button(int x, int y) {
            this.rect = new int[]{x, y, 16, 16};
            this.color = 0;
            this.imageID = -1;
            ModuleNote.this.buttons.add(this);
        }

        public int[] getRect() {
            return this.rect;
        }

        public void overlay(GuiMinecart gui, int x, int y) {
            ModuleNote.this.drawStringOnMouseOver(gui, this.text, x, y, this.getRect());
        }

        public void clicked(int x, int y) {
            if (ModuleNote.this.inRect(x, y, this.getRect())) {
                this.down = !this.down;
            }
        }

        public void draw(GuiMinecart gui, int x, int y) {
            if (!ModuleNote.this.inRect(x, y, this.getRect())) {
                GL11.glColor4f((float)((float)(this.color >> 16) / 255.0f), (float)((float)(this.color >> 8 & 0xFF) / 255.0f), (float)((float)(this.color & 0xFF) / 255.0f), (float)1.0f);
            }
            ModuleNote.this.drawImage(gui, this.getRect(), 32, 0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int srcX = 0;
            int srcY = 16;
            if (this.down) {
                srcX += 16;
            }
            ModuleNote.this.drawImage(gui, this.getRect(), srcX, srcY);
            if (this.imageID != -1) {
                ModuleNote.this.drawImage(gui, this.getRect(), this.imageID * 16, 32);
            }
        }
    }

    private class Track {
        public ArrayList<Note> notes = new ArrayList();
        public Button addButton;
        public Button removeButton;
        public Button volumeButton;
        public int volume = 3;
        public int lastNoteCount;

        public Track() {
            if (ModuleNote.this.getCart().field_70170_p.field_72995_K) {
                int ID = ModuleNote.this.tracks.size() + 1;
                this.addButton = new TrackButton(ModuleNote.this.notemapX - 60, ID - 1);
                this.addButton.text = Localization.MODULES.ATTACHMENTS.ADD_NOTE.translate(String.valueOf(ID));
                this.addButton.imageID = 2;
                this.removeButton = new TrackButton(ModuleNote.this.notemapX - 40, ID - 1);
                this.removeButton.text = Localization.MODULES.ATTACHMENTS.REMOVE_NOTE.translate(String.valueOf(ID));
                this.removeButton.imageID = 3;
                this.volumeButton = new TrackButton(ModuleNote.this.notemapX - 20, ID - 1);
                this.volumeButton.text = this.getVolumeText();
                this.volumeButton.imageID = 4;
            }
            ModuleNote.this.tracks.add(this);
        }

        private String getVolumeText() {
            return Localization.MODULES.ATTACHMENTS.VOLUME.translate(String.valueOf(this.volume));
        }

        public void unload() {
            ModuleNote.this.buttons.remove(this.addButton);
            ModuleNote.this.buttons.remove(this.removeButton);
            ModuleNote.this.buttons.remove(this.volumeButton);
        }

        public short getInfo() {
            short info = 0;
            info = (short)(info | this.notes.size());
            info = (short)(info | this.volume << 12);
            return info;
        }

        public void setInfo(short val) {
            int numberofNotes = val & ModuleNote.this.maximumNotesPerTrack;
            while (this.notes.size() < numberofNotes) {
                new Note(this);
            }
            while (this.notes.size() > numberofNotes) {
                this.notes.remove(this.notes.size() - 1);
            }
            this.volume = (val & ~ModuleNote.this.maximumNotesPerTrack) >> 12;
            if (ModuleNote.this.getCart().field_70170_p.field_72995_K) {
                this.volumeButton.imageID = 4 + this.volume;
                this.volumeButton.text = this.getVolumeText();
            }
        }
    }

    private class Note {
        public int instrumentId;
        public int pitch;

        public Note(Track track) {
            track.notes.add(this);
        }

        public void drawText(GuiMinecart gui, int trackID, int noteID) {
            if (this.instrumentId == 0) {
                return;
            }
            int[] rect = this.getBounds(trackID, noteID);
            String str = String.valueOf(this.pitch);
            if (str.length() < 2) {
                str = "0" + str;
            }
            ModuleNote.this.drawString(gui, str, rect[0] + 3, rect[1] + 6, ModuleNote.this.instrumentColors[this.instrumentId]);
        }

        public void draw(GuiMinecart gui, int x, int y, int trackID, int noteID) {
            int srcX = 0;
            if (this.instrumentId == 0) {
                srcX += 16;
            }
            int[] rect = this.getBounds(trackID, noteID);
            if (this.instrumentId != 0 && ModuleNote.this.playProgress == noteID + ModuleNote.this.getScrollX() && ModuleNote.this.isPlaying()) {
                GL11.glColor4f((float)0.3f, (float)0.3f, (float)0.3f, (float)1.0f);
            }
            ModuleNote.this.drawImage(gui, rect, srcX, 0);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (ModuleNote.this.inRect(x, y, rect)) {
                ModuleNote.this.drawImage(gui, rect, 32, 0);
            }
        }

        public int[] getBounds(int trackID, int noteID) {
            return new int[]{ModuleNote.this.notemapX + noteID * 16, ModuleNote.this.notemapY + trackID * ModuleNote.this.trackHeight, 16, 16};
        }

        public short getInfo() {
            short info = 0;
            info = (short)(info | this.instrumentId);
            info = (short)(info | this.pitch << 3);
            return info;
        }

        public void setInfo(short val) {
            this.instrumentId = val & 7;
            this.pitch = (val & 0xF8) >> 3;
        }

        public void play(float volume) {
            if (this.instrumentId == 0) {
                return;
            }
            if (!ModuleNote.this.getCart().field_70170_p.field_72995_K) {
                if (volume > 0.0f) {
                    float calculatedPitch = (float)Math.pow(2.0, (double)(this.pitch - 12) / 12.0);
                    String instrumentString = "harp";
                    if (this.instrumentId == 2) {
                        instrumentString = "bd";
                    } else if (this.instrumentId == 3) {
                        instrumentString = "snare";
                    } else if (this.instrumentId == 4) {
                        instrumentString = "hat";
                    } else if (this.instrumentId == 5) {
                        instrumentString = "bassattack";
                    }
                    ModuleNote.this.getCart().field_70170_p.func_72908_a((double)ModuleNote.this.getCart().x() + 0.5, (double)ModuleNote.this.getCart().y() + 0.5, (double)ModuleNote.this.getCart().z() + 0.5, "note." + instrumentString, volume, calculatedPitch);
                }
            } else {
                double oX = 0.0;
                double oZ = 0.0;
                if (ModuleNote.this.getCart().field_70159_w != 0.0) {
                    oX = ModuleNote.this.getCart().field_70159_w > 0.0 ? -1 : 1;
                }
                if (ModuleNote.this.getCart().field_70179_y != 0.0) {
                    oZ = ModuleNote.this.getCart().field_70179_y > 0.0 ? -1 : 1;
                }
                ModuleNote.this.getCart().field_70170_p.func_72869_a("note", (double)ModuleNote.this.getCart().x() + oZ * 1.0 + 0.5, (double)ModuleNote.this.getCart().y() + 1.2, (double)ModuleNote.this.getCart().z() + oX * 1.0 + 0.5, (double)this.pitch / 24.0, 0.0, 0.0);
                ModuleNote.this.getCart().field_70170_p.func_72869_a("note", (double)ModuleNote.this.getCart().x() + oZ * -1.0 + 0.5, (double)ModuleNote.this.getCart().y() + 1.2, (double)ModuleNote.this.getCart().z() + oX * -1.0 + 0.5, (double)this.pitch / 24.0, 0.0, 0.0);
            }
        }

        public String toString() {
            if (this.instrumentId == 0) {
                return "Unknown instrument";
            }
            return ModuleNote.this.instrumentNames[this.instrumentId - 1].translate(new String[0]) + " " + ModuleNote.this.pitchNames[this.pitch];
        }
    }

    private class TrackButton
    extends Button {
        private int trackID;
        private int x;

        public TrackButton(int x, int trackID) {
            super(0, 0);
            this.trackID = trackID;
            this.x = x;
        }

        @Override
        public int[] getRect() {
            return new int[]{this.x, ModuleNote.this.notemapY + (this.trackID - ModuleNote.this.getScrollY()) * ModuleNote.this.trackHeight, 16, 16};
        }

        private boolean isValid() {
            return ModuleNote.this.getScrollY() <= this.trackID && this.trackID < ModuleNote.this.getScrollY() + ModuleNote.this.tracksInView;
        }

        @Override
        public void draw(GuiMinecart gui, int x, int y) {
            if (this.isValid()) {
                super.draw(gui, x, y);
            }
        }

        @Override
        public void overlay(GuiMinecart gui, int x, int y) {
            if (this.isValid()) {
                super.overlay(gui, x, y);
            }
        }

        @Override
        public void clicked(int x, int y) {
            if (this.isValid()) {
                super.clicked(x, y);
            }
        }
    }
}

