/*
 * Decompiled with CFR 0.152.
 */
package me.eigenraven.personalspace.net;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import java.util.ArrayList;
import java.util.Iterator;
import me.eigenraven.personalspace.CommonProxy;
import me.eigenraven.personalspace.Config;
import me.eigenraven.personalspace.PersonalSpaceMod;
import me.eigenraven.personalspace.block.PortalTileEntity;
import me.eigenraven.personalspace.world.DimensionConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;

public enum Packets {
    INSTANCE;


    public void handleClientPacket(PacketCustom packetCustom, Minecraft mc, INetHandlerPlayClient handler) {
        int id = packetCustom.getType();
        if (id >= PacketIds.VALUES.length || id < 0) {
            return;
        }
        switch (PacketIds.VALUES[id]) {
            case UPDATE_WORLDLIST: {
                Packets.handleWorldList(packetCustom);
                break;
            }
        }
    }

    public void handleServerPacket(PacketCustom pkt, EntityPlayerMP sender, INetHandlerPlayServer handler) {
        int id = pkt.getType();
        if (id >= PacketIds.VALUES.length || id < 0) {
            return;
        }
        switch (PacketIds.VALUES[id]) {
            case UPDATE_WORLDLIST: {
                break;
            }
            case CHANGE_WORLD_SETTINGS: {
                TileEntity te;
                int dim = pkt.readVarInt();
                int x = pkt.readVarInt();
                int y = pkt.readVarInt();
                int z = pkt.readVarInt();
                DimensionConfig desired = DimensionConfig.fromPacket((MCDataInput)pkt);
                if (sender == null || sender.field_70170_p == null || sender.field_70170_p.field_73011_w.field_76574_g != dim || !((te = sender.field_70170_p.func_147438_o(x, y, z)) instanceof PortalTileEntity)) break;
                ((PortalTileEntity)te).updateSettings(sender, desired);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PacketCustom sendWorldList() {
        PacketCustom pkt = new PacketCustom((Object)"personalspace", PacketIds.UPDATE_WORLDLIST.ordinal());
        pkt.writeVarInt(Config.allowedBiomes.size());
        for (String biome : Config.allowedBiomes) {
            pkt.writeString(biome);
        }
        pkt.writeVarInt(Config.allowedBlocks.size());
        for (String block : Config.allowedBlocks) {
            pkt.writeString(block);
        }
        Iterator<String> iterator = CommonProxy.getDimensionConfigObjects(false);
        synchronized (iterator) {
            pkt.writeVarInt(CommonProxy.getDimensionConfigObjects(false).size());
            CommonProxy.getDimensionConfigObjects(false).forEachEntry((dimId, dimCfg) -> {
                pkt.writeVarInt(dimId);
                dimCfg.writeToPacket((MCDataOutput)pkt);
                return true;
            });
        }
        return pkt;
    }

    public PacketCustom sendChangeWorldSettings(PortalTileEntity tile, DimensionConfig config) {
        PacketCustom pkt = new PacketCustom((Object)"personalspace", PacketIds.CHANGE_WORLD_SETTINGS.ordinal());
        pkt.writeVarInt(tile.func_145831_w().field_73011_w.field_76574_g);
        pkt.writeVarInt(tile.field_145851_c);
        pkt.writeVarInt(tile.field_145848_d);
        pkt.writeVarInt(tile.field_145849_e);
        config.writeToPacket((MCDataOutput)pkt);
        return pkt;
    }

    private static void handleWorldList(PacketCustom pkt) {
        int allowedBiomes = pkt.readVarInt();
        ArrayList<String> tmpList = new ArrayList<String>(allowedBiomes);
        for (int i = 0; i < allowedBiomes; ++i) {
            tmpList.add(pkt.readString());
        }
        PersonalSpaceMod.clientAllowedBiomes = tmpList;
        int allowedBlocks = pkt.readVarInt();
        tmpList = new ArrayList(allowedBlocks);
        for (int i = 0; i < allowedBlocks; ++i) {
            tmpList.add(pkt.readString());
        }
        PersonalSpaceMod.clientAllowedBlocks = tmpList;
        int dimConfigs = pkt.readVarInt();
        for (int i = 0; i < dimConfigs; ++i) {
            int dimId = pkt.readVarInt();
            DimensionConfig cfg = DimensionConfig.fromPacket((MCDataInput)pkt);
            cfg.registerWithDimensionManager(dimId, true);
        }
    }

    public static enum PacketIds {
        DUMMY,
        UPDATE_WORLDLIST,
        CHANGE_WORLD_SETTINGS;

        static final PacketIds[] VALUES;

        static {
            VALUES = PacketIds.values();
        }
    }
}

