/*
 * Decompiled with CFR 0.152.
 */
package rwg.terrain;

import rwg.terrain.TerrainBase;
import rwg.util.CellNoise;
import rwg.util.NoiseGenerator;

public class TerrainDuneValley
extends TerrainBase {
    private float valley;

    public TerrainDuneValley(float valleySize) {
        this.valley = valleySize;
    }

    @Override
    public float generateNoise(NoiseGenerator perlin, CellNoise cell, int x, int y, float ocean, float border, float river) {
        float h = (perlin.noise2((float)x / this.valley, (float)y / this.valley) + 0.25f) * 65.0f * river;
        h = h < 1.0f ? 1.0f : h;
        float r = cell.noise((double)x / 50.0, (double)y / 50.0, 1.0) * h * 2.0f;
        h += r;
        h += perlin.noise2((float)x / 40.0f, (float)y / 40.0f) * 8.0f;
        return 70.0f + (h += perlin.noise2((float)x / 14.0f, (float)y / 14.0f) * 2.0f);
    }
}

