/*
 * Decompiled with CFR 0.152.
 */
package ru.timeconqueror.lootgames.utils.future;

import com.google.common.collect.AbstractIterator;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.concurrent.Immutable;
import net.minecraft.util.EnumFacing;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.timeconqueror.lootgames.utils.future.MathHelper;
import ru.timeconqueror.lootgames.utils.future.Vector3i;

@Immutable
public class BlockPos
extends Vector3i {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final BlockPos ZERO = new BlockPos(0, 0, 0);
    private static final int PACKED_X_LENGTH;
    private static final int PACKED_Z_LENGTH;
    private static final int PACKED_Y_LENGTH;
    private static final long PACKED_X_MASK;
    private static final long PACKED_Y_MASK;
    private static final long PACKED_Z_MASK;
    private static final int Z_OFFSET;
    private static final int X_OFFSET;

    public BlockPos(int x, int y, int z) {
        super(x, y, z);
    }

    public BlockPos(double x, double y, double z) {
        super(x, y, z);
    }

    public BlockPos(Vector3i source) {
        this(source.getX(), source.getY(), source.getZ());
    }

    public static long offset(long pos, EnumFacing directionIn) {
        return BlockPos.offset(pos, directionIn.func_82601_c(), directionIn.func_96559_d(), directionIn.func_82599_e());
    }

    public static long offset(long pos, int dx, int dy, int dz) {
        return BlockPos.asLong(BlockPos.getX(pos) + dx, BlockPos.getY(pos) + dy, BlockPos.getZ(pos) + dz);
    }

    public static int getX(long packedPos) {
        return (int)(packedPos << 64 - X_OFFSET - PACKED_X_LENGTH >> 64 - PACKED_X_LENGTH);
    }

    public static int getY(long packedPos) {
        return (int)(packedPos << 64 - PACKED_Y_LENGTH >> 64 - PACKED_Y_LENGTH);
    }

    public static int getZ(long packedPos) {
        return (int)(packedPos << 64 - Z_OFFSET - PACKED_Z_LENGTH >> 64 - PACKED_Z_LENGTH);
    }

    public static BlockPos of(long packedPos) {
        return new BlockPos(BlockPos.getX(packedPos), BlockPos.getY(packedPos), BlockPos.getZ(packedPos));
    }

    public static BlockPos of(int x, int y, int z) {
        return new BlockPos(x, y, z);
    }

    public long asLong() {
        return BlockPos.asLong(this.getX(), this.getY(), this.getZ());
    }

    public static long asLong(int x, int y, int z) {
        long i = 0L;
        i |= ((long)x & PACKED_X_MASK) << X_OFFSET;
        return (i |= ((long)y & PACKED_Y_MASK) << 0) | ((long)z & PACKED_Z_MASK) << Z_OFFSET;
    }

    public static long getFlatIndex(long packedPos) {
        return packedPos & 0xFFFFFFFFFFFFFFF0L;
    }

    public BlockPos offset(double x, double y, double z) {
        return x == 0.0 && y == 0.0 && z == 0.0 ? this : new BlockPos((double)this.getX() + x, (double)this.getY() + y, (double)this.getZ() + z);
    }

    public BlockPos offset(int x, int y, int z) {
        return x == 0 && y == 0 && z == 0 ? this : new BlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public BlockPos offset(Vector3i vec) {
        return this.offset(vec.getX(), vec.getY(), vec.getZ());
    }

    public BlockPos subtract(Vector3i vec) {
        return this.offset(-vec.getX(), -vec.getY(), -vec.getZ());
    }

    @Override
    public BlockPos above() {
        return this.relative(EnumFacing.UP);
    }

    @Override
    public BlockPos above(int n) {
        return this.relative(EnumFacing.UP, n);
    }

    @Override
    public BlockPos below() {
        return this.relative(EnumFacing.DOWN);
    }

    @Override
    public BlockPos below(int n) {
        return this.relative(EnumFacing.DOWN, n);
    }

    public BlockPos north() {
        return this.relative(EnumFacing.NORTH);
    }

    public BlockPos north(int n) {
        return this.relative(EnumFacing.NORTH, n);
    }

    public BlockPos south() {
        return this.relative(EnumFacing.SOUTH);
    }

    public BlockPos south(int n) {
        return this.relative(EnumFacing.SOUTH, n);
    }

    public BlockPos west() {
        return this.relative(EnumFacing.WEST);
    }

    public BlockPos west(int n) {
        return this.relative(EnumFacing.WEST, n);
    }

    public BlockPos east() {
        return this.relative(EnumFacing.EAST);
    }

    public BlockPos east(int n) {
        return this.relative(EnumFacing.EAST, n);
    }

    public BlockPos relative(EnumFacing facing) {
        return new BlockPos(this.getX() + facing.func_82601_c(), this.getY() + facing.func_96559_d(), this.getZ() + facing.func_82599_e());
    }

    @Override
    public BlockPos relative(EnumFacing facing, int n) {
        return n == 0 ? this : new BlockPos(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
    }

    @Override
    public BlockPos cross(Vector3i vec) {
        return new BlockPos(this.getY() * vec.getZ() - this.getZ() * vec.getY(), this.getZ() * vec.getX() - this.getX() * vec.getZ(), this.getX() * vec.getY() - this.getY() * vec.getX());
    }

    public BlockPos immutable() {
        return this;
    }

    public Mutable mutable() {
        return new Mutable(this.getX(), this.getY(), this.getZ());
    }

    public static Iterable<BlockPos> randomBetweenClosed(final Random rand, final int amount, final int minX, final int minY, final int minZ, int maxX, int maxY, int maxZ) {
        final int i = maxX - minX + 1;
        final int j = maxY - minY + 1;
        final int k = maxZ - minZ + 1;
        return () -> new AbstractIterator<BlockPos>(){
            final Mutable nextPos = new Mutable();
            int counter = amount;

            protected BlockPos computeNext() {
                if (this.counter <= 0) {
                    return (BlockPos)this.endOfData();
                }
                Mutable blockpos = this.nextPos.set(minX + rand.nextInt(i), minY + rand.nextInt(j), minZ + rand.nextInt(k));
                --this.counter;
                return blockpos;
            }
        };
    }

    public static Iterable<BlockPos> withinManhattan(BlockPos pos, final int xWidth, final int yHeight, final int zWidth) {
        final int i = xWidth + yHeight + zWidth;
        final int j = pos.getX();
        final int k = pos.getY();
        final int l = pos.getZ();
        return () -> new AbstractIterator<BlockPos>(){
            private final Mutable cursor = new Mutable();
            private int currentDepth;
            private int maxX;
            private int maxY;
            private int x;
            private int y;
            private boolean zMirror;

            protected BlockPos computeNext() {
                if (this.zMirror) {
                    this.zMirror = false;
                    this.cursor.setZ(l - (this.cursor.getZ() - l));
                    return this.cursor;
                }
                Mutable blockpos = null;
                while (blockpos == null) {
                    if (this.y > this.maxY) {
                        ++this.x;
                        if (this.x > this.maxX) {
                            ++this.currentDepth;
                            if (this.currentDepth > i) {
                                return (BlockPos)this.endOfData();
                            }
                            this.maxX = Math.min(xWidth, this.currentDepth);
                            this.x = -this.maxX;
                        }
                        this.maxY = Math.min(yHeight, this.currentDepth - Math.abs(this.x));
                        this.y = -this.maxY;
                    }
                    int i1 = this.x;
                    int j1 = this.y;
                    int k1 = this.currentDepth - Math.abs(i1) - Math.abs(j1);
                    if (k1 <= zWidth) {
                        this.zMirror = k1 != 0;
                        blockpos = this.cursor.set(j + i1, k + j1, l + k1);
                    }
                    ++this.y;
                }
                return blockpos;
            }
        };
    }

    public static Optional<BlockPos> findClosestMatch(BlockPos pos, int width, int height, Predicate<BlockPos> posFilter) {
        return BlockPos.withinManhattanStream(pos, width, height, width).filter(posFilter).findFirst();
    }

    public static Stream<BlockPos> withinManhattanStream(BlockPos pos, int xWidth, int yHeight, int zWidth) {
        return StreamSupport.stream(BlockPos.withinManhattan(pos, xWidth, yHeight, zWidth).spliterator(), false);
    }

    public static Iterable<BlockPos> betweenClosed(BlockPos firstPos, BlockPos secondPos) {
        return BlockPos.betweenClosed(Math.min(firstPos.getX(), secondPos.getX()), Math.min(firstPos.getY(), secondPos.getY()), Math.min(firstPos.getZ(), secondPos.getZ()), Math.max(firstPos.getX(), secondPos.getX()), Math.max(firstPos.getY(), secondPos.getY()), Math.max(firstPos.getZ(), secondPos.getZ()));
    }

    public static Stream<BlockPos> betweenClosedStream(BlockPos firstPos, BlockPos secondPos) {
        return StreamSupport.stream(BlockPos.betweenClosed(firstPos, secondPos).spliterator(), false);
    }

    public static Stream<BlockPos> betweenClosedStream(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        return StreamSupport.stream(BlockPos.betweenClosed(minX, minY, minZ, maxX, maxY, maxZ).spliterator(), false);
    }

    public static Iterable<BlockPos> betweenClosed(final int x1, final int y1, final int z1, int x2, int y2, int z2) {
        final int i = x2 - x1 + 1;
        final int j = y2 - y1 + 1;
        int k = z2 - z1 + 1;
        final int l = i * j * k;
        return () -> new AbstractIterator<BlockPos>(){
            private final Mutable cursor = new Mutable();
            private int index;

            protected BlockPos computeNext() {
                if (this.index == l) {
                    return (BlockPos)this.endOfData();
                }
                int i1 = this.index % i;
                int j1 = this.index / i;
                int k1 = j1 % j;
                int l1 = j1 / j;
                ++this.index;
                return this.cursor.set(x1 + i1, y1 + k1, z1 + l1);
            }
        };
    }

    static {
        PACKED_Z_LENGTH = PACKED_X_LENGTH = 1 + MathHelper.calculateLogBaseTwo(MathHelper.roundUpToPowerOfTwo(30000000));
        PACKED_Y_LENGTH = 64 - PACKED_X_LENGTH - PACKED_Z_LENGTH;
        PACKED_X_MASK = (1L << PACKED_X_LENGTH) - 1L;
        PACKED_Y_MASK = (1L << PACKED_Y_LENGTH) - 1L;
        PACKED_Z_MASK = (1L << PACKED_Z_LENGTH) - 1L;
        Z_OFFSET = PACKED_Y_LENGTH;
        X_OFFSET = PACKED_Y_LENGTH + PACKED_Z_LENGTH;
    }

    public static class Mutable
    extends BlockPos {
        public Mutable() {
            this(0, 0, 0);
        }

        public Mutable(int x_, int y_, int z_) {
            super(x_, y_, z_);
        }

        public Mutable(double x, double y, double z) {
            this(MathHelper.floor_double(x), MathHelper.floor_double(y), MathHelper.floor_double(z));
        }

        @Override
        public BlockPos offset(double x, double y, double z) {
            return super.offset(x, y, z).immutable();
        }

        @Override
        public BlockPos offset(int x, int y, int z) {
            return super.offset(x, y, z).immutable();
        }

        @Override
        public BlockPos relative(EnumFacing facing, int n) {
            return super.relative(facing, n).immutable();
        }

        public Mutable set(int xIn, int yIn, int zIn) {
            this.setX(xIn);
            this.setY(yIn);
            this.setZ(zIn);
            return this;
        }

        public Mutable set(double xIn, double yIn, double zIn) {
            return this.set(MathHelper.floor_double(xIn), MathHelper.floor_double(yIn), MathHelper.floor_double(zIn));
        }

        public Mutable set(Vector3i vec) {
            return this.set(vec.getX(), vec.getY(), vec.getZ());
        }

        public Mutable set(long packedPos) {
            return this.set(Mutable.getX(packedPos), Mutable.getY(packedPos), Mutable.getZ(packedPos));
        }

        public Mutable setWithOffset(Vector3i pos, EnumFacing directionIn) {
            return this.set(pos.getX() + directionIn.func_82601_c(), pos.getY() + directionIn.func_96559_d(), pos.getZ() + directionIn.func_82599_e());
        }

        public Mutable setWithOffset(Vector3i pos, int offsetX, int offsetY, int offsetZ) {
            return this.set(pos.getX() + offsetX, pos.getY() + offsetY, pos.getZ() + offsetZ);
        }

        public Mutable move(EnumFacing facing) {
            return this.move(facing, 1);
        }

        public Mutable move(EnumFacing facing, int n) {
            return this.set(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
        }

        public Mutable move(int xIn, int yIn, int zIn) {
            return this.set(this.getX() + xIn, this.getY() + yIn, this.getZ() + zIn);
        }

        public Mutable move(Vector3i vector3i_) {
            return this.set(this.getX() + vector3i_.getX(), this.getY() + vector3i_.getY(), this.getZ() + vector3i_.getZ());
        }

        @Override
        public void setX(int xIn) {
            super.setX(xIn);
        }

        @Override
        public void setY(int yIn) {
            super.setY(yIn);
        }

        @Override
        public void setZ(int zIn) {
            super.setZ(zIn);
        }

        @Override
        public BlockPos immutable() {
            return new BlockPos(this);
        }
    }
}

