/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.gui.GuiScrollSlot;
import codechicken.lib.gui.GuiDraw;
import codechicken.lib.vec.Rectangle4i;
import codechicken.nei.Button;
import codechicken.nei.ItemList;
import codechicken.nei.ItemStackSet;
import codechicken.nei.LayoutManager;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.RestartableTask;
import codechicken.nei.SearchField;
import codechicken.nei.SearchTokenParser;
import codechicken.nei.api.API;
import codechicken.nei.api.ItemFilter;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.guihook.IContainerTooltipHandler;
import codechicken.nei.util.NEIMouseUtils;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import org.lwjgl.opengl.GL11;

public class SubsetWidget
extends Button
implements ItemFilter.ItemFilterProvider,
IContainerTooltipHandler {
    protected static final int SLOT_HEIGHT = 18;
    protected static final int MARGIN = 2;
    protected static final char PREFIX = '%';
    protected static ReentrantReadWriteLock hiddenItemLock = new ReentrantReadWriteLock();
    protected static Lock hiddenWriteLock = hiddenItemLock.writeLock();
    protected static Lock hiddenReadLock = hiddenItemLock.readLock();
    private static final ItemStackSet hiddenItems = new ItemStackSet();
    private static final Map<String, SubsetTag> tags = new HashMap<String, SubsetTag>();
    private static final SubsetTag root = new SubsetTag("");
    protected static boolean enableSearchBySubsets = false;
    protected static ItemStack hoverStack;
    protected static SubsetTag hoverTag;
    private long lastclicktime;
    private static final UpdateStateTask updateState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addTag(SubsetTag tag) {
        updateState.stop();
        Map<String, SubsetTag> map = tags;
        synchronized (map) {
            tags.put(tag.path, tag);
            String parentname = tag.parent();
            while (parentname != null && !tags.containsKey(parentname.replaceAll("\\s+", "").toLowerCase())) {
                SubsetTag parent = new SubsetTag(parentname);
                tags.put(parent.path, parent);
                parentname = parent.parent();
            }
            SubsetWidget.updateHiddenItems();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHidden(ItemStack item) {
        try {
            if (!hiddenReadLock.tryLock(5L, TimeUnit.SECONDS)) {
                NEIClientConfig.logger.error("Unable to obtain read lock in 'isHidden'");
                return false;
            }
            try {
                boolean bl = hiddenItems.contains(item);
                return bl;
            }
            finally {
                hiddenReadLock.unlock();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return false;
    }

    private static List<ItemStack> getItems(SubsetTag tag, List<ItemStack> items) {
        items.addAll(tag.items);
        for (SubsetTag child : tag.children) {
            SubsetWidget.getItems(child, items);
        }
        return items;
    }

    public static void showOnly(SubsetTag tag) {
        try {
            if (hiddenWriteLock.tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    hiddenItems.clear();
                    hiddenItems.addAll(SubsetWidget.getItems(root, new ArrayList<ItemStack>()));
                    hiddenItems.removeAll(SubsetWidget.getItems(tag, new ArrayList<ItemStack>()));
                }
                finally {
                    hiddenWriteLock.unlock();
                }
            } else {
                NEIClientConfig.logger.error("Unable to obtain write lock in 'showOnly'");
            }
            SubsetWidget.calculateVisibility();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void setHidden(SubsetTag tag, boolean hidden) {
        try {
            if (hiddenWriteLock.tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    List<ItemStack> tagItems = SubsetWidget.getItems(tag, new ArrayList<ItemStack>());
                    if (hidden) {
                        hiddenItems.addAll(tagItems);
                    }
                    hiddenItems.removeAll(tagItems);
                }
                finally {
                    hiddenWriteLock.unlock();
                }
            } else {
                NEIClientConfig.logger.error("Unable to obtain write lock in 'setHidden'");
            }
            SubsetWidget.calculateVisibility();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void setHidden(ItemStack item, boolean hidden) {
        try {
            if (hiddenWriteLock.tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    if (hidden) {
                        hiddenItems.add(item);
                    }
                    hiddenItems.remove(item);
                }
                finally {
                    hiddenWriteLock.unlock();
                }
            } else {
                NEIClientConfig.logger.error("Unable to obtain write lock in 'setHidden'");
            }
            SubsetWidget.calculateVisibility();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void unhideAll() {
        try {
            if (hiddenWriteLock.tryLock(5L, TimeUnit.SECONDS)) {
                try {
                    hiddenItems.clear();
                }
                finally {
                    hiddenWriteLock.unlock();
                }
            } else {
                NEIClientConfig.logger.error("Unable to obtain write lock in 'unhideAll'");
            }
            SubsetWidget.calculateVisibility();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void updateHiddenItems() {
        if (ItemList.loadFinished) {
            updateState.restart();
        }
    }

    public static void loadHidden() {
        block9: {
            LinkedList<ItemStack> itemList = new LinkedList<ItemStack>();
            try {
                NBTTagList list = NEIClientConfig.world.nbt.func_150295_c("hiddenItems", 10);
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    itemList.add(ItemStack.func_77949_a((NBTTagCompound)list.func_150305_b(i)));
                }
            }
            catch (Exception e) {
                NEIClientConfig.logger.error("Error loading hiddenItems", (Throwable)e);
                return;
            }
            try {
                if (hiddenWriteLock.tryLock(5L, TimeUnit.SECONDS)) {
                    try {
                        hiddenItems.clear();
                        hiddenItems.addAll(itemList);
                        break block9;
                    }
                    finally {
                        hiddenWriteLock.unlock();
                    }
                }
                NEIClientConfig.logger.error("Unable to obtain second write lock in 'loadHidden'");
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveHidden() {
        if (NEIClientConfig.world == null) {
            return;
        }
        NBTTagList list = new NBTTagList();
        for (ItemStack stack : hiddenItems.values()) {
            list.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
        }
        NEIClientConfig.world.nbt.func_74782_a("hiddenItems", (NBTBase)list);
    }

    public SubsetWidget() {
        super("NEI Subsets");
        API.addItemFilter(this);
        API.addSearchProvider(new DefaultParserProvider());
        this.z = 1;
    }

    @Override
    public String getRenderLabel() {
        if (NEIClientConfig.subsetWidgetOnTop()) {
            return NEIClientUtils.translate("inventory.item_subsets", new Object[0]);
        }
        return EnumChatFormatting.DARK_PURPLE + String.valueOf(SearchField.searchParser.getRedefinedPrefix('%')) + EnumChatFormatting.RESET;
    }

    @Override
    public void draw(int mx, int my) {
        super.draw(mx, my);
        hoverTag = null;
        hoverStack = null;
        if (root.isVisible()) {
            Minecraft mc = NEIClientUtils.mc();
            Rectangle4i screen = new Rectangle4i(2, 2, mc.field_71462_r.field_146294_l - 4, mc.field_71462_r.field_146295_m - 4);
            Rectangle4i parent = new Rectangle4i();
            boolean dropRight = this.x < screen.x + screen.w / 2;
            boolean dropDown = this.y < screen.y + screen.h / 2;
            parent.x = dropRight ? this.x : this.x + this.w;
            if (dropDown) {
                screen.y = parent.y = this.y + this.h;
                screen.h = SubsetWidget.alignValueToStep(mc.field_71462_r.field_146295_m - 2 - screen.y);
            } else {
                screen.h = SubsetWidget.alignValueToStep(this.y - screen.y);
                screen.y = this.y - screen.h;
                parent.y = this.y;
            }
            root.resize(screen, parent, dropRight);
            GL11.glPushAttrib((int)1048575);
            GuiContainerManager.enable2DRender();
            GuiContainerManager.drawItems.field_77023_b += 100.0f;
            root.draw(mx, my);
            GuiContainerManager.drawItems.field_77023_b -= 100.0f;
            GL11.glPopAttrib();
        }
    }

    private static int alignValueToStep(int height) {
        return height / 18 * 18;
    }

    protected static void calculateVisibility() {
        SubsetWidget.calculateVisibility(root);
        ItemList.updateFilter.restart();
    }

    protected static void calculateVisibility(SubsetTag tag) {
        int hidden = 0;
        tag.state = 2;
        for (SubsetTag child : tag.children) {
            SubsetWidget.calculateVisibility(child);
            if (child.state == 1) {
                tag.state = 1;
                continue;
            }
            if (child.state != 0) continue;
            ++hidden;
        }
        if (tag.state == 1) {
            return;
        }
        for (ItemStack item : tag.items) {
            if (SubsetWidget.isHidden(item)) {
                ++hidden;
                continue;
            }
            if (hidden <= 0) continue;
            break;
        }
        if (hidden == tag.children.size() + tag.items.size()) {
            tag.state = 0;
        } else if (hidden > 0) {
            tag.state = 1;
        }
    }

    @Override
    public void update() {
        enableSearchBySubsets = SearchTokenParser.SearchMode.fromInt(NEIClientConfig.getIntSetting("inventory.search.subsetsSearchMode")) == SearchTokenParser.SearchMode.PREFIX;
        Point mouse = GuiDraw.getMousePosition();
        this.updateVisiblity(mouse.x, mouse.y);
    }

    private void updateVisiblity(int mx, int my) {
        if (!root.isVisible() || root.isScrolling()) {
            return;
        }
        root.updateVisiblity(mx, my);
        if (!root.isVisible() && this.bounds().contains(mx, my)) {
            root.setVisible();
        }
    }

    @Override
    public boolean contains(int px, int py) {
        return super.contains(px, py) || root.isVisible() && root.contains(px, py);
    }

    @Override
    public boolean handleClick(int mx, int my, int button) {
        if (root.isVisible() && root.contains(mx, my)) {
            root.mouseClicked(mx, my, button);
            return true;
        }
        if (button == 0) {
            if (System.currentTimeMillis() - this.lastclicktime < 500L) {
                SubsetWidget.unhideAll();
            } else {
                root.setVisible();
            }
            NEIClientUtils.playClickSound();
            this.lastclicktime = System.currentTimeMillis();
        }
        return true;
    }

    @Override
    public boolean onButtonPress(boolean rightclick) {
        return false;
    }

    @Override
    public void mouseDragged(int mx, int my, int button, long heldTime) {
        if (root.isVisible()) {
            root.mouseDragged(mx, my, button, heldTime);
        }
    }

    @Override
    public void mouseUp(int mx, int my, int button) {
        if (root.isVisible()) {
            root.mouseUp(mx, my, button);
        }
    }

    @Override
    public boolean onMouseWheel(int i, int mx, int my) {
        return root.isVisible() && root.mouseScrolled(mx, my, -i) || this.contains(mx, my);
    }

    @Override
    public void onGuiClick(int mx, int my) {
        if (!this.contains(mx, my)) {
            root.setHidden();
        }
    }

    @Override
    public ItemStack getStackMouseOver(int mx, int my) {
        return hoverStack;
    }

    @Override
    public ItemFilter getFilter() {
        return item -> !SubsetWidget.isHidden(item);
    }

    @Override
    public void addTooltips(List<String> tooltip) {
        if (hoverStack == null && hoverTag != null) {
            tooltip.add(hoverTag.displayName() + "\u00a7h");
        }
    }

    @Override
    public Map<String, String> handleHotkeys(GuiContainer gui, int mousex, int mousey, Map<String, String> hotkeys) {
        if (hoverStack != null) {
            if (NEIClientConfig.canCheatItem(hoverStack)) {
                hotkeys.put(NEIClientUtils.getKeyName(0x2000000, 0), NEIClientUtils.translate("subsets.item.cheat", new Object[0]));
            }
            if (enableSearchBySubsets) {
                hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0), NEIClientUtils.translate("subsets.item.search", new Object[0]));
            }
            hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("subsets.item.show", new Object[0]));
            hotkeys.put(NEIMouseUtils.getKeyName(1), NEIClientUtils.translate("subsets.item.hide", new Object[0]));
        } else if (hoverTag != null) {
            hotkeys.put(NEIClientUtils.translate("subsets.tag.onlythis.key", new Object[0]), NEIClientUtils.translate("subsets.tag.onlythis", new Object[0]));
            if (enableSearchBySubsets) {
                hotkeys.put(NEIClientUtils.getKeyName(0x4000000, 0), NEIClientUtils.translate("subsets.tag.search", new Object[0]));
            }
            hotkeys.put(NEIMouseUtils.getKeyName(0), NEIClientUtils.translate("subsets.tag.show", new Object[0]));
            hotkeys.put(NEIMouseUtils.getKeyName(1), NEIClientUtils.translate("subsets.tag.hide", new Object[0]));
        }
        return hotkeys;
    }

    static {
        updateState = new UpdateStateTask();
    }

    public static class SubsetTag {
        public final String fullname;
        public final String path;
        public final String parentPath;
        public final ItemFilter filter;
        public int state = 2;
        public int calculatedWidth;
        public final List<ItemStack> items;
        public final List<SubsetTag> children = new ArrayList<SubsetTag>();
        protected final SubsetSlot slot = new SubsetSlot();
        private SubsetTag selectedChild;
        private int visible;

        public SubsetTag(String fullname) {
            this(fullname, null);
        }

        public SubsetTag(String fullname, ItemFilter filter) {
            this.fullname = EnumChatFormatting.func_110646_a((String)fullname);
            this.filter = filter == null ? new ItemList.NothingItemFilter() : filter;
            this.items = new ArrayList<ItemStack>();
            if (this.fullname != null) {
                this.path = this.fullname.replaceAll("\\s+", "").toLowerCase();
                int idx = this.path.lastIndexOf(46);
                this.parentPath = idx < 0 ? null : this.path.substring(0, idx);
            } else {
                this.path = null;
                this.parentPath = null;
            }
        }

        public String displayName() {
            String translated = NEIClientUtils.translate("subsets." + this.fullname, new Object[0]);
            return translated.startsWith("nei.") ? this.name() : translated;
        }

        public String name() {
            int idx = this.fullname.indexOf(46);
            return idx < 0 ? this.fullname : this.fullname.substring(idx + 1);
        }

        public String parent() {
            int idx = this.fullname.lastIndexOf(46);
            return idx < 0 ? null : this.fullname.substring(0, idx);
        }

        public void clearCache() {
            this.state = 2;
            this.items.clear();
            this.children.clear();
            this.calculatedWidth = 0;
        }

        public void updateVisiblity(int mx, int my) {
            if (this.selectedChild != null) {
                this.selectedChild.updateVisiblity(mx, my);
                if (!this.selectedChild.isVisible()) {
                    this.selectedChild = null;
                }
            }
            if (this.slot.contains(mx, my) && (this.selectedChild == null || !this.selectedChild.contains(mx, my))) {
                SubsetTag mtag;
                int mslot = this.slot.getClickedSlot(my);
                if (mslot >= 0 && mslot < this.children.size() && (mtag = this.children.get(mslot)) != null) {
                    if (mtag != this.selectedChild && this.selectedChild != null) {
                        this.selectedChild.setHidden();
                    }
                    this.selectedChild = mtag;
                    this.selectedChild.setVisible();
                }
                this.setVisible();
            }
            if (this.selectedChild == null) {
                this.countdownVisible();
            }
        }

        public void setHidden() {
            this.visible = 0;
            this.slot.mouseMovedOrUp(0, 0, 0);
            if (this.selectedChild != null) {
                this.selectedChild.setHidden();
                this.selectedChild = null;
            }
        }

        public void setVisible() {
            this.visible = 10;
        }

        private void countdownVisible() {
            if (this.visible > 0 && --this.visible == 0) {
                this.setHidden();
            }
        }

        public void resize(Rectangle4i screen, Rectangle4i parent, boolean dropRight) {
            int slotX;
            int height = Math.min(this.slot.contentHeight(), screen.h);
            int width = Math.max(this.calculatedWidth + 2, this.items.isEmpty() ? 0 : 20);
            int scrollbarWidth = this.slot.scrollbarDim().width;
            if (this.slot.contentHeight() > height) {
                width += scrollbarWidth;
            }
            int slotY = parent.y1() + Math.min(0, SubsetWidget.alignValueToStep(screen.y2() - parent.y1() - height));
            int n = slotX = dropRight ? parent.x2() : parent.x1() - width;
            if (slotX + width >= screen.x2()) {
                slotX = parent.x1() - width;
                dropRight = false;
            } else if (slotX <= screen.x1()) {
                slotX = parent.x2();
                dropRight = true;
            }
            this.slot.setSize(slotX, slotY, width, height);
            if (dropRight) {
                this.slot.setMargins(0, 0, this.slot.hasScrollbar() ? scrollbarWidth : 0, 0);
            } else {
                this.slot.setMargins(this.slot.hasScrollbar() ? scrollbarWidth : 0, 0, 0, 0);
            }
            if (this.selectedChild != null) {
                this.selectedChild.resize(screen, new Rectangle4i(this.slot.x, this.slot.y + this.slot.getSlotY(this.children.indexOf(this.selectedChild)) - this.slot.scrolledPixels(), width, 18), dropRight);
            }
        }

        protected int nameWidth() {
            return Minecraft.func_71410_x().field_71466_p.func_78256_a(this.displayName()) + 4;
        }

        public boolean isVisible() {
            return this.visible > 0;
        }

        public void draw(int mx, int my) {
            this.slot.draw(mx, my, 0.0f);
            if (this.selectedChild != null) {
                this.selectedChild.draw(mx, my);
            }
        }

        public boolean contains(int px, int py) {
            return this.slot.contains(px, py) || this.selectedChild != null && this.selectedChild.contains(px, py);
        }

        public void mouseClicked(int mx, int my, int button) {
            if (this.selectedChild != null && this.selectedChild.contains(mx, my)) {
                this.selectedChild.mouseClicked(mx, my, button);
            } else if (this.slot.contains(mx, my)) {
                this.slot.mouseClicked(mx, my, button);
            }
        }

        public void mouseDragged(int mx, int my, int button, long heldTime) {
            this.slot.mouseDragged(mx, my, button, heldTime);
            if (this.selectedChild != null) {
                this.selectedChild.mouseDragged(mx, my, button, heldTime);
            }
        }

        public void mouseUp(int mx, int my, int button) {
            this.slot.mouseMovedOrUp(mx, my, button);
            if (this.selectedChild != null) {
                this.selectedChild.mouseUp(mx, my, button);
            }
        }

        public boolean mouseScrolled(int mx, int my, int scroll) {
            if (this.slot.hasScrollbar() && this.slot.contains(mx, my)) {
                this.slot.scroll(scroll);
                return true;
            }
            if (this.selectedChild != null && this.selectedChild.mouseScrolled(mx, my, scroll)) {
                return true;
            }
            if (this.slot.hasScrollbar() && !this.contains(mx, my)) {
                this.slot.scroll(scroll);
                return true;
            }
            return false;
        }

        public boolean isScrolling() {
            return this.slot.isScrolling() || this.selectedChild != null && this.selectedChild.isScrolling();
        }

        protected class SubsetSlot
        extends GuiScrollSlot {
            public SubsetSlot() {
                super(0, 0, 0, 0);
                this.setSmoothScroll(false);
            }

            public int getSlotHeight(int slot) {
                return 18;
            }

            protected int getNumSlots() {
                return SubsetTag.this.children.size() + SubsetTag.this.items.size();
            }

            protected void slotClicked(int slot, int button, int mx, int my, int count) {
                if (slot < SubsetTag.this.children.size()) {
                    SubsetTag tag = SubsetTag.this.children.get(slot);
                    if (enableSearchBySubsets && NEIClientUtils.shiftKey()) {
                        LayoutManager.searchField.setText(SearchField.searchParser.getRedefinedPrefix('%') + tag.path);
                    } else if (button == 0 && count >= 2) {
                        SubsetWidget.showOnly(tag);
                    } else if (button == 0 || button == 1) {
                        SubsetWidget.setHidden(tag, button == 1);
                    }
                } else {
                    ItemStack item = SubsetTag.this.items.get(slot - SubsetTag.this.children.size());
                    if (NEIClientUtils.controlKey() && NEIClientConfig.canCheatItem(item)) {
                        NEIClientUtils.cheatItem(item, button, -1);
                    } else if (enableSearchBySubsets && NEIClientUtils.shiftKey()) {
                        LayoutManager.searchField.setText(SearchField.getEscapedSearchText(item));
                    } else if (button == 0 || button == 1) {
                        SubsetWidget.setHidden(item, button == 1);
                    }
                }
            }

            protected void drawSlot(int slot, int x, int y, int mx, int my, float frame) {
                int w = this.windowBounds().width;
                Rectangle4i r = new Rectangle4i(0, 0, w, this.getSlotHeight(slot));
                if (slot < SubsetTag.this.children.size()) {
                    SubsetTag tag = SubsetTag.this.children.get(slot);
                    LayoutManager.getLayoutStyle().drawSubsetTag(tag.displayName(), x, y, r.w, r.h, tag.state, r.contains(mx, my));
                    if (r.contains(mx, my)) {
                        hoverTag = tag;
                    }
                } else {
                    ItemStack stack = SubsetTag.this.items.get(slot - SubsetTag.this.children.size());
                    boolean hidden = SubsetWidget.isHidden(stack);
                    LayoutManager.getLayoutStyle().drawSubsetTag(null, x, y, r.w, r.h, hidden ? 0 : 2, r.contains(mx, my));
                    GuiContainerManager.drawItem(x + (w / 2 - 8), y + 1, stack);
                    if (r.contains(mx, my)) {
                        hoverStack = stack;
                    }
                }
            }

            public void drawOverlay(float frame) {
            }

            public void drawBackground(float frame) {
                SubsetSlot.func_73734_a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-14671840);
            }

            public int scrollbarAlignment() {
                return this.marginleft == 0 ? 1 : -1;
            }

            public void drawScrollbar(float frame) {
                if (this.hasScrollbar()) {
                    super.drawScrollbar(frame);
                }
            }

            public int scrollbarGuideAlignment() {
                return 0;
            }
        }
    }

    private static class UpdateStateTask
    extends RestartableTask {
        public UpdateStateTask() {
            super("NEI Subset Item Allocation");
        }

        @Override
        public void execute() {
            try {
                ArrayList list = new ArrayList(tags.values());
                root.clearCache();
                list.parallelStream().forEach(tag -> {
                    tag.clearCache();
                    ItemList.items.stream().filter(tag.filter::matches).collect(Collectors.toCollection(() -> tag.items));
                });
                for (SubsetTag tag2 : list) {
                    if (tag2.parentPath == null) {
                        root.children.add(tag2);
                        continue;
                    }
                    ((SubsetTag)tags.get((Object)tag2.parentPath)).children.add(tag2);
                }
                boolean changed = false;
                do {
                    changed = false;
                    for (SubsetTag tag3 : list) {
                        changed = tag3.children.removeIf(child -> child.children.isEmpty() && child.items.isEmpty()) || changed;
                    }
                } while (changed);
                for (SubsetTag tag3 : list) {
                    tag3.children.sort(Comparator.comparing(SubsetTag::displayName));
                    tag3.calculatedWidth = tag3.children.stream().mapToInt(SubsetTag::nameWidth).max().orElse(0);
                }
                root.children.removeIf(child -> child.children.isEmpty() && child.items.isEmpty());
                root.children.sort(Comparator.comparing(SubsetTag::displayName));
                root.calculatedWidth = root.children.stream().mapToInt(SubsetTag::nameWidth).max().orElse(0);
                SubsetWidget.calculateVisibility(root);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    private static class DefaultParserProvider
    implements SearchTokenParser.ISearchParserProvider {
        private DefaultParserProvider() {
        }

        @Override
        public ItemFilter getFilter(String searchText) {
            String pathPart = searchText.replaceAll("\\s+", "").toLowerCase();
            ItemList.AnyMultiItemFilter filter = new ItemList.AnyMultiItemFilter();
            HashSet<ItemStack> filteredItems = new HashSet<ItemStack>();
            for (SubsetTag tag : tags.values()) {
                if (tag.filter == null || !tag.path.contains(pathPart)) continue;
                filteredItems.addAll(tag.items);
                filter.filters.add(tag.filter);
            }
            return stack -> filteredItems.contains(stack) || !ItemList.items.contains(stack) && filter.matches(stack);
        }

        @Override
        public char getPrefix() {
            return '%';
        }

        @Override
        public EnumChatFormatting getHighlightedColor() {
            return EnumChatFormatting.DARK_PURPLE;
        }

        @Override
        public SearchTokenParser.SearchMode getSearchMode() {
            return SearchTokenParser.SearchMode.fromInt(NEIClientConfig.getIntSetting("inventory.search.subsetsSearchMode"));
        }
    }
}

