/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.FormattedTextField;
import codechicken.nei.SearchTokenParser;
import java.util.List;
import java.util.StringJoiner;
import net.minecraft.util.EnumChatFormatting;

public class SearchTextFormatter
implements FormattedTextField.TextFormatter {
    protected final SearchTokenParser searchParser;

    public SearchTextFormatter(SearchTokenParser searchParser) {
        this.searchParser = searchParser;
    }

    @Override
    public String format(String text) {
        String[] parts = (text + "| ").split("\\|");
        StringJoiner formattedText = new StringJoiner(EnumChatFormatting.GRAY + "|");
        for (int i = 0; i < parts.length - 1; ++i) {
            String filterText = parts[i];
            List<SearchTokenParser.SearchToken> tokens = this.searchParser.splitSearchText(filterText);
            StringBuilder formattedPart = new StringBuilder();
            int startIndex = 0;
            for (SearchTokenParser.SearchToken token : tokens) {
                formattedPart.append(filterText.substring(startIndex, token.start));
                EnumChatFormatting tokenColor = EnumChatFormatting.RESET;
                if (token.firstChar != null) {
                    tokenColor = this.searchParser.getProvider(token.firstChar.charValue()).getHighlightedColor();
                }
                if (token.ignore) {
                    formattedPart.append(EnumChatFormatting.BLUE + "-");
                }
                if (token.firstChar != null) {
                    formattedPart.append(tokenColor + String.valueOf(token.firstChar));
                }
                if (token.quotes) {
                    formattedPart.append(EnumChatFormatting.GOLD + "\"");
                }
                if (!token.rawText.isEmpty()) {
                    formattedPart.append(tokenColor + token.rawText);
                }
                if (token.quotes) {
                    formattedPart.append(EnumChatFormatting.GOLD + "\"");
                }
                startIndex = token.end;
            }
            formattedPart.append(filterText.substring(startIndex, filterText.length()));
            formattedText.add(formattedPart);
        }
        return formattedText.toString();
    }
}

