/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.nei.ItemStackMap;
import codechicken.nei.recipe.StackInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemStackAmount {
    private final Map<NBTTagCompound, Long> itemMap = new LinkedHashMap<NBTTagCompound, Long>();

    public void putAll(ItemStackAmount amounts) {
        for (Map.Entry<NBTTagCompound, Long> entry : amounts.itemMap.entrySet()) {
            this.itemMap.put(entry.getKey(), entry.getValue() + this.itemMap.getOrDefault(entry.getKey(), 0L));
        }
    }

    public void addAll(Iterable<ItemStack> items) {
        for (ItemStack stack : items) {
            this.add(stack);
        }
    }

    public void add(ItemStack item) {
        this.add(item, Long.valueOf(StackInfo.getAmount(item)));
    }

    public void add(ItemStack stack, Long value) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        NBTTagCompound key = StackInfo.itemStackToNBT(stack, false);
        if (key != null) {
            this.itemMap.put(key, value + this.itemMap.getOrDefault(key, 0L));
        }
    }

    public Long get(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        NBTTagCompound key = StackInfo.itemStackToNBT(stack, false);
        return this.itemMap.get(key);
    }

    public void put(ItemStack stack, long value) {
        if (stack == null || stack.func_77973_b() == null) {
            return;
        }
        NBTTagCompound key = StackInfo.itemStackToNBT(stack, false);
        if (key != null) {
            this.itemMap.put(key, value);
        }
    }

    public long getOrDefault(ItemStack stack, long defaultAmount) {
        Long e = this.get(stack);
        return e == null ? defaultAmount : e;
    }

    public boolean contains(ItemStack stack) {
        return this.get(stack) != null;
    }

    public void clear() {
        this.itemMap.clear();
    }

    public Long remove(ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        NBTTagCompound key = StackInfo.itemStackToNBT(stack, false);
        return this.itemMap.remove(key);
    }

    public boolean removeIf(Predicate<Map.Entry<NBTTagCompound, Long>> predicate) {
        return this.itemMap.entrySet().removeIf(predicate);
    }

    public Set<Map.Entry<NBTTagCompound, Long>> entrySet() {
        return this.itemMap.entrySet();
    }

    public List<ItemStack> values() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (Map.Entry<NBTTagCompound, Long> entry : this.itemMap.entrySet()) {
            list.add(StackInfo.loadFromNBT(entry.getKey(), Math.max(0L, entry.getValue())));
        }
        return list;
    }

    public int size() {
        return this.itemMap.size();
    }

    public boolean isEmpty() {
        return this.itemMap.isEmpty();
    }

    public static ItemStackAmount of(ItemStackAmount map) {
        ItemStackAmount result = new ItemStackAmount();
        result.itemMap.putAll(map.itemMap);
        return result;
    }

    public static ItemStackAmount of(ItemStackMap<Long> map) {
        ItemStackAmount result = new ItemStackAmount();
        for (ItemStackMap.Entry<Long> entry : map.entries()) {
            result.put(entry.key, (Long)entry.value);
        }
        return result;
    }

    public static ItemStackAmount of(Iterable<ItemStack> items) {
        ItemStackAmount result = new ItemStackAmount();
        for (ItemStack stack : items) {
            result.add(stack);
        }
        return result;
    }
}

