/*
 * Decompiled with CFR 0.152.
 */
package codechicken.nei;

import codechicken.core.CommonUtils;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.SubsetWidget;
import codechicken.nei.api.API;
import codechicken.nei.recipe.Recipe;
import codechicken.nei.recipe.StackInfo;
import codechicken.nei.util.NBTJson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.io.IOUtils;

public class FavoriteRecipes {
    private static final Set<NBTTagCompound> tools = new HashSet<NBTTagCompound>();
    private static final Map<NBTTagCompound, Recipe.RecipeId> items = new HashMap<NBTTagCompound, Recipe.RecipeId>();
    private static final Map<String, Recipe.RecipeId> fluids = new HashMap<String, Recipe.RecipeId>();
    private static File favoriteFile;

    private FavoriteRecipes() {
    }

    public static void load() {
        File dir;
        String worldPath = "global";
        if (NEIClientConfig.getBooleanSetting("inventory.favorites.worldSpecific")) {
            worldPath = NEIClientConfig.getWorldPath();
        }
        if (!(dir = new File(CommonUtils.getMinecraftDir(), "saves/NEI/" + worldPath)).exists()) {
            dir.mkdirs();
        }
        if (!(favoriteFile = new File(dir, "favorites.ini")).exists()) {
            File defaultFavorites;
            File globalFavorites = new File(CommonUtils.getMinecraftDir(), "saves/NEI/global/favorites.ini");
            File configFavorites = new File(NEIClientConfig.configDir, "favorites.ini");
            File file = defaultFavorites = configFavorites.exists() ? configFavorites : globalFavorites;
            if (defaultFavorites.exists()) {
                try {
                    if (favoriteFile.createNewFile()) {
                        FileInputStream src = new FileInputStream(defaultFavorites);
                        FileOutputStream dst = new FileOutputStream(favoriteFile);
                        IOUtils.copy((InputStream)src, (OutputStream)dst);
                        ((InputStream)src).close();
                        ((OutputStream)dst).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        FavoriteRecipes.loadData();
    }

    private static void loadData() {
        List itemStrings;
        if (favoriteFile == null || !favoriteFile.exists()) {
            return;
        }
        try (FileInputStream reader = new FileInputStream(favoriteFile);){
            NEIClientConfig.logger.info("Loading favorites from file {}", new Object[]{favoriteFile});
            itemStrings = IOUtils.readLines((InputStream)reader, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Failed to load favorites from file {}", new Object[]{favoriteFile, e});
            return;
        }
        JsonParser parser = new JsonParser();
        items.clear();
        for (String itemStr : itemStrings) {
            if (itemStr.isEmpty() || itemStr.startsWith("#")) continue;
            try {
                String fluidKey;
                JsonObject jsonObject = parser.parse(itemStr).getAsJsonObject();
                if (jsonObject.get("item") == null || jsonObject.get("recipeId") == null) continue;
                NBTTagCompound itemStackNBT = (NBTTagCompound)NBTJson.toNbt(jsonObject.get("item"));
                Recipe.RecipeId recipeId = Recipe.RecipeId.of(jsonObject.getAsJsonObject("recipeId"));
                ItemStack stack = StackInfo.loadFromNBT(itemStackNBT);
                if (stack != null && (fluidKey = FavoriteRecipes.getFluidKey(stack)) != null) {
                    fluids.put(fluidKey, recipeId);
                }
                items.put(itemStackNBT, recipeId);
                if (!NEIServerUtils.isItemTool(stack)) continue;
                tools.add(itemStackNBT);
            }
            catch (JsonSyntaxException | IllegalArgumentException | IllegalStateException e) {
                NEIClientConfig.logger.error("Failed to load favorite from json string:\n{}", new Object[]{itemStr});
            }
        }
        SubsetWidget.updateHiddenItems();
    }

    public static Recipe.RecipeId getFavorite(ItemStack stack) {
        if (NEIClientConfig.favoritesEnabled() && stack != null) {
            Recipe.RecipeId recipeId = items.get(StackInfo.itemStackToNBT(stack, false));
            if (recipeId == null) {
                recipeId = fluids.get(FavoriteRecipes.getFluidKey(stack));
            }
            if (recipeId != null) {
                return recipeId;
            }
            if (NEIServerUtils.isItemTool(stack) && (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("GT.ToolStats"))) {
                for (NBTTagCompound nbt : tools) {
                    if (!NEIServerUtils.areStacksSameTypeCraftingWithNBT(stack, StackInfo.loadFromNBT(nbt))) continue;
                    return items.get(nbt);
                }
            }
        }
        return null;
    }

    public static ItemStack getFavorite(Recipe.RecipeId recipeId) {
        Optional<Map.Entry> result;
        if (NEIClientConfig.favoritesEnabled() && (result = items.entrySet().stream().filter(entry -> ((Recipe.RecipeId)entry.getValue()).equals(recipeId)).findAny()).isPresent()) {
            return StackInfo.loadFromNBT((NBTTagCompound)result.get().getKey());
        }
        return null;
    }

    public static boolean contains(ItemStack stack) {
        return FavoriteRecipes.getFavorite(stack) != null;
    }

    public static void setFavorite(ItemStack stack, Recipe.RecipeId recipeId) {
        NBTTagCompound itemStackNBT = StackInfo.itemStackToNBT(stack, false);
        String fluidKey = FavoriteRecipes.getFluidKey(stack);
        items.entrySet().removeIf(entry -> ((NBTTagCompound)entry.getKey()).equals((Object)itemStackNBT) || ((Recipe.RecipeId)entry.getValue()).equals(recipeId));
        fluids.entrySet().removeIf(entry -> ((String)entry.getKey()).equals(fluidKey) || ((Recipe.RecipeId)entry.getValue()).equals(recipeId));
        if (recipeId != null) {
            items.put(itemStackNBT, recipeId);
            if (NEIServerUtils.isItemTool(stack)) {
                tools.add(itemStackNBT);
            }
            if (fluidKey != null) {
                fluids.put(fluidKey, recipeId);
            }
        }
        SubsetWidget.updateHiddenItems();
        ItemList.updateFilter.restart();
    }

    private static String getFluidKey(ItemStack stack) {
        FluidStack fluid = StackInfo.getFluid(stack);
        if (fluid != null) {
            return FluidRegistry.getFluidName((FluidStack)fluid);
        }
        return null;
    }

    public static void save() {
        if (favoriteFile == null) {
            return;
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (Map.Entry<NBTTagCompound, Recipe.RecipeId> entry : items.entrySet()) {
            try {
                JsonObject line = new JsonObject();
                line.add("item", NBTJson.toJsonObject((NBTBase)entry.getKey()));
                line.add("recipeId", (JsonElement)entry.getValue().toJsonObject());
                strings.add(NBTJson.toJson((JsonElement)line));
            }
            catch (JsonSyntaxException e) {
                NEIClientConfig.logger.error("Failed to stringify favorites ItemStack to json string");
            }
        }
        try (FileOutputStream output = new FileOutputStream(favoriteFile);){
            IOUtils.writeLines(strings, (String)"\n", (OutputStream)output, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            NEIClientConfig.logger.error("Filed to save favorites list to file {}", new Object[]{favoriteFile, e});
        }
    }

    static {
        API.addSubset("Favorites", FavoriteRecipes::contains);
    }
}

