/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.drawable.text;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IIcon;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.drawable.ITextLine;
import com.cleanroommc.modularui.drawable.DelegateIcon;
import com.cleanroommc.modularui.drawable.Icon;
import com.cleanroommc.modularui.drawable.text.ComposedLine;
import com.cleanroommc.modularui.drawable.text.FontRenderHelper;
import com.cleanroommc.modularui.drawable.text.FormattingState;
import com.cleanroommc.modularui.drawable.text.TextLine;
import com.cleanroommc.modularui.mixins.early.minecraft.FontRendererAccessor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;

public class RichTextCompiler {
    public static final RichTextCompiler INSTANCE = new RichTextCompiler();
    private FontRenderer fr;
    private int maxWidth;
    private List<ITextLine> lines;
    private List<Object> currentLine;
    private int x;
    private int h;
    private final FormattingState formatting = new FormattingState();

    public List<ITextLine> compileLines(FontRenderer fr, List<Object> raw, int maxWidth, float scale) {
        this.reset(fr, (int)((float)maxWidth / scale));
        this.compile(raw);
        return this.lines;
    }

    public void reset(FontRenderer fr, int maxWidth) {
        this.fr = fr != null ? fr : Minecraft.func_71410_x().field_71466_p;
        this.maxWidth = maxWidth > 0 ? maxWidth : Integer.MAX_VALUE;
        this.lines = new ArrayList<ITextLine>();
        this.currentLine = new ArrayList<Object>();
        this.x = 0;
        this.h = 0;
        this.formatting.reset();
    }

    private void compile(List<Object> raw) {
        for (Object o : raw) {
            IIcon icon;
            if (o instanceof ITextLine) {
                ITextLine line = (ITextLine)o;
                this.newLine();
                this.lines.add(line);
                continue;
            }
            String text = null;
            if (o instanceof IKey) {
                IKey key = (IKey)o;
                if (key == IKey.EMPTY) continue;
                if (key == IKey.SPACE) {
                    this.addLineElement(key.get());
                    continue;
                }
                if (key == IKey.LINE_FEED) {
                    this.newLine();
                    this.formatting.reset();
                    continue;
                }
                text = key.getFormatted();
            } else if (!(o instanceof IDrawable)) {
                text = String.valueOf(o);
            }
            if (text != null) {
                this.compileString(text);
                continue;
            }
            if (!(o instanceof IIcon)) {
                o = ((IDrawable)o).asIcon();
            }
            IIcon delegate = icon = (IIcon)o;
            if (icon instanceof DelegateIcon) {
                DelegateIcon di = (DelegateIcon)icon;
                delegate = di.findRootDelegate();
            }
            if (delegate instanceof Icon) {
                Icon icon1 = (Icon)delegate;
                if (icon1.getWidth() <= 0) {
                    icon1.width(this.fr.field_78288_b);
                }
                if (icon1.getHeight() <= 0) {
                    icon1.height(this.fr.field_78288_b);
                }
            }
            if (icon.getWidth() > this.maxWidth) {
                ModularUI.LOGGER.warn("Icon is wider than max width");
            }
            this.checkNewLine(icon.getWidth());
            this.addLineElement(icon);
            this.h = Math.max(this.h, icon.getHeight());
            this.x += icon.getWidth();
        }
        this.newLine();
    }

    private void compileString(String text) {
        int l = text.indexOf(10);
        int k = 0;
        do {
            if (l < 0) {
                l = text.length();
            }
            String subText = text.substring(k, l);
            k = l + 1;
            while (!subText.isEmpty()) {
                char c;
                int i = ((FontRendererAccessor)this.fr).invokeSizeStringToWidth(subText, this.maxWidth - this.x);
                if (i == 0) {
                    if (this.x > 0) {
                        i = ((FontRendererAccessor)this.fr).invokeSizeStringToWidth(subText, this.maxWidth);
                    }
                    if (i == 0) {
                        throw new IllegalStateException("No space for string '" + subText + "'");
                    }
                    this.newLine();
                } else if (i < subText.length() && (c = subText.charAt(i)) != ' ' && this.x > 0) {
                    int j = ((FontRendererAccessor)this.fr).invokeSizeStringToWidth(subText, this.maxWidth);
                    if (j < subText.length()) {
                        c = subText.charAt(j);
                        if (j > i && c == ' ') {
                            this.newLine();
                        }
                    } else {
                        this.newLine();
                    }
                }
                String current = subText.length() <= i ? subText : RichTextCompiler.trimRight(subText.substring(0, i));
                int width = this.fr.func_78256_a(current);
                this.addLineElement(current);
                this.h = Math.max(this.h, this.fr.field_78288_b);
                this.x += width;
                if (subText.length() <= i) break;
                this.newLine();
                char c2 = subText.charAt(i);
                if (c2 == ' ') {
                    ++i;
                }
                subText = subText.substring(i);
            }
            if (l >= text.length() || text.charAt(l) != '\n') continue;
            this.newLine();
        } while ((l = text.indexOf(10, k)) >= 0 || k < text.length());
    }

    private void newLine() {
        Object object;
        int i = this.currentLine.size() - 1;
        if (!this.currentLine.isEmpty() && (object = this.currentLine.get(i)) instanceof String) {
            String s = (String)object;
            if (s.equals(" ")) {
                this.currentLine.remove(i);
            } else {
                this.currentLine.set(i, RichTextCompiler.trimRight(s));
            }
        }
        if (!this.currentLine.isEmpty()) {
            if (this.currentLine.size() == 1 && this.currentLine.get(0) instanceof String) {
                this.lines.add(new TextLine((String)this.currentLine.get(0), this.x));
                this.currentLine.clear();
            } else {
                this.lines.add(new ComposedLine(this.currentLine, this.x, this.h));
                this.currentLine = new ArrayList<Object>();
            }
        }
        this.x = 0;
        this.h = 0;
    }

    private void addLineElement(Object o) {
        if (o instanceof String) {
            int l;
            Object object;
            String s2 = (String)o;
            if (this.currentLine.size() == 1 && (object = this.currentLine.get(0)) instanceof String) {
                String s1 = (String)object;
                this.currentLine.set(0, s1 + s2);
                return;
            }
            if (this.currentLine.isEmpty() && (l = FontRenderHelper.getFormatLength(s2, 0)) + 1 < s2.length()) {
                o = RichTextCompiler.trimAt(s2, l);
            }
            o = this.formatting.getFormatting() + o;
            this.formatting.parseFrom(s2);
        }
        this.currentLine.add(o);
    }

    private void checkNewLine(int width) {
        if (this.x > 0 && this.x + width > this.maxWidth) {
            this.newLine();
        }
    }

    public static String trimRight(String s) {
        int i;
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        if (i < s.length() - 1) {
            s = s.substring(0, i);
        }
        return s;
    }

    public static String trimAt(String s, int start) {
        int l = 0;
        int n = s.length();
        for (int i = Math.max(0, start); i < n && Character.isWhitespace(s.charAt(i)); ++i) {
            ++l;
        }
        if (l == 0) {
            return s;
        }
        if (start <= 0) {
            return s.substring(l);
        }
        return s.substring(0, start) + s.substring(start + l);
    }
}

