/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.core.entity.EntityHelper;
import com.github.lunatrius.ingameinfo.client.gui.Info;
import com.github.lunatrius.ingameinfo.client.gui.InfoItem;
import com.github.lunatrius.ingameinfo.client.gui.InfoText;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public abstract class TagPlayerEquipment
extends Tag {
    public static final String[] TYPES = new String[]{"equipped", "helmet", "chestplate", "leggings", "boots"};
    public static final int[] SLOTS = new int[]{-1, 3, 2, 1, 0};
    protected final int slot;

    public TagPlayerEquipment(int slot) {
        this.slot = slot;
    }

    @Override
    public String getCategory() {
        return "playerequipment";
    }

    protected ItemStack getItemStack(int slot) {
        if (slot == -1) {
            return player.func_71045_bC();
        }
        return TagPlayerEquipment.player.field_71071_by.func_70440_f(slot);
    }

    public static void register() {
        for (int i = 0; i < TYPES.length; ++i) {
            TagRegistry.INSTANCE.register(new Name(SLOTS[i]).setName(TYPES[i] + "name"));
            TagRegistry.INSTANCE.register(new UniqueName(SLOTS[i]).setName(TYPES[i] + "uniquename"));
            TagRegistry.INSTANCE.register(new Damage(SLOTS[i]).setName(TYPES[i] + "damage"));
            TagRegistry.INSTANCE.register(new MaximumDamage(SLOTS[i]).setName(TYPES[i] + "maxdamage"));
            TagRegistry.INSTANCE.register(new DamageLeft(SLOTS[i]).setName(TYPES[i] + "damageleft"));
            TagRegistry.INSTANCE.register(new Quantity(SLOTS[i]).setName(TYPES[i] + "quantity"));
            TagRegistry.INSTANCE.register(new Icon(SLOTS[i], false).setName(TYPES[i] + "icon"));
            TagRegistry.INSTANCE.register(new Icon(SLOTS[i], true).setName(TYPES[i] + "largeicon"));
        }
    }

    public static class Name
    extends TagPlayerEquipment {
        public Name(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            String arrows = itemStack != null && itemStack.func_77973_b() == Items.field_151031_f ? " (" + EntityHelper.getItemCountInInventory((IInventory)Name.player.field_71071_by, (Item)Items.field_151032_g) + ")" : "";
            return itemStack != null ? itemStack.func_82833_r() + arrows : "";
        }
    }

    public static class UniqueName
    extends TagPlayerEquipment {
        public UniqueName(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            Item item = itemStack != null ? itemStack.func_77973_b() : null;
            return item != null ? GameData.getItemRegistry().func_148750_c((Object)item) : "";
        }
    }

    public static class Damage
    extends TagPlayerEquipment {
        public Damage(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77952_i() : 0);
        }
    }

    public static class MaximumDamage
    extends TagPlayerEquipment {
        public MaximumDamage(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77958_k() + 1 : 0);
        }
    }

    public static class DamageLeft
    extends TagPlayerEquipment {
        public DamageLeft(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77958_k() + 1 - itemStack.func_77952_i() : 0);
        }
    }

    public static class Quantity
    extends TagPlayerEquipment {
        public Quantity(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null ? EntityHelper.getItemCountInInventory((IInventory)Quantity.player.field_71071_by, (Item)itemStack.func_77973_b(), (int)itemStack.func_77960_j()) : 0);
        }
    }

    public static class Icon
    extends TagPlayerEquipment {
        private final boolean large;

        public Icon(int slot, boolean large) {
            super(slot);
            this.large = large;
        }

        @Override
        @NotNull
        public String getValue(@NotNull InfoText caller) {
            ItemStack itemStack = this.getItemStack(this.slot);
            if (itemStack == null) {
                caller.removeAttachedValue(this.getName());
                return "";
            }
            Info value = caller.getAttachedValue(this.getName());
            if (value == null || !value.getIdentifier().equals(itemStack.func_82833_r())) {
                InfoItem item = new InfoItem(itemStack, this.large);
                item.setIdentifier(itemStack.func_82833_r());
                caller.attachValue(this.getName(), item);
                return Icon.getIconTag(item);
            }
            return "";
        }

        @Override
        public String getValue() {
            return "";
        }
    }
}

