/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigEnum;
import serverutils.lib.icon.Color4I;
import serverutils.lib.util.IStringSerializable;
import serverutils.lib.util.misc.NameMap;

public enum EnumTristate implements IStringSerializable
{
    TRUE(Event.Result.ALLOW, ConfigBoolean.COLOR_TRUE, 1),
    FALSE(Event.Result.DENY, ConfigBoolean.COLOR_FALSE, 0),
    DEFAULT(Event.Result.DEFAULT, ConfigEnum.COLOR, 2);

    public static final NameMap<EnumTristate> NAME_MAP;
    private final Event.Result result;
    private final Color4I color;
    private final int opposite;

    public static EnumTristate read(NBTTagCompound nbt, String key) {
        return nbt.func_74764_b(key) ? (nbt.func_74767_n(key) ? TRUE : FALSE) : DEFAULT;
    }

    private EnumTristate(Event.Result r, Color4I c, int o) {
        this.result = r;
        this.color = c;
        this.opposite = o;
    }

    @Override
    public String getName() {
        return this.name().toLowerCase();
    }

    public Event.Result getResult() {
        return this.result;
    }

    public Color4I getColor() {
        return this.color;
    }

    public boolean isTrue() {
        return this == TRUE;
    }

    public boolean isFalse() {
        return this == FALSE;
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public boolean get(boolean def) {
        return this.isDefault() ? def : this.isTrue();
    }

    public EnumTristate getOpposite() {
        return NAME_MAP.get(this.opposite);
    }

    public void write(NBTTagCompound nbt, String key) {
        if (!this.isDefault()) {
            nbt.func_74757_a(key, this.isTrue());
        }
    }

    static {
        NAME_MAP = NameMap.createWithNameAndColor(DEFAULT, (sender, value) -> new ChatComponentTranslation(value.getName(), new Object[0]), EnumTristate::getColor, EnumTristate.values());
    }
}

