/*
 * Decompiled with CFR 0.152.
 */
package serverutils.lib.config;

import com.google.gson.JsonElement;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.config.IIteratingConfig;
import serverutils.lib.gui.IOpenableGui;
import serverutils.lib.gui.misc.GuiEditConfigValue;
import serverutils.lib.icon.Color4I;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.io.DataReader;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.IWithID;
import serverutils.lib.util.JsonUtils;
import serverutils.lib.util.misc.MouseButton;

public abstract class ConfigValue
implements IWithID {
    public abstract String getString();

    public abstract boolean getBoolean();

    public abstract int getInt();

    public double getDouble() {
        return this.getLong();
    }

    public long getLong() {
        return this.getInt();
    }

    public Ticks getTimer() {
        return Ticks.get(this.getLong());
    }

    public abstract ConfigValue copy();

    public boolean equalsValue(ConfigValue value) {
        return value == this || this.getString().equals(value.getString());
    }

    public Color4I getColor() {
        return Color4I.GRAY;
    }

    public void addInfo(ConfigValueInstance inst, List<String> list) {
        if (inst.getCanEdit() && !inst.getDefaultValue().isNull()) {
            list.add(EnumChatFormatting.AQUA + "Default: " + EnumChatFormatting.RESET + inst.getDefaultValue().getStringForGUI().func_150254_d());
        }
    }

    public List<String> getVariants() {
        return Collections.emptyList();
    }

    public boolean isNull() {
        return false;
    }

    public void onClicked(IOpenableGui gui, ConfigValueInstance inst, MouseButton button, Runnable callback) {
        if (this instanceof IIteratingConfig) {
            if (inst.getCanEdit()) {
                this.setValueFromOtherValue(((IIteratingConfig)((Object)this)).getIteration(button.isLeft()));
                callback.run();
            }
            return;
        }
        new GuiEditConfigValue(inst, (value, set) -> {
            if (set) {
                this.setValueFromOtherValue(value);
                callback.run();
            }
            gui.openGui();
        }).openGui();
    }

    public boolean setValueFromString(@Nullable ICommandSender sender, String string, boolean simulate) {
        JsonElement json = DataReader.get(string).safeJson();
        if (!json.isJsonNull()) {
            if (!simulate) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTBase nbt1 = JsonUtils.toNBT(json);
                if (nbt1 != null) {
                    nbt.func_74782_a("x", nbt1);
                }
                this.readFromNBT(nbt, "x");
            }
            return true;
        }
        return false;
    }

    public void setValueFromOtherValue(ConfigValue value) {
        this.setValueFromString(null, value.getString(), false);
    }

    public void setValueFromJson(JsonElement json) {
        if (json.isJsonPrimitive()) {
            this.setValueFromString(null, json.getAsString(), false);
        }
    }

    public boolean equals(Object o) {
        ConfigValue value;
        return o instanceof ConfigValue && this.equalsValue(value = (ConfigValue)o);
    }

    public final String toString() {
        return this.getString();
    }

    public IChatComponent getStringForGUI() {
        return new ChatComponentText(this.getString());
    }

    public abstract void writeToNBT(NBTTagCompound var1, String var2);

    public abstract void readFromNBT(NBTTagCompound var1, String var2);

    public abstract void writeData(DataOut var1);

    public abstract void readData(DataIn var1);

    public boolean isEmpty() {
        return !this.getBoolean();
    }
}

