/*
 * Decompiled with CFR 0.152.
 */
package serverutils.data;

import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.HoverEvent;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesCommon;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.BlockDimPosStorage;
import serverutils.data.TeleportLog;
import serverutils.data.TeleportTracker;
import serverutils.data.TeleportType;
import serverutils.lib.EnumMessageLocation;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.PlayerData;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.TeleporterDimPos;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;
import serverutils.lib.util.text_components.TextComponentParser;
import serverutils.task.Task;
import serverutils.task.TeleportTask;

public class ServerUtilitiesPlayerData
extends PlayerData {
    public static final String TAG_FLY = "fly";
    public static final String TAG_MUTED = "muted";
    public static final String TAG_LAST_CHUNK = "serveru_lchunk";
    private boolean enablePVP = true;
    private boolean showTeamPrefix = false;
    private String nickname = "";
    private EnumMessageLocation afkMesageLocation = EnumMessageLocation.CHAT;
    public final Collection<ForgePlayer> tpaRequestsFrom;
    public long afkTime;
    private IChatComponent cachedNameForChat;
    private BlockDimPos lastSafePos;
    public final long[] lastTeleport;
    public final BlockDimPosStorage homes = new BlockDimPosStorage();
    private final TeleportTracker teleportTracker;

    public static ServerUtilitiesPlayerData get(ForgePlayer player) {
        return (ServerUtilitiesPlayerData)player.getData().get("serverutilities");
    }

    public ServerUtilitiesPlayerData(ForgePlayer player) {
        super(player);
        this.tpaRequestsFrom = new HashSet<ForgePlayer>();
        this.lastTeleport = new long[Timer.VALUES.length];
        this.teleportTracker = new TeleportTracker();
    }

    @Override
    public String getId() {
        return "serverutilities";
    }

    @Override
    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("EnablePVP", this.enablePVP);
        nbt.func_74757_a("ShowTeamPrefix", this.showTeamPrefix);
        nbt.func_74782_a("Homes", (NBTBase)this.homes.serializeNBT());
        nbt.func_74782_a("TeleportTracker", (NBTBase)this.teleportTracker.serializeNBT());
        nbt.func_74778_a("Nickname", this.nickname);
        nbt.func_74778_a("AFK", EnumMessageLocation.NAME_MAP.getName(this.afkMesageLocation));
        return nbt;
    }

    @Override
    public void deserializeNBT(NBTTagCompound nbt) {
        this.enablePVP = !nbt.func_74764_b("EnablePVP") || nbt.func_74767_n("EnablePVP");
        this.showTeamPrefix = nbt.func_74767_n("ShowTeamPrefix");
        this.homes.deserializeNBT(nbt.func_74775_l("Homes"));
        this.teleportTracker.deserializeNBT(nbt.func_74775_l("TeleportTracker"));
        this.setLastDeath(BlockDimPos.fromIntArray(nbt.func_74759_k("LastDeath")), 0L);
        this.nickname = nbt.func_74779_i("Nickname");
        this.afkMesageLocation = EnumMessageLocation.NAME_MAP.get(nbt.func_74779_i("AFK"));
    }

    public void addConfig(ConfigGroup main) {
        ConfigGroup config = main.getGroup("serverutilities");
        config.setDisplayName((IChatComponent)new ChatComponentText("Server Utilities"));
        config.addBool("enable_pvp", () -> this.enablePVP, v -> {
            this.enablePVP = v;
        }, true).setCanEdit(ServerUtilitiesConfig.world.enable_pvp.isDefault());
        config.addString("nickname", () -> this.nickname, v -> {
            this.nickname = v;
        }, "").setCanEdit(ServerUtilitiesConfig.commands.nick && this.player.hasPermission("serverutilities.chat.nickname.set"));
        config.addEnum("afk", () -> this.afkMesageLocation, v -> {
            this.afkMesageLocation = v;
        }, EnumMessageLocation.NAME_MAP).setExcluded(!ServerUtilitiesConfig.afk.isEnabled(this.player.team.universe.server));
        ChatComponentTranslation info = new ChatComponentTranslation("player_config.serverutilities.show_team_prefix.info", new Object[]{this.player.team.getTitle()});
        config.addBool("show_team_prefix", () -> this.showTeamPrefix, v -> {
            this.showTeamPrefix = v;
        }, false).setInfo((IChatComponent)info).setExcluded(ServerUtilitiesConfig.teams.force_team_prefix);
    }

    public boolean enablePVP() {
        return this.enablePVP;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String name) {
        this.nickname = name.equals(this.player.getName()) ? "" : name;
        this.player.markDirty();
        this.clearCache();
    }

    public EnumMessageLocation getAFKMessageLocation() {
        return this.afkMesageLocation;
    }

    public void setLastDeath(@Nullable BlockDimPos pos) {
        this.setLastDeath(pos, MinecraftServer.func_130071_aq());
    }

    public void setLastDeath(@Nullable BlockDimPos pos, long timestamp) {
        if (pos == null) {
            return;
        }
        this.teleportTracker.logTeleport(TeleportType.RESPAWN, pos, timestamp);
        this.player.markDirty();
    }

    public BlockDimPos getLastDeath() {
        return this.teleportTracker.getLastDeath().getBlockDimPos();
    }

    public void setLastSafePos(@Nullable BlockDimPos pos) {
        this.lastSafePos = pos;
        this.player.markDirty();
    }

    @Nullable
    public BlockDimPos getLastSafePos() {
        return this.lastSafePos;
    }

    public void checkTeleportCooldown(ICommandSender sender, Timer timer) throws CommandException {
        long cooldown = this.lastTeleport[timer.ordinal()] + this.player.getRankConfig(timer.cooldown).getTimer().millis() - System.currentTimeMillis();
        if (cooldown > 0L) {
            throw ServerUtilities.error(sender, "cant_use_now_cooldown", StringUtils.getTimeString(cooldown));
        }
    }

    @Override
    public void clearCache() {
        this.cachedNameForChat = null;
        if (this.player.isFake()) {
            return;
        }
        EntityPlayerMP p = this.player.getNullablePlayer();
        if (p != null) {
            p.refreshDisplayName();
        }
    }

    public IChatComponent getNameForChat(EntityPlayerMP playerMP) {
        if (ServerUtils.isFake(playerMP)) {
            return new ChatComponentText(this.player.getName());
        }
        if (this.cachedNameForChat != null) {
            return this.cachedNameForChat.func_150259_f();
        }
        String text = this.player.getRankConfig("serverutilities.chat.name_format").getString();
        try {
            this.cachedNameForChat = TextComponentParser.parse(text, ServerUtilitiesCommon.chatFormattingSubstituteFunction(this.player));
        }
        catch (Exception ex) {
            String s = "Error parsing " + text + ": " + ex.getLocalizedMessage();
            ServerUtilities.LOGGER.error(s);
            this.cachedNameForChat = new ChatComponentText("BrokenFormatting");
            this.cachedNameForChat.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            this.cachedNameForChat.func_150256_b().func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(s)));
        }
        if (ServerUtilitiesConfig.teams.force_team_prefix || this.showTeamPrefix) {
            ChatComponentText end = new ChatComponentText("] ");
            IChatComponent prefix = new ChatComponentText("[").func_150257_a(this.player.team.getTitle()).func_150257_a((IChatComponent)end);
            this.cachedNameForChat = new ChatComponentText("").func_150257_a(prefix).func_150257_a(this.cachedNameForChat);
        }
        if (NBTUtils.getPersistedData((EntityPlayer)playerMP, false).func_74767_n("recording")) {
            ChatComponentText rec = new ChatComponentText("\u25a0 ");
            rec.func_150256_b().func_150238_a(EnumChatFormatting.RED);
            this.cachedNameForChat = new ChatComponentText("").func_150257_a((IChatComponent)rec).func_150257_a(this.cachedNameForChat);
        }
        this.cachedNameForChat.func_150258_a(" ");
        return this.cachedNameForChat.func_150259_f();
    }

    public TeleportLog getLastTeleportLog() {
        return this.teleportTracker.getLastAvailableLog(this.player.getProfile());
    }

    public void setLastTeleport(TeleportType teleportType, BlockDimPos from) {
        this.teleportTracker.logTeleport(teleportType, from, MinecraftServer.func_130071_aq());
        this.player.markDirty();
    }

    public void clearLastTeleport(TeleportType teleportType) {
        this.teleportTracker.clearLog(teleportType);
        this.player.markDirty();
    }

    public static enum Timer {
        HOME(TeleportType.HOME),
        WARP(TeleportType.WARP),
        BACK(TeleportType.BACK),
        SPAWN(TeleportType.SPAWN),
        TPA(TeleportType.TPA),
        RTP(TeleportType.RTP);

        public static final Timer[] VALUES;
        private final String cooldown;
        private final String warmup;
        private final TeleportType teleportType;

        private Timer(TeleportType teleportType) {
            this.teleportType = teleportType;
            this.cooldown = teleportType.getCooldownPermission();
            this.warmup = teleportType.getWarmupPermission();
        }

        public void teleport(EntityPlayerMP player, Function<EntityPlayerMP, TeleporterDimPos> pos, @Nullable Task extraTask) {
            Universe universe = Universe.get();
            int seconds = (int)RankConfigAPI.get(player, this.warmup).getTimer().seconds();
            if (seconds > 0) {
                IChatComponent component = StringUtils.color(ServerUtilities.lang((ICommandSender)player, "stand_still", seconds).func_150258_a(" [" + seconds + "]"), EnumChatFormatting.GOLD);
                Notification.of(ServerUtilitiesNotifications.TELEPORT_WARMUP, component).setVanilla(true).send(player.field_71133_b, (EntityPlayer)player);
                universe.scheduleTask(new TeleportTask(this.teleportType, player, this, seconds, pos, extraTask));
            } else {
                new TeleportTask(this.teleportType, player, this, 0, pos, extraTask).execute(universe);
            }
        }

        static {
            VALUES = Timer.values();
        }
    }
}

