/*
 * Decompiled with CFR 0.152.
 */
package serverutils;

import com.gtnewhorizon.gtnhlib.config.ConfigException;
import com.gtnewhorizon.gtnhlib.config.ConfigurationManager;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.command.CommandHandler;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesConfig;
import serverutils.ServerUtilitiesLeaderboards;
import serverutils.ServerUtilitiesPermissions;
import serverutils.ServerUtilitiesStats;
import serverutils.aurora.Aurora;
import serverutils.aurora.AuroraConfig;
import serverutils.aurora.mc.AuroraMinecraftHandler;
import serverutils.command.ServerUtilitiesCommands;
import serverutils.data.NodeEntry;
import serverutils.data.ServerUtilitiesLoadedChunkManager;
import serverutils.data.ServerUtilitiesUniverseData;
import serverutils.events.CustomPermissionPrefixesRegistryEvent;
import serverutils.events.IReloadHandler;
import serverutils.events.ServerReloadEvent;
import serverutils.events.ServerUtilitiesPreInitRegistryEvent;
import serverutils.handlers.ServerUtilitiesPlayerEventHandler;
import serverutils.handlers.ServerUtilitiesRegistryEventHandler;
import serverutils.handlers.ServerUtilitiesServerEventHandler;
import serverutils.handlers.ServerUtilitiesWorldEventHandler;
import serverutils.lib.ATHelper;
import serverutils.lib.EnumReloadType;
import serverutils.lib.OtherMods;
import serverutils.lib.config.ConfigBoolean;
import serverutils.lib.config.ConfigColor;
import serverutils.lib.config.ConfigDouble;
import serverutils.lib.config.ConfigFluid;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigInt;
import serverutils.lib.config.ConfigItemStack;
import serverutils.lib.config.ConfigList;
import serverutils.lib.config.ConfigLong;
import serverutils.lib.config.ConfigNBT;
import serverutils.lib.config.ConfigNull;
import serverutils.lib.config.ConfigString;
import serverutils.lib.config.ConfigStringEnum;
import serverutils.lib.config.ConfigTeamClient;
import serverutils.lib.config.ConfigTextComponent;
import serverutils.lib.config.ConfigTimer;
import serverutils.lib.config.ConfigValueProvider;
import serverutils.lib.config.IConfigCallback;
import serverutils.lib.config.RankConfigAPI;
import serverutils.lib.data.Action;
import serverutils.lib.data.AdminPanelAction;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.ISyncData;
import serverutils.lib.data.ServerUtilitiesAPI;
import serverutils.lib.data.ServerUtilitiesTeamGuiActions;
import serverutils.lib.data.TeamAction;
import serverutils.lib.data.Universe;
import serverutils.lib.gui.GuiIcons;
import serverutils.lib.icon.Color4I;
import serverutils.lib.math.Ticks;
import serverutils.lib.net.MessageToClient;
import serverutils.lib.util.CommonUtils;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.ServerUtils;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.CommandOverride;
import serverutils.ranks.Ranks;
import serverutils.ranks.ServerUtilitiesPermissionHandler;
import serverutils.task.CleanupTask;
import serverutils.task.DecayTask;
import serverutils.task.ShutdownTask;
import serverutils.task.backup.BackupTask;

public class ServerUtilitiesCommon {
    public static final Collection<NodeEntry> CUSTOM_PERM_PREFIX_REGISTRY = new HashSet<NodeEntry>();
    public static final Map<String, String> KAOMOJIS = new HashMap<String, String>();
    public static final Map<String, ConfigValueProvider> CONFIG_VALUE_PROVIDERS = new HashMap<String, ConfigValueProvider>();
    public static final Map<UUID, EditingConfig> TEMP_SERVER_CONFIG = new HashMap<UUID, EditingConfig>();
    public static final Map<String, ISyncData> SYNCED_DATA = new HashMap<String, ISyncData>();
    public static final HashMap<ResourceLocation, IReloadHandler> RELOAD_IDS = new HashMap();
    public static final Map<ResourceLocation, TeamAction> TEAM_GUI_ACTIONS = new HashMap<ResourceLocation, TeamAction>();
    public static final Map<ResourceLocation, AdminPanelAction> ADMIN_PANEL_ACTIONS = new HashMap<ResourceLocation, AdminPanelAction>();
    private static final Map<String, Function<ForgePlayer, IChatComponent>> CHAT_FORMATTING_SUBSTITUTES = new HashMap<String, Function<ForgePlayer, IChatComponent>>();

    public static Function<String, IChatComponent> chatFormattingSubstituteFunction(ForgePlayer player) {
        return s -> {
            Function<ForgePlayer, IChatComponent> sub = CHAT_FORMATTING_SUBSTITUTES.get(s);
            return sub == null ? null : sub.apply(player);
        };
    }

    public void preInit(FMLPreInitializationEvent event) {
        if (((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
            ServerUtilities.LOGGER.info("Loading ServerUtilities in development environment");
        }
        OtherMods.init();
        if (ServerUtilitiesConfig.ranks.enabled) {
            PermissionAPI.setPermissionHandler(ServerUtilitiesPermissionHandler.INSTANCE);
        }
        ServerUtilitiesStats.init();
        ServerUtilitiesNetHandler.init();
        if (!ForgeChunkManager.getConfig().hasCategory("serverutilities")) {
            ForgeChunkManager.getConfig().get("serverutilities", "maximumChunksPerTicket", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().get("serverutilities", "maximumTicketCount", 1000000).setMinValue(0);
            ForgeChunkManager.getConfig().save();
        }
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)ServerUtilities.INST, (ForgeChunkManager.LoadingCallback)ServerUtilitiesLoadedChunkManager.INSTANCE);
        KAOMOJIS.put("shrug", "\u00af\\_(\u30c4)_/\u00af");
        KAOMOJIS.put("tableflip", "(\u256f\u00b0\u25a1\u00b0)\u256f \ufe35 \u253b\u2501\u253b");
        KAOMOJIS.put("unflip", "\u252c\u2500\u252c\u30ce( \u309c-\u309c\u30ce)");
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesPlayerEventHandler.INST);
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesRegistryEventHandler.INST);
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesServerEventHandler.INST);
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesWorldEventHandler.INST);
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesUniverseData.INST);
        MinecraftForge.EVENT_BUS.register((Object)ServerUtilitiesPermissions.INST);
        FMLCommonHandler.instance().bus().register((Object)ServerUtilitiesServerEventHandler.INST);
        if (AuroraConfig.enable) {
            MinecraftForge.EVENT_BUS.register((Object)AuroraMinecraftHandler.INST);
            FMLCommonHandler.instance().bus().register((Object)AuroraMinecraftHandler.INST);
        }
        new CustomPermissionPrefixesRegistryEvent(CUSTOM_PERM_PREFIX_REGISTRY::add).post();
    }

    public void init(FMLInitializationEvent event) {
        ServerUtilitiesPermissions.registerPermissions();
        ServerUtilitiesPreInitRegistryEvent.Registry registry = new ServerUtilitiesPreInitRegistryEvent.Registry(){

            @Override
            public void registerConfigValueProvider(String id, ConfigValueProvider provider) {
                CONFIG_VALUE_PROVIDERS.put(id, provider);
            }

            @Override
            public void registerSyncData(String mod, ISyncData data) {
                SYNCED_DATA.put(mod, data);
            }

            @Override
            public void registerServerReloadHandler(ResourceLocation id, IReloadHandler handler) {
                RELOAD_IDS.put(id, handler);
            }

            @Override
            public void registerAdminPanelAction(AdminPanelAction action) {
                ADMIN_PANEL_ACTIONS.put(action.getId(), action);
            }

            @Override
            public void registerTeamAction(TeamAction action) {
                TEAM_GUI_ACTIONS.put(action.getId(), action);
            }
        };
        registry.registerConfigValueProvider("null", () -> ConfigNull.INSTANCE);
        registry.registerConfigValueProvider("list", () -> new ConfigList<ConfigNull>(ConfigNull.INSTANCE));
        registry.registerConfigValueProvider("bool", () -> new ConfigBoolean(false));
        registry.registerConfigValueProvider("int", () -> new ConfigInt(0));
        registry.registerConfigValueProvider("double", () -> new ConfigDouble(0.0));
        registry.registerConfigValueProvider("long", () -> new ConfigLong(0L));
        registry.registerConfigValueProvider("string", () -> new ConfigString(""));
        registry.registerConfigValueProvider("color", () -> new ConfigColor(Color4I.WHITE));
        registry.registerConfigValueProvider("enum", () -> new ConfigStringEnum(Collections.emptyList(), ""));
        registry.registerConfigValueProvider("item_stack", () -> new ConfigItemStack(InvUtils.EMPTY_STACK));
        registry.registerConfigValueProvider("text_component", () -> new ConfigTextComponent((IChatComponent)new ChatComponentText("")));
        registry.registerConfigValueProvider("timer", () -> new ConfigTimer(Ticks.NO_TICKS));
        registry.registerConfigValueProvider("nbt", () -> new ConfigNBT(null));
        registry.registerConfigValueProvider("fluid", () -> new ConfigFluid(null, null));
        registry.registerConfigValueProvider("team", () -> new ConfigTeamClient(""));
        registry.registerAdminPanelAction(new AdminPanelAction("serverutilities", "reload", GuiIcons.REFRESH, -1000){

            @Override
            public Action.Type getType(ForgePlayer player, NBTTagCompound data) {
                return Action.Type.fromBoolean(player.isOP());
            }

            @Override
            public void onAction(ForgePlayer player, NBTTagCompound data) {
                ServerUtilitiesAPI.reloadServer(player.team.universe, (ICommandSender)player.getPlayer(), EnumReloadType.RELOAD_COMMAND, ServerReloadEvent.ALL);
            }
        }.setTitle((IChatComponent)new ChatComponentTranslation("serverutilities.lang.reload_server_button", new Object[0])));
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.CONFIG);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.INFO);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.MEMBERS);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.ALLIES);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.MODERATORS);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.ENEMIES);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.LEAVE);
        registry.registerTeamAction(ServerUtilitiesTeamGuiActions.TRANSFER_OWNERSHIP);
        new ServerUtilitiesPreInitRegistryEvent(registry).post();
        RELOAD_IDS.put(new ResourceLocation("serverutilities", "internal_reload"), this::onReload);
        RankConfigAPI.getHandler();
        CHAT_FORMATTING_SUBSTITUTES.put("name", ForgePlayer::getDisplayName);
        CHAT_FORMATTING_SUBSTITUTES.put("team", player -> player.team.getTitle());
    }

    public void postInit(FMLPostInitializationEvent event) {
        if ((Loader.isModLoaded((String)"FTBU") || Loader.isModLoaded((String)"FTBL")) && event.getSide().isServer()) {
            throw new RuntimeException("FTBU/FTBL Detected, please remove them and start again.");
        }
    }

    public void onServerAboutToStart(FMLServerAboutToStartEvent event) {
        Universe.onServerAboutToStart(event);
        MinecraftForge.EVENT_BUS.register((Object)Universe.get());
        FMLCommonHandler.instance().bus().register((Object)Universe.get());
    }

    public void onServerStarting(FMLServerStartingEvent event) {
        ServerUtilitiesCommands.registerCommands(event);
        if (AuroraConfig.enable) {
            Aurora.start(event.getServer());
        }
    }

    public void onServerStarted(FMLServerStartedEvent event) {
        Universe.onServerStarted(event);
        this.registerTasks();
        if (Ranks.isActive()) {
            boolean bukkitLoaded;
            Ranks.INSTANCE.commands.clear();
            boolean bl = bukkitLoaded = CommonUtils.getClassExists("thermos.ThermosRemapper") || CommonUtils.getClassExists("org.ultramine.server.UltraminePlugin") || CommonUtils.getClassExists("org.bukkit.World");
            if (bukkitLoaded) {
                ServerUtilities.LOGGER.warn("Thermos/Ultramine detected, command overriding has been disabled. If there are any issues with Server Utilities ranks or permissions, please test them without those mods!");
            }
            if (!ServerUtilitiesConfig.ranks.override_commands || bukkitLoaded) {
                return;
            }
            ServerCommandManager manager = (ServerCommandManager)Ranks.INSTANCE.universe.server.func_71187_D();
            ArrayList<ICommand> commands = new ArrayList<ICommand>(ATHelper.getCommandSet((CommandHandler)manager));
            ATHelper.getCommandSet((CommandHandler)manager).clear();
            manager.func_71555_a().clear();
            Iterator iterator = commands.iterator();
            while (iterator.hasNext()) {
                ICommand command;
                ModContainer container = CommonUtils.getModContainerForClass((command = (ICommand)iterator.next()).getClass());
                manager.func_71560_a(CommandOverride.create(command, container == null ? "command" : "command." + container.getModId(), container));
            }
            ArrayList<CommandOverride> ocommands = new ArrayList<CommandOverride>(Ranks.INSTANCE.commands.values());
            ocommands.sort((o1, o2) -> {
                int i = Boolean.compare(o1.modContainer != null, o2.modContainer != null);
                return i == 0 ? o1.node.compareTo(o2.node) : i;
            });
            for (CommandOverride c : ocommands) {
                Ranks.INSTANCE.commands.put(c.node, c);
            }
            ServerUtilities.LOGGER.info("Overridden {} commands", new Object[]{manager.func_71555_a().size()});
        }
    }

    public void onServerStopping(FMLServerStoppingEvent event) {
        Universe.onServerStopping(event);
        Aurora.stop();
    }

    public void registerTasks() {
        Universe universe = Universe.get();
        universe.scheduleTask(new DecayTask(), ServerUtilitiesConfig.world.chunk_claiming);
        universe.scheduleTask(new CleanupTask(), ServerUtilitiesConfig.tasks.cleanup.enabled);
        universe.scheduleTask(new BackupTask(), ServerUtilitiesConfig.backups.enable_backups);
        if (ServerUtilitiesConfig.auto_shutdown.enabled && ServerUtilitiesConfig.auto_shutdown.times.length > 0 && (ServerUtilitiesConfig.auto_shutdown.enabled_singleplayer || universe.server.func_71262_S())) {
            universe.scheduleTask(new ShutdownTask());
        }
    }

    public boolean onReload(ServerReloadEvent event) {
        if (event.getUniverse() != null) {
            ServerUtilitiesLeaderboards.loadLeaderboards();
        }
        return true;
    }

    public void handleClientMessage(MessageToClient message) {
    }

    public long getWorldTime() {
        return ServerUtils.getServerWorld().func_82737_E();
    }

    static {
        try {
            ConfigurationManager.registerConfig(ServerUtilitiesConfig.class);
        }
        catch (ConfigException e) {
            throw new RuntimeException(e);
        }
    }

    public static class EditingConfig {
        public final ConfigGroup group;
        public final IConfigCallback callback;

        public EditingConfig(ConfigGroup g, IConfigCallback c) {
            this.group = g;
            this.callback = c;
        }
    }
}

