/*
 * Decompiled with CFR 0.152.
 */
package blockrenderer6343.integration.nei;

import blockrenderer6343.integration.nei.GUI_MultiblockHandler;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.RecipeCatalysts;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;

public abstract class MultiblockHandler
extends TemplateRecipeHandler {
    public static final int CANDIDATE_SLOTS_X = 150;
    public static final int CANDIDATE_SLOTS_Y = 20;
    public static final int CANDIDATE_IN_COlUMN = 6;
    protected List<ItemStack> ingredients = new ArrayList<ItemStack>();
    protected final List<PositionedStack> positionedIngredients = new ArrayList<PositionedStack>();
    protected int lastRecipeHeight;
    protected RecipeCacher recipeCacher = new RecipeCacher();
    protected GUI_MultiblockHandler<?> guiHandler;

    public MultiblockHandler(GUI_MultiblockHandler<?> guiHandler) {
        this.guiHandler = guiHandler;
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
    }

    public void loadCraftingRecipes(ItemStack result) {
        this.tryLoadingMultiblock(result);
        super.loadCraftingRecipes(result);
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        this.tryLoadingMultiblock(ingredient);
        super.loadUsageRecipes(ingredient);
    }

    public void drawBackground(int recipe) {
        super.drawBackground(recipe);
        this.guiHandler.drawMultiblock();
        if (this.lastRecipeHeight != RecipeCatalysts.getHeight()) {
            this.resetPositionedIngredients();
            this.lastRecipeHeight = RecipeCatalysts.getHeight();
        }
    }

    public String getGuiTexture() {
        return "blockrenderer6343:textures/void.png";
    }

    public String getRecipeName() {
        return StatCollector.func_74838_a((String)"blockrenderer6343.multiblock.structure");
    }

    protected abstract void tryLoadingMultiblock(ItemStack var1);

    protected GUI_MultiblockHandler<?> getGuiHandler() {
        return this.guiHandler;
    }

    public void resetPositionedIngredients() {
        this.positionedIngredients.clear();
        int rowCount = RecipeCatalysts.getRowCount((int)RecipeCatalysts.getHeight(), (int)this.ingredients.size());
        for (int index = 0; index < this.ingredients.size(); ++index) {
            ItemStack catalyst = this.ingredients.get(index);
            int column = index / rowCount;
            int row = index % rowCount;
            this.positionedIngredients.add(new PositionedStack((Object)catalyst, -column * 16, row * 16));
        }
        Map catalystMap = RecipeCatalysts.getPositionedRecipeCatalystMap();
        catalystMap.put(this.getOverlayIdentifier(), this.positionedIngredients);
    }

    public void setResults(List<List<ItemStack>> results) {
        this.arecipes.clear();
        this.recipeCacher.setResults(results);
        this.arecipes.add(this.recipeCacher);
    }

    public class RecipeCacher
    extends TemplateRecipeHandler.CachedRecipe {
        private final List<PositionedStack> positionedResults;

        public RecipeCacher() {
            super((TemplateRecipeHandler)MultiblockHandler.this);
            this.positionedResults = new ArrayList<PositionedStack>();
        }

        public void setResults(List<List<ItemStack>> results) {
            this.positionedResults.clear();
            int columnCount = results.size() / 6 + 1;
            int realCandidateInColumn = results.size() % columnCount == 0 ? results.size() / columnCount : results.size() / columnCount + 1;
            for (int i = 0; i < results.size(); ++i) {
                PositionedStack result = new PositionedStack(results.get(i), 150 - (columnCount - 1) * 18 + i / realCandidateInColumn * 18, 20 + i % realCandidateInColumn * 18);
                result.generatePermutations();
                this.positionedResults.add(result);
            }
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getCycledIngredients(MultiblockHandler.this.cycleticks / 20, this.positionedResults);
        }
    }
}

