/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.core.visitor;

import com.cleanroommc.modularui.core.ModularUICore;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;

public class PacketByteBufferVisitor
extends ClassVisitor
implements Opcodes {
    public static final String PACKET_BUFFER_CLASS = "net.minecraft.network.PacketBuffer";
    private static final String WRITE_ITEMSTACK_METHOD = ModularUICore.isDevEnv() ? "writeItemStackToBuffer" : "a";
    private static final String READ_ITEMSTACK_METHOD = ModularUICore.isDevEnv() ? "readItemStackFromBuffer" : "c";
    private static final String WRITE_ITEMSTACK_DESC = ModularUICore.isDevEnv() ? "(Lnet/minecraft/item/ItemStack;)V" : "(Ladd;)V";
    private static final String READ_ITEMSTACK_DESC = ModularUICore.isDevEnv() ? "()Lnet/minecraft/item/ItemStack;" : "()Ladd;";
    private static final String WRITE_VAR_INT_METHOD = ModularUICore.isDevEnv() ? "writeVarIntToBuffer" : "func_150787_b";
    private static final String READ_VAR_INT_METHOD = ModularUICore.isDevEnv() ? "readVarIntFromBuffer" : "func_150792_a";

    public PacketByteBufferVisitor(ClassVisitor cv) {
        super(327680, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (WRITE_ITEMSTACK_METHOD.equals(name) && WRITE_ITEMSTACK_DESC.equals(desc) || READ_ITEMSTACK_METHOD.equals(name) && READ_ITEMSTACK_DESC.equals(desc)) {
            ModularUICore.LOGGER.debug("Start patching " + name);
            return new ReadWriteItemStackVisitor(mv);
        }
        return mv;
    }

    private static class ReadWriteItemStackVisitor
    extends MethodVisitor {
        private boolean skipPop;

        public ReadWriteItemStackVisitor(MethodVisitor mv) {
            super(327680, mv);
        }

        public void visitInsn(int opcode) {
            if (this.skipPop && opcode == 87) {
                ModularUICore.LOGGER.debug("Skipped POP");
                this.skipPop = false;
                return;
            }
            super.visitInsn(opcode);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if ("writeByte".equals(name)) {
                name = WRITE_VAR_INT_METHOD;
                desc = "(I)V";
                ModularUICore.LOGGER.debug("Patched writeByte");
                this.skipPop = true;
            } else if ("readByte".equals(name)) {
                name = READ_VAR_INT_METHOD;
                desc = "()I";
                ModularUICore.LOGGER.debug("Patched readByte");
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

