/*
 * Decompiled with CFR 0.152.
 */
package ca.wescook.nutrition.events;

import ca.wescook.nutrition.gui.GuiButtonNutrition;
import ca.wescook.nutrition.gui.NutritionGui;
import ca.wescook.nutrition.mixin.GuiContainerAccessor;
import ca.wescook.nutrition.utility.Config;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraftforge.client.event.GuiScreenEvent;

public class EventNutritionButton {
    private GuiButtonNutrition buttonNutrition;

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiOpen(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen gui = event.gui;
        if (!(gui instanceof GuiInventory)) {
            return;
        }
        int[] pos = this.calculateButtonPosition(gui);
        int x = pos[0];
        int y = pos[1];
        this.buttonNutrition = new GuiButtonNutrition(x, y);
        event.buttonList.add(this.buttonNutrition);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent.Post event) {
        if (!(event.gui instanceof GuiInventory)) {
            return;
        }
        if (event.button.equals((Object)this.buttonNutrition)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new NutritionGui(event.gui));
        } else {
            int[] pos = this.calculateButtonPosition(event.gui);
            int xPosition = pos[0];
            int yPosition = pos[1];
            this.buttonNutrition.setPosition(xPosition, yPosition);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private int[] calculateButtonPosition(GuiScreen gui) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (Config.buttonOrigin.equals("screen")) {
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution scaledResolution = new ScaledResolution(mc, mc.field_71443_c, mc.field_71440_d);
            width = scaledResolution.func_78326_a();
            height = scaledResolution.func_78328_b();
        } else if (Config.buttonOrigin.equals("gui") && gui instanceof GuiInventory) {
            width = ((GuiContainerAccessor)gui).nutrition$getXSize();
            height = ((GuiContainerAccessor)gui).nutrition$getYSize();
        }
        switch (Config.buttonAnchor) {
            case "top": {
                x = width / 2;
                y = 0;
                break;
            }
            case "right": {
                x = width;
                y = height / 2;
                break;
            }
            case "bottom": {
                x = width / 2;
                y = height;
                break;
            }
            case "left": {
                x = 0;
                y = height / 2;
                break;
            }
            case "top-left": {
                x = 0;
                y = 0;
                break;
            }
            case "top-right": {
                x = width;
                y = 0;
                break;
            }
            case "bottom-right": {
                x = width;
                y = height;
                break;
            }
            case "bottom-left": {
                x = 0;
                y = height;
                break;
            }
            case "center": {
                x = width / 2;
                y = height / 2;
            }
        }
        if (Config.buttonOrigin.equals("gui") && gui instanceof GuiInventory) {
            x += ((GuiContainerAccessor)gui).nutrition$getGuiLeft();
            y += ((GuiContainerAccessor)gui).nutrition$getGuiTop();
        }
        return new int[]{x += Config.buttonXPosition, y += Config.buttonYPosition};
    }
}

