/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.apiculture.multiblock.AlvearyController;
import forestry.core.utils.DamageSourceForestry;
import forestry.core.utils.vect.Vect;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class AlleleEffectRadioactive
extends AlleleEffectThrottled {
    private static final DamageSource damageSourceBeeRadioactive = new DamageSourceForestry("bee.radioactive");

    public AlleleEffectRadioactive() {
        super("radioactive", true, 40, false, true);
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        this.harmEntities(genome, housing);
        if (this.isMobGriefingEnabled(housing)) {
            AlleleEffectRadioactive.destroyEnvironment(genome, housing);
        }
        return storedData;
    }

    private boolean isMobGriefingEnabled(IBeeHousing housing) {
        return housing.getWorld().func_82736_K().func_82766_b("mobGriefing");
    }

    private void harmEntities(IBeeGenome genome, IBeeHousing housing) {
        List<EntityLivingBase> entities = AlleleEffectRadioactive.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entity : entities) {
            int damage = 8;
            int count = BeeManager.armorApiaristHelper.wearsItems(entity, this.getUID(), true);
            if ((damage -= count * 2) <= 0) continue;
            entity.func_70097_a(damageSourceBeeRadioactive, (float)damage);
        }
    }

    private static void destroyEnvironment(IBeeGenome genome, IBeeHousing housing) {
        World world = housing.getWorld();
        Random rand = world.field_73012_v;
        int[] areaAr = genome.getTerritory();
        Vect area = new Vect(areaAr).multiply(2);
        Vect offset = area.multiply(-0.5f);
        Vect posHousing = new Vect(housing.getCoordinates());
        boolean isAlveary = housing instanceof AlvearyController;
        for (int i = 0; i < 20; ++i) {
            Vect randomPos = Vect.getRandomPositionInArea(rand, area);
            Vect posBlock = randomPos.add(posHousing).add(offset);
            if (AlleleEffectRadioactive.isInAlvearyProtectedArea(posHousing, posBlock) || (isAlveary ? posBlock.y == posHousing.y - 3 : posBlock.y == posHousing.y - 1)) continue;
            Block block = world.func_147439_a(posBlock.x, posBlock.y, posBlock.z);
            TileEntity tile = world.func_147438_o(posBlock.x, posBlock.y, posBlock.z);
            if (tile != null || block.func_149712_f(world, posBlock.x, posBlock.y, posBlock.z) < 0.0f || !world.func_72962_a(housing.getWorld().func_152378_a(housing.getOwner().getId()), posHousing.x, posHousing.y, posHousing.z)) continue;
            world.func_147468_f(posBlock.x, posBlock.y, posBlock.z);
            break;
        }
    }

    private static boolean isInAlvearyProtectedArea(Vect posHousing, Vect posBlock) {
        int startX = posHousing.x - 1;
        int endX = posHousing.x + 1;
        int startZ = posHousing.z - 1;
        int endZ = posHousing.z + 1;
        int startY = posHousing.y - 2;
        int endY = posHousing.y + 1;
        return posBlock.x >= startX && posBlock.x <= endX && posBlock.z >= startZ && posBlock.z <= endZ && posBlock.y >= startY && posBlock.y <= endY;
    }
}

