/*
 * Decompiled with CFR 0.152.
 */
package appeng.items.contents;

import appeng.api.config.PriorityCardMode;
import appeng.api.config.Settings;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.container.interfaces.IInventorySlotAware;
import appeng.helpers.IPriorityHost;
import appeng.items.tools.ToolPriorityCard;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class PriorityCardObject
implements IGuiItemObject,
IPriorityHost,
IInventorySlotAware,
IConfigurableObject {
    private final ItemStack stack;
    private final int slot;
    private final IConfigManager configManager;

    public PriorityCardObject(ItemStack stack, int slot) {
        this.stack = stack;
        this.slot = slot;
        this.configManager = this.createConfigManager();
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public int getPriority() {
        return ToolPriorityCard.getPriority(this.stack);
    }

    @Override
    public void setPriority(int newValue) {
        ToolPriorityCard.setPriority(this.stack, newValue);
    }

    public PriorityCardMode getMode() {
        return (PriorityCardMode)this.configManager.getSetting(Settings.PRIORITY_CARD_MODE);
    }

    public void setMode(PriorityCardMode newValue) {
        this.configManager.putSetting(Settings.PRIORITY_CARD_MODE, newValue);
    }

    @Override
    public int getInventorySlot() {
        return this.slot;
    }

    @Override
    public IConfigManager getConfigManager() {
        return this.configManager;
    }

    private IConfigManager createConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData(this.stack);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.PRIORITY_CARD_MODE, (Enum)PriorityCardMode.EDIT);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData(this.stack).func_74737_b());
        return out;
    }
}

